/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.config.EditModeConfig;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.JEIClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.config.WorldConfig;
import mezz.jei.config.sorting.IngredientTypeSortingConfig;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.ForgeModIdHelper;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IngredientSorter;
import mezz.jei.startup.JeiStarter;
import mezz.jei.startup.NetworkHandler;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLPaths;

public class ClientLifecycleHandler {
    final JeiStarter starter = new JeiStarter();
    final Textures textures;
    final IClientConfig clientConfig;
    final BookmarkConfig bookmarkConfig;
    final ModIdFormattingConfig modIdFormattingConfig;
    final IngredientFilterConfig ingredientFilterConfig;
    final WorldConfig worldConfig;
    final IModIdHelper modIdHelper;
    final IEditModeConfig editModeConfig;
    final RecipeCategorySortingConfig recipeCategorySortingConfig;
    final IIngredientSorter ingredientSorter;
    final List<IModPlugin> plugins;

    public ClientLifecycleHandler(NetworkHandler networkHandler, Textures textures) {
        File jeiConfigurationDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "jei");
        if (!jeiConfigurationDir.exists()) {
            try {
                if (!jeiConfigurationDir.mkdir()) {
                    throw new RuntimeException("Could not create config directory " + jeiConfigurationDir);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Could not create config directory " + jeiConfigurationDir, e);
            }
        }
        this.clientConfig = JEIClientConfig.clientConfig;
        this.ingredientFilterConfig = JEIClientConfig.filterConfig;
        this.modIdFormattingConfig = JEIClientConfig.modNameFormat;
        this.modIdHelper = new ForgeModIdHelper(this.clientConfig, this.modIdFormattingConfig);
        this.bookmarkConfig = new BookmarkConfig(jeiConfigurationDir);
        this.worldConfig = new WorldConfig(jeiConfigurationDir);
        this.editModeConfig = new EditModeConfig(jeiConfigurationDir);
        this.recipeCategorySortingConfig = new RecipeCategorySortingConfig(new File(jeiConfigurationDir, "recipe-category-sort-order.ini"));
        ModNameSortingConfig ingredientModNameSortingConfig = new ModNameSortingConfig(new File(jeiConfigurationDir, "ingredient-list-mod-sort-order.ini"));
        IngredientTypeSortingConfig ingredientTypeSortingConfig = new IngredientTypeSortingConfig(new File(jeiConfigurationDir, "ingredient-list-type-sort-order.ini"));
        this.ingredientSorter = new IngredientSorter(this.clientConfig, ingredientModNameSortingConfig, ingredientTypeSortingConfig);
        ErrorUtil.setModIdHelper(this.modIdHelper);
        ErrorUtil.setWorldConfig(this.worldConfig);
        KeyBindings.init();
        if (Internal.getReloadListener() == null) {
            throw new RuntimeException("Something went wrong when registering JEI's reload listener.");
        }
        Internal.getReloadListener().update(this);
        EventBusHelper.addListener(this, WorldEvent.Save.class, event -> this.worldConfig.onWorldSave());
        EventBusHelper.addListener(this, ClientPlayerNetworkEvent.LoggedOutEvent.class, event -> {
            for (ServerType type : ServerType.values()) {
                type.hasRan = false;
            }
        });
        for (ServerType type : ServerType.values()) {
            EventBusHelper.addListener(this, type.listenerClass, event -> {
                if (type.shouldRun()) {
                    this.setupJEI();
                }
            });
        }
        this.plugins = AnnotatedInstanceUtil.getModPlugins();
        networkHandler.createClientPacketHandler(this.worldConfig);
        this.textures = textures;
    }

    public void setupJEI() {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            Connection networkManager = connection.m_6198_();
            this.worldConfig.syncWorldConfig(networkManager);
        }
        this.modIdFormattingConfig.checkForModNameFormatOverride();
        this.startJEI();
        EventBusHelper.post(new PlayerJoinedWorldEvent());
    }

    public void startJEI() {
        if (Minecraft.m_91087_().f_91073_ != null) {
            Preconditions.checkNotNull((Object)this.textures);
            this.starter.start(this.plugins, this.textures, this.clientConfig, this.editModeConfig, this.ingredientFilterConfig, this.worldConfig, this.bookmarkConfig, this.modIdHelper, this.recipeCategorySortingConfig, this.ingredientSorter);
        }
    }

    private static enum ServerType {
        FIRST_CONNECTION(TagsUpdatedEvent.class),
        INTEGRATED_OR_POST_RELOAD(RecipesUpdatedEvent.class);

        public boolean hasRan;
        public final Class<? extends Event> listenerClass;

        private ServerType(Class<? extends Event> listenerClass) {
            this.listenerClass = listenerClass;
        }

        public boolean shouldRun() {
            ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
            boolean isIntegrated = Minecraft.m_91087_().m_91090_();
            if (connection == null || isIntegrated) {
                this.hasRan = true;
                return this == INTEGRATED_OR_POST_RELOAD;
            }
            if (this == INTEGRATED_OR_POST_RELOAD) {
                if (this.hasRan) {
                    return true;
                }
                this.hasRan = true;
                return false;
            }
            if (this.hasRan) {
                return false;
            }
            this.hasRan = true;
            return true;
        }
    }
}

