/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.mojang.blaze3d.platform.InputConstants;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.ServerInfo;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.network.packets.PacketSetHotbarItemStack;
import mezz.jei.util.CommandUtilServer;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveMode;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private CommandUtil() {
    }

    public static void giveStack(ItemStack itemStack, InputConstants.Key input, IClientConfig clientConfig) {
        GiveMode giveMode = clientConfig.getGiveMode();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            LOGGER.error("Can't give stack, there is no player");
            return;
        }
        if (minecraft.f_91080_ instanceof CreativeModeInventoryScreen && giveMode == GiveMode.MOUSE_PICKUP) {
            int amount = GiveMode.getStackSize(giveMode, itemStack, input);
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            CommandUtilServer.mousePickupItemStack((Player)player, sendStack);
        } else if (ServerInfo.isJeiOnServer()) {
            int amount = GiveMode.getStackSize(giveMode, itemStack, input);
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            PacketGiveItemStack packet = new PacketGiveItemStack(sendStack, giveMode);
            Network.sendPacketToServer(packet);
        } else {
            int amount = GiveMode.getStackSize(GiveMode.INVENTORY, itemStack, input);
            CommandUtil.giveStackVanilla(itemStack, amount);
        }
    }

    public static void setHotbarStack(ItemStack itemStack, int hotbarSlot) {
        if (ServerInfo.isJeiOnServer()) {
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)itemStack.m_41741_());
            PacketSetHotbarItemStack packet = new PacketSetHotbarItemStack(sendStack, hotbarSlot);
            Network.sendPacketToServer(packet);
        }
    }

    private static void giveStackVanilla(ItemStack itemStack, int amount) {
        if (itemStack.m_41619_()) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Empty itemStack: {}", (Object)stackInfo, (Object)new IllegalArgumentException());
            return;
        }
        Item item = itemStack.m_41720_();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        ErrorUtil.checkNotNull(itemResourceLocation, "itemStack.getItem().getRegistryName()");
        LocalPlayer sender = Minecraft.m_91087_().f_91074_;
        if (sender != null) {
            if (sender.m_20203_().m_6761_(2)) {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            } else if (sender.m_7500_()) {
                CommandUtil.sendCreativeInventoryActions(sender, itemStack, amount);
            } else {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            }
        }
    }

    private static void sendGiveAction(LocalPlayer sender, ItemStack itemStack, int amount) {
        Object[] commandParameters = CommandUtilServer.getGiveCommandParameters((Player)sender, itemStack, amount);
        String fullCommand = "/give " + StringUtils.join((Object[])commandParameters, (String)" ");
        CommandUtil.sendChatMessage(sender, fullCommand);
    }

    private static void sendChatMessage(LocalPlayer sender, String chatMessage) {
        if (chatMessage.length() <= 256) {
            sender.m_108739_(chatMessage);
        } else {
            TranslatableComponent errorMessage = new TranslatableComponent("jei.chat.error.command.too.long");
            errorMessage.m_7383_().m_131157_(ChatFormatting.RED);
            sender.m_5661_((Component)errorMessage, false);
            TextComponent chatMessageComponent = new TextComponent(chatMessage);
            chatMessageComponent.m_7383_().m_131157_(ChatFormatting.RED);
            sender.m_5661_((Component)chatMessageComponent, false);
        }
    }

    private static void sendCreativeInventoryActions(LocalPlayer sender, ItemStack stack, int amount) {
        for (int i = 0; i < sender.m_150109_().f_35974_.size() && amount > 0; ++i) {
            ItemStack currentStack = (ItemStack)sender.m_150109_().f_35974_.get(i);
            if (currentStack.m_41619_()) {
                ItemStack sendAllRemaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
                CommandUtil.sendSlotPacket(sendAllRemaining, i);
                amount = 0;
                continue;
            }
            if (!currentStack.m_41656_(stack) || currentStack.m_41741_() <= currentStack.m_41613_()) continue;
            int canAdd = Math.min(currentStack.m_41741_() - currentStack.m_41613_(), amount);
            ItemStack fillRemainingSpace = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(canAdd + currentStack.m_41613_()));
            CommandUtil.sendSlotPacket(fillRemainingSpace, i);
            amount -= canAdd;
        }
        if (amount > 0) {
            ItemStack toDrop = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
            CommandUtil.sendSlotPacket(toDrop, -1);
        }
    }

    private static void sendSlotPacket(ItemStack stack, int mainInventorySlot) {
        if (mainInventorySlot < 9 && mainInventorySlot != -1) {
            mainInventorySlot += 36;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        MultiPlayerGameMode playerController = minecraft.f_91072_;
        if (playerController != null) {
            playerController.m_105241_(stack, mainInventorySlot);
        } else {
            LOGGER.error("Cannot send slot packet, minecraft.playerController is null");
        }
    }
}

