/*
 * Decompiled with CFR 0.152.
 */
package stepsword.jousting.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import stepsword.jousting.item.ModItems;
import stepsword.jousting.render.LanceRenderer;

public class RenderBaseItem {
    public static void registerOtherModels() {
        RenderBaseItem.initlances();
        for (ResourceLocation r : LanceRenderer.lancemodels.values()) {
            ModelLoader.addSpecialModel((ResourceLocation)r);
        }
    }

    public static void initlances() {
        LanceRenderer.lancemodels.put(ModItems.woodLance, LanceRenderer.lance_wood);
        LanceRenderer.lancemodels.put(ModItems.ironLance, LanceRenderer.lance_iron);
        LanceRenderer.lancemodels.put(ModItems.goldLance, LanceRenderer.lance_gold);
        LanceRenderer.lancemodels.put(ModItems.diamondLance, LanceRenderer.lance_diamond);
        LanceRenderer.lancemodels.put(ModItems.emeraldLance, LanceRenderer.lance_emerald);
    }

    public static void render(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int var1, int var2, ResourceLocation rl) {
        RenderBaseItem.render(stack, matrix, buffer, var1, var2, rl, null, false);
    }

    public static void render(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int var1, int var2, ResourceLocation rl, boolean bright) {
        RenderBaseItem.render(stack, matrix, buffer, var1, var2, rl, null, bright);
    }

    public static void render(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int var1, int var2, ResourceLocation rl, RenderType type, boolean bright) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderType rendertype = RenderTypeLookup.func_228389_a_((ItemStack)stack);
        IBakedModel ibakedmodel = mc.func_209506_al().getModel(rl);
        RenderType rendertype1 = Objects.equals(rendertype, Atlases.func_228784_i_()) ? Atlases.func_228785_j_() : rendertype;
        if (type != null) {
            rendertype1 = type;
        }
        IVertexBuilder ivertexbuilder = RenderBaseItem.getBuffer(buffer, rendertype1, true, stack.func_77962_s());
        RenderBaseItem.renderModel(ibakedmodel, stack, var1, var2, matrix, ivertexbuilder);
    }

    public static IVertexBuilder getBuffer(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean glintIn) {
        IVertexBuilder tp = isItemIn ? bufferIn.getBuffer(RenderType.func_228653_j_()) : bufferIn.getBuffer(RenderType.func_228655_k_());
        if (glintIn && tp != bufferIn.getBuffer(renderTypeIn)) {
            return VertexBuilderUtils.func_227915_a_((IVertexBuilder)tp, (IVertexBuilder)bufferIn.getBuffer(renderTypeIn));
        }
        return bufferIn.getBuffer(renderTypeIn);
    }

    public static void renderModel(IBakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IVertexBuilder bufferIn) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            Minecraft.func_71410_x().func_175599_af().func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        Minecraft.func_71410_x().func_175599_af().func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn);
    }
}

