/*
 * Decompiled with CFR 0.152.
 */
package stepsword.jousting.item;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.UseAction;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import stepsword.jousting.JoustingMod;
import stepsword.jousting.item.ItemBase;
import stepsword.jousting.item.ModItems;
import stepsword.jousting.render.LanceRenderer;

public class ItemLance
extends ItemBase {
    private Supplier<Double> attackDamage;
    private Supplier<Double> weight;
    private Supplier<Integer> durability;
    public static final UUID speedlance = UUID.fromString("91AEAA56-377B-4498-936B-2E8F20080635");

    public ItemLance(String name, Supplier<Integer> getDurability, Supplier<Double> getDamage, Supplier<Double> getWeight) {
        super(name, new Item.Properties().func_200916_a(ModItems.JOUSTING_CREATIVE_TAB).func_200918_c(getDurability.get().intValue()).setISTER(() -> LanceRenderer::new));
        this.attackDamage = getDamage;
        this.weight = getWeight;
        this.durability = getDurability;
    }

    public ItemLance(String name, ItemGroup group, Supplier<Integer> getDurability, Supplier<Double> getDamage, Supplier<Double> getWeight, Supplier<Callable<ItemStackTileEntityRenderer>> ister) {
        super(name, new Item.Properties().func_200916_a(group).func_200918_c(getDurability.get().intValue()).setISTER(ister));
        this.attackDamage = getDamage;
        this.weight = getWeight;
        this.durability = getDurability;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        player.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(handIn));
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (count <= 4 && player.field_70170_p.field_72995_K && player instanceof PlayerEntity) {
            JoustingMod.proxy.stopUsing((PlayerEntity)player);
        }
        if (!player.field_70170_p.field_72995_K && player.func_184187_bx() != null) {
            double motion = 1.0;
            if (player.func_184187_bx() instanceof LivingEntity) {
                float z = (float)this.func_77626_a(stack) - (float)count;
                double w = this.getWeight(stack);
                ItemLance.addspeed((LivingEntity)player.func_184187_bx(), true, (1.0f + z / 120.0f) * (1.0f + z / 120.0f) / 2.0f);
                ModifiableAttributeInstance attr = ((LivingEntity)player.func_184187_bx()).func_110148_a(Attributes.field_233821_d_);
                if (attr != null) {
                    motion = attr.func_111126_e();
                }
            }
            AxisAlignedBB aabb = player.func_174813_aQ();
            aabb = aabb.func_111270_a(player.func_184187_bx().func_174813_aQ()).func_186662_g(motion);
            List entities = player.field_70170_p.func_175674_a((Entity)player, aabb, a -> a instanceof LivingEntity && a != player.func_184187_bx());
            Vector3d v = player.func_70040_Z();
            double len = motion;
            v = v.func_72432_b();
            ArrayList<AxisAlignedBB> lst = new ArrayList<AxisAlignedBB>();
            Vector3d ppos = player.func_213303_ch();
            int m = 0;
            while ((double)m < len) {
                Vector3d r = ppos.func_178787_e(v.func_186678_a((double)m));
                float d = 1.0f;
                lst.add(new AxisAlignedBB(r.field_72450_a - (double)d, r.field_72448_b - (double)(d * 2.0f), r.field_72449_c - (double)d, r.field_72450_a + (double)d, r.field_72448_b + (double)(d * 2.0f), r.field_72449_c + (double)d));
                ++m;
            }
            for (Entity e : entities) {
                if (!(e instanceof LivingEntity)) continue;
                AxisAlignedBB bb = e.func_174813_aQ();
                boolean intersects = false;
                player.func_213303_ch();
                for (int m2 = 0; m2 < lst.size(); ++m2) {
                    AxisAlignedBB q = (AxisAlignedBB)lst.get(m2);
                    if (!q.func_72326_a(bb)) continue;
                    intersects = true;
                }
                if (!intersects) continue;
                if (!(((LivingEntity)e).func_184607_cu().func_77973_b() instanceof ShieldItem)) {
                    Vector3d kv;
                    if (player instanceof PlayerEntity) {
                        this.attackTargetEntityWithCurrentItem(e, (PlayerEntity)player);
                        kv = player.func_70040_Z().func_72432_b();
                        ((LivingEntity)e).func_233627_a_((float)this.getWeight(stack), -kv.field_72450_a, -kv.field_72449_c);
                    } else {
                        e.func_70097_a(DamageSource.func_76358_a((LivingEntity)player), (float)this.getAttackDamage(stack));
                        kv = player.func_70040_Z().func_72432_b();
                        ((LivingEntity)e).func_233627_a_((float)this.getWeight(stack), -kv.field_72450_a, -kv.field_72449_c);
                    }
                    stack.func_222118_a(1, player, a -> {});
                } else {
                    stack.func_222118_a(30, player, a -> {});
                }
                if (e.func_184187_bx() != null) {
                    if (((LivingEntity)e).func_184614_ca().func_77973_b() instanceof ItemLance) {
                        ItemLance.joust((LivingEntity)e, player);
                    } else {
                        e.func_233575_bb_();
                    }
                }
                if (e.func_184182_bu().isEmpty()) continue;
                for (Entity passenger : e.func_184182_bu()) {
                    if (((LivingEntity)passenger).func_184614_ca().func_77973_b() instanceof ItemLance && ((LivingEntity)passenger).func_184607_cu().func_77973_b() instanceof ItemLance) {
                        ItemLance.joust((LivingEntity)passenger, player);
                        continue;
                    }
                    passenger.func_233575_bb_();
                }
            }
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return this.durability.get();
    }

    public void func_77615_a(ItemStack p_77615_1_, World p_77615_2_, LivingEntity player, int p_77615_4_) {
        if (!player.field_70170_p.field_72995_K) {
            if (player.func_184187_bx() instanceof LivingEntity) {
                double w = this.getWeight(player.func_184614_ca());
                ItemLance.addspeed((LivingEntity)player.func_184187_bx(), false, (float)(1.0 + 1.0 / w));
            }
            if (player instanceof PlayerEntity) {
                ((PlayerEntity)player).func_184811_cZ().func_185145_a(p_77615_1_.func_77973_b(), 40);
            }
        }
        super.func_77615_a(p_77615_1_, p_77615_2_, player, p_77615_4_);
    }

    public static void joust(LivingEntity e1, LivingEntity e2) {
        if (e1.func_184614_ca().func_77973_b() instanceof ItemLance && e2.func_184614_ca().func_77973_b() instanceof ItemLance) {
            ItemLance lance1 = (ItemLance)e1.func_184614_ca().func_77973_b();
            ItemLance lance2 = (ItemLance)e2.func_184614_ca().func_77973_b();
            if (e1.func_184187_bx() instanceof LivingEntity && e2.func_184187_bx() instanceof LivingEntity) {
                double horse1 = ((LivingEntity)e1.func_184187_bx()).func_110148_a(Attributes.field_233821_d_).func_111126_e();
                double horse2 = ((LivingEntity)e1.func_184187_bx()).func_110148_a(Attributes.field_233821_d_).func_111126_e();
                double val1 = horse1 * 2.0 + lance1.getAttackDamage(e1.func_184614_ca()) / 4.0;
                double val2 = horse2 * 2.0 + lance2.getAttackDamage(e2.func_184614_ca()) / 4.0;
                if (e2.func_184592_cb().func_77973_b() instanceof ShieldItem) {
                    e1.func_184614_ca().func_222118_a(50, e1, a -> {});
                    val1 -= lance1.getAttackDamage(e1.func_184614_ca()) / 8.0;
                }
                if (e1.func_184592_cb().func_77973_b() instanceof ShieldItem) {
                    e2.func_184614_ca().func_222118_a(50, e2, a -> {});
                    val2 -= lance2.getAttackDamage(e1.func_184614_ca()) / 8.0;
                }
                if (val1 > val2) {
                    e2.func_233575_bb_();
                } else if (val2 > val1) {
                    e1.func_233575_bb_();
                } else if (e1.func_70681_au().nextBoolean()) {
                    e1.func_233575_bb_();
                } else {
                    e2.func_233575_bb_();
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        Item item = stack.func_77973_b();
        if (item instanceof ItemLance) {
            ItemLance lance = (ItemLance)item;
            DecimalFormat df = new DecimalFormat("#.#");
            String w = df.format(this.getWeight(stack));
            String a = df.format(this.getAttackDamage(stack));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + new TranslationTextComponent("jousting.lance.weight").getString() + ": " + w));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + new TranslationTextComponent("jousting.lance.attackdamage").getString() + ": " + a));
        }
    }

    public static void addspeed(LivingEntity living, boolean add, float s) {
        AttributeModifier a = new AttributeModifier(speedlance, "lance_speed", (double)s, AttributeModifier.Operation.MULTIPLY_TOTAL);
        ModifiableAttributeInstance attr = living.func_110148_a(Attributes.field_233821_d_);
        if (attr != null) {
            boolean hasSpeed = attr.func_180374_a(a);
            attr.func_233770_c_(speedlance);
            if (add) {
                attr.func_233769_c_(a);
            }
        }
    }

    public double getAttackDamage(ItemStack stack) {
        return this.attackDamage.get();
    }

    public double getWeight(ItemStack stack) {
        return this.weight.get();
    }

    public int func_77626_a(ItemStack stack) {
        return (int)(120.0 / this.getWeight(stack));
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.NONE;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.canApplyAtEnchantingTable(new ItemStack((IItemProvider)Items.field_151048_u));
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity, PlayerEntity player) {
        if (!ForgeHooks.onPlayerAttackTarget((PlayerEntity)player, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)player)) {
            float f = (float)this.getAttackDamage(player.func_184614_ca());
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (CreatureAttribute)CreatureAttribute.field_223222_a_);
            player.func_184821_cY();
            if (f > 0.0f || f1 > 0.0f) {
                int i = 0;
                i += EnchantmentHelper.func_77501_a((LivingEntity)player);
                f += f1;
                boolean flag3 = false;
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.func_90036_a((LivingEntity)player);
                if (targetEntity instanceof LivingEntity) {
                    f4 = ((LivingEntity)targetEntity).func_110143_aJ();
                    if (j > 0 && !targetEntity.func_70027_ad()) {
                        flag4 = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                Vector3d vector3d = targetEntity.func_213322_ci();
                boolean flag5 = targetEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), f);
                if (flag5) {
                    if (i > 0 && targetEntity instanceof LivingEntity) {
                        Vector3d kv = player.func_213303_ch().func_178788_d(targetEntity.func_213303_ch());
                        ((LivingEntity)targetEntity).func_233627_a_((float)this.getWeight(player.func_184614_ca()), kv.field_72450_a, kv.field_72449_c);
                    }
                    if (targetEntity instanceof ServerPlayerEntity && targetEntity.field_70133_I) {
                        ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.func_213317_d(vector3d);
                    }
                    if (!flag3) {
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                    }
                    player.func_130011_c(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((LivingEntity)player, (Entity)targetEntity);
                    ItemStack itemstack1 = player.func_184614_ca();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPartEntity) {
                        entity = ((EnderDragonPartEntity)targetEntity).field_213852_b;
                    }
                    if (!player.field_70170_p.field_72995_K && !itemstack1.func_190926_b() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.func_77946_l();
                        itemstack1.func_77961_a((LivingEntity)entity, player);
                        if (itemstack1.func_190926_b()) {
                            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copy, (Hand)Hand.MAIN_HAND);
                            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)targetEntity).func_110143_aJ();
                        player.func_195067_a(Stats.field_188111_y, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            targetEntity.func_70015_d(j * 4);
                        }
                        if (player.field_70170_p instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226283_e_(0.5), targetEntity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.func_71020_j(0.1f);
                } else {
                    player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }
}

