/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.kehaanpets.item;

import com.lclc98.kehaanpets.loader.KehaanPetsLoader;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemKehaanPet
extends Item {
    private static final String TAG_COMPOUND_HEALER = "kehaanpets";
    private static final String TAG_LAST_FED = "lastFed";

    public ItemKehaanPet() {
        this.func_77655_b("kehaanpets.kehaan_pet");
        this.setRegistryName(TAG_COMPOUND_HEALER, "kehaan_pet");
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        NBTTagCompound tag;
        long lastFed;
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        long currentTime = worldIn.func_82737_E();
        if (this.canUse(currentTime, lastFed = (tag = itemstack.func_190925_c(TAG_COMPOUND_HEALER)).func_74763_f(TAG_LAST_FED))) {
            ItemStack consumable = KehaanPetsLoader.CONFIG.getConsumable();
            if (this.consumeItem(playerIn, consumable)) {
                tag.func_74772_a(TAG_LAST_FED, currentTime);
                playerIn.func_191521_c(this.getRandomCraftableItem());
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("kehaan_pet.kehaan_pet.no_food", new Object[]{I18n.func_135052_a((String)(consumable.func_77977_a() + ".name"), (Object[])new Object[0])}), true);
        } else {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("kehaan_pet.kehaan_pet.cooldown", new Object[]{this.getRemaining(currentTime, lastFed)}), true);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public boolean consumeItem(EntityPlayer player, ItemStack consumable) {
        NonNullList inv = player.field_71071_by.field_70462_a;
        for (ItemStack stack : inv) {
            if (!stack.func_77969_a(consumable)) continue;
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public ItemStack getRandomCraftableItem() {
        IForgeRegistry recipeList = ForgeRegistries.RECIPES;
        Set randomRecipe = ForgeRegistries.RECIPES.getKeys();
        ResourceLocation key = randomRecipe.stream().skip(new Random().nextInt(randomRecipe.size())).findFirst().orElse(null);
        if (key == null) {
            return this.getRandomCraftableItem();
        }
        IRecipe recipe = (IRecipe)recipeList.getValue(key);
        if (recipe == null) {
            return this.getRandomCraftableItem();
        }
        return recipe.func_77571_b();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (worldIn != null) {
            long lastFed;
            NBTTagCompound tagHealer = stack.func_190925_c(TAG_COMPOUND_HEALER);
            long currentTime = worldIn.func_72820_D();
            if (!this.canUse(currentTime, lastFed = tagHealer.func_74763_f(TAG_LAST_FED))) {
                tooltip.add(I18n.func_135052_a((String)"pokehaancraftadd.healer.cooldown", (Object[])new Object[]{this.getRemaining(currentTime, lastFed)}));
            }
        }
    }

    public boolean canUse(long currentTime, long lastFed) {
        return lastFed == 0L || currentTime - lastFed >= (long)KehaanPetsLoader.CONFIG.cooldown;
    }

    public long getRemaining(long currentTime, long lastFed) {
        return ((long)KehaanPetsLoader.CONFIG.cooldown - (currentTime - lastFed)) / 20L;
    }
}

