/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.dialogs;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.premade.SubContainerEmpty;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.packet.gui.GuiLayerPacket;
import com.creativemd.littletiles.common.structure.animation.event.AnimationEvent;
import com.creativemd.littletiles.common.structure.animation.event.AnimationEventGuiParser;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiDoorEvents
extends SubGui {
    public GuiDoorEventsButton button;

    public SubGuiDoorEvents(GuiDoorEventsButton button) {
        this.button = button;
    }

    public static String getDisplayName(LittlePreviews previews, int childId) {
        String name = previews.getStructureName();
        if (name == null) {
            name = previews.hasStructure() ? previews.getStructureId() : "none";
        }
        return childId + ": " + name;
    }

    public void addEntry(@Nullable AnimationEvent event, String type) {
        final GuiScrollBox box = (GuiScrollBox)this.get("content");
        AnimationEventGuiParser parser = AnimationEvent.getParser(type);
        final GuiPanel panel = new GuiPanel(type, 2, 2, 158, parser.getHeight());
        panel.addControl(new GuiTextfield("tick", "" + (event != null ? event.getTick() : 0), 0, 0, 30, 10).setNumbersOnly().setCustomTooltip(new String[]{"tick"}));
        panel.addControl((GuiControl)new GuiButton("x", 145, 0, 6, 6){

            public void onClicked(int x, int y, int button) {
                box.removeControl((GuiControl)panel);
                SubGuiDoorEvents.this.reloadListBox();
            }
        });
        parser.createControls((GuiParent)panel, event, this.button.previews);
        box.addControl((GuiControl)panel);
        this.reloadListBox();
    }

    public void reloadListBox() {
        GuiScrollBox box = (GuiScrollBox)this.get("content");
        int height = 2;
        for (GuiControl control : box.controls) {
            control.posY = height;
            height += control.height + 2;
        }
    }

    public void createControls() {
        final GuiScrollBox box = new GuiScrollBox("content", 0, 0, 170, 110);
        this.controls.add(box);
        final GuiComboBox type = new GuiComboBox("type", 0, 120, 100, AnimationEvent.typeNamestranslated());
        this.controls.add(type);
        this.controls.add(new GuiButton("+", 110, 123, 10, 8){

            public void onClicked(int x, int y, int button) {
                SubGuiDoorEvents.this.addEntry(null, AnimationEvent.typeNames().get(type.index));
            }
        });
        for (AnimationEvent event : this.button.events) {
            this.addEntry(event, AnimationEvent.getId(event.getClass()));
        }
        this.controls.add(new GuiButton("save", 140, 143){

            public void onClicked(int x, int y, int button) {
                SubGuiDoorEvents.this.button.events.clear();
                for (GuiControl control : box.controls) {
                    if (!(control instanceof GuiPanel)) continue;
                    AnimationEventGuiParser parser = AnimationEvent.getParser(control.name);
                    GuiTextfield textfield = (GuiTextfield)((GuiPanel)control).get("tick");
                    AnimationEvent event = AnimationEvent.create(textfield.parseInteger(), control.name);
                    if ((event = parser.parse((GuiParent)control, event)) == null) continue;
                    SubGuiDoorEvents.this.button.events.add(event);
                }
                SubGuiDoorEvents.this.button.events.sort(null);
                SubGuiDoorEvents.this.closeGui();
                SubGuiDoorEvents.this.button.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)SubGuiDoorEvents.this.button));
            }
        });
        this.controls.add(new GuiButton("cancel", 0, 143){

            public void onClicked(int x, int y, int button) {
                SubGuiDoorEvents.this.closeGui();
            }
        });
    }

    public static class GuiDoorEventsButton
    extends GuiButton {
        public SubGuiDoorEvents gui;
        public LittlePreviews previews;
        public LittleDoorBase activator;
        public List<AnimationEvent> events;

        public GuiDoorEventsButton(String name, int x, int y, LittlePreviews previews, LittleDoorBase door) {
            super(name, GuiDoorEventsButton.translate((String)"gui.door.events"), x, y, 40, 7);
            this.previews = previews;
            this.activator = door;
            if (this.activator != null) {
                this.events = this.activator.events;
            }
            if (this.events == null) {
                this.events = new ArrayList<AnimationEvent>();
            }
        }

        public void onClicked(int x, int y, int button) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("dialog", true);
            SubGuiDoorEvents dialog = new SubGuiDoorEvents(this);
            dialog.gui = this.getParent().getOrigin().gui;
            PacketHandler.sendPacketToServer((CreativeCorePacket)new GuiLayerPacket(nbt, dialog.gui.getLayers().size() - 1, false));
            dialog.container = new SubContainerEmpty(this.getPlayer());
            dialog.gui.addLayer((SubGui)dialog);
            dialog.onOpened();
        }
    }
}

