/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.signal;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.math.SmoothValue;
import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignal;
import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignalInput;
import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignalVirtualInput;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputCondition;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputVariable;
import com.creativemd.littletiles.common.structure.signal.logic.SignalLogicOperator;
import com.creativemd.littletiles.common.structure.signal.logic.SignalPatternParser;
import com.creativemd.littletiles.common.structure.signal.logic.SignalTarget;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class GuiSignalController
extends GuiParent {
    private GuiSignalNodeOutput output;
    protected int cellWidth = 60;
    protected int cellHeight = 40;
    public final List<SubGuiDialogSignal.GuiSignalComponent> inputs;
    public SmoothValue scrolledX = new SmoothValue(200L);
    public SmoothValue scrolledY = new SmoothValue(200L);
    public SmoothValue zoom = new SmoothValue(200L, 1.0);
    public double startScrollX;
    public double startScrollY;
    public int dragX;
    public int dragY;
    public boolean scrolling;
    private List<List<GuiSignalNode>> grid = new ArrayList<List<GuiSignalNode>>();
    private List<GuiGridLine> cols = new ArrayList<GuiGridLine>();
    private List<GuiGridLine> rows = new ArrayList<GuiGridLine>();
    public GuiSignalNode dragged;
    public boolean startedDragging = false;
    public GuiSignalNode selected;

    public GuiSignalController(String name, int x, int y, int width, int height, SubGuiDialogSignal.GuiSignalComponent output, List<SubGuiDialogSignal.GuiSignalComponent> inputs) {
        super(name, x, y, width, height);
        this.inputs = inputs;
        this.setOutput(4, output);
    }

    public float getScaleFactor() {
        return (float)this.zoom.current();
    }

    public double getOffsetX() {
        return -this.scrolledX.current();
    }

    public double getOffsetY() {
        return -this.scrolledY.current();
    }

    public SignalInputCondition generatePattern() throws GeneratePatternException {
        return this.output.generateCondition(new ArrayList<GuiSignalNode>());
    }

    public int sizeX() {
        return this.grid.size();
    }

    public int sizeY() {
        int rows = 0;
        for (int i = 0; i < this.grid.size(); ++i) {
            rows = Math.max(rows, this.grid.get(i).size());
        }
        return rows;
    }

    public void setToFreeCell(int startCol, GuiSignalNode node) {
        for (int i = 0; i < 50 - startCol; ++i) {
            if (this.grid.size() <= i) {
                this.grid.add(new ArrayList());
            }
            if (i < startCol) continue;
            List<GuiSignalNode> rows = this.grid.get(i);
            for (int j = 0; j < 50; ++j) {
                if (rows.size() <= j) {
                    rows.add(null);
                }
                if (rows.get(j) != null) continue;
                this.set(node, i, j);
                return;
            }
        }
    }

    public void remove(int col, int row) {
        List<GuiSignalNode> rows;
        if (col < this.grid.size() && row < (rows = this.grid.get(col)).size()) {
            rows.set(row, null);
        }
    }

    public void set(GuiSignalNode node, int col, int row) {
        boolean added = node.added;
        if (added && node.col == col && node.row == row) {
            return;
        }
        while (this.grid.size() <= col) {
            this.grid.add(new ArrayList());
        }
        List<GuiSignalNode> rows = this.grid.get(col);
        while (rows.size() <= row) {
            rows.add(null);
        }
        if (rows.get(row) == null) {
            if (added) {
                this.remove(node.col, node.row);
            }
            rows.set(row, node);
            node.updatePosition(col, row);
        }
    }

    public void reset() {
        this.controls.clear();
        this.grid.clear();
        this.cols.clear();
        this.rows.clear();
        this.dragged = null;
        this.selected = null;
        this.startedDragging = false;
    }

    public void setCondition(SignalInputCondition condition, SubGuiDialogSignal signal) {
        this.reset();
        try {
            ArrayList<List<GuiSignalNode>> parsed = new ArrayList<List<GuiSignalNode>>();
            GuiSignalNode node = this.fill(condition, signal, parsed, 0);
            for (int i = parsed.size() - 1; i >= 0; --i) {
                List rows = (List)parsed.get(i);
                for (int j = rows.size() - 1; j >= 0; --j) {
                    this.set((GuiSignalNode)rows.get(j), parsed.size() - i - 1, rows.size() - j - 1);
                    for (NodeConnection con : ((GuiSignalNode)rows.get(j)).toConnections()) {
                        con.build();
                    }
                }
            }
            this.setOutput(parsed.size(), this.output.component);
            NodeConnection connection = new NodeConnection(node, this.output);
            node.connect(connection);
            this.output.connect(connection);
            connection.build();
            return;
        }
        catch (ParseException e) {
            this.reset();
            this.setOutput(4, this.output.component);
            return;
        }
    }

    private GuiSignalNode fill(SignalInputCondition condition, SubGuiDialogSignal signal, List<List<GuiSignalNode>> parsed, int level) throws ParseException {
        GuiSignalNode node;
        if (condition instanceof SignalInputCondition.SignalInputConditionNot || condition instanceof SignalInputCondition.SignalInputConditionNotBitwise) {
            boolean bitwise = condition instanceof SignalInputCondition.SignalInputConditionNotBitwise;
            node = new GuiSignalNodeNotOperator(bitwise);
            GuiSignalNode child = this.fill(bitwise ? ((SignalInputCondition.SignalInputConditionNotBitwise)condition).condition : ((SignalInputCondition.SignalInputConditionNot)condition).condition, signal, parsed, level + 1);
            NodeConnection connection = new NodeConnection(child, node);
            node.connect(connection);
            child.connect(connection);
        } else if (condition instanceof SignalLogicOperator.SignalInputConditionOperatorStackable) {
            node = new GuiSignalNodeOperator(((SignalLogicOperator.SignalInputConditionOperatorStackable)condition).operator());
            for (SignalInputCondition subCondition : ((SignalLogicOperator.SignalInputConditionOperatorStackable)condition).conditions) {
                GuiSignalNode child = this.fill(subCondition, signal, parsed, level + 1);
                NodeConnection connection = new NodeConnection(child, node);
                node.connect(connection);
                child.connect(connection);
            }
        } else if (condition instanceof SignalInputVariable) {
            node = new GuiSignalNodeInput((SignalInputVariable)condition, signal);
        } else if (condition instanceof SignalInputCondition.SignalInputVirtualVariable) {
            node = new GuiSignalNodeVirtualInput((SignalInputCondition.SignalInputVirtualVariable)condition, signal);
        } else {
            throw new ParseException("Invalid condition type", 0);
        }
        while (parsed.size() <= level) {
            parsed.add(new ArrayList());
        }
        parsed.get(level).add(node);
        this.addControl((GuiControl)node);
        return node;
    }

    public GuiSignalNodeVirtualInput addVirtualInput() {
        GuiSignalNodeVirtualInput node = new GuiSignalNodeVirtualInput();
        this.setToFreeCell(0, node);
        this.addControl((GuiControl)node);
        return node;
    }

    public GuiSignalNodeInput addInput(SubGuiDialogSignal.GuiSignalComponent input) {
        GuiSignalNodeInput node = new GuiSignalNodeInput(input);
        this.setToFreeCell(0, node);
        this.addControl((GuiControl)node);
        return node;
    }

    public GuiSignalNodeNotOperator addNotOperator(boolean bitwise) {
        GuiSignalNodeNotOperator node = new GuiSignalNodeNotOperator(bitwise);
        this.setToFreeCell(1, node);
        this.addControl((GuiControl)node);
        return node;
    }

    public GuiSignalNodeOperator addOperator(SignalLogicOperator operator) {
        GuiSignalNodeOperator node = new GuiSignalNodeOperator(operator);
        this.setToFreeCell(1, node);
        this.addControl((GuiControl)node);
        return node;
    }

    public void removeNode(GuiSignalNode node) {
        this.startedDragging = false;
        if (this.selected != null) {
            this.selected.color = -1;
        }
        this.selected = null;
        this.dragged = null;
        this.controls.remove(node);
        this.remove(node.col, node.row);
        node.remove();
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public void select(GuiSignalNode node) {
        if (this.selected != null) {
            this.selected.color = -1;
        }
        this.selected = node;
        if (this.selected != null) {
            this.selected.color = -256;
        }
    }

    public boolean mouseScrolled(int x, int y, int scrolled) {
        if (!super.mouseScrolled(x, y, scrolled)) {
            this.zoom.set(MathHelper.func_151237_a((double)(this.zoom.aimed() + (double)scrolled * 0.2), (double)0.1, (double)2.0));
        }
        return true;
    }

    public boolean mousePressed(int x, int y, int button) {
        if (button == 2) {
            this.zoom.set(1.0);
            this.scrolledX.set(0.0);
            this.scrolledY.set(0.0);
            return true;
        }
        if (!super.mousePressed(x, y, button)) {
            this.select(null);
            this.scrolling = true;
            this.dragX = x;
            this.dragY = y;
            this.startScrollX = this.scrolledX.current();
            this.startScrollY = this.scrolledY.current();
        }
        return true;
    }

    public void mouseMove(int x, int y, int button) {
        if (this.scrolling) {
            this.scrolledX.set(MathHelper.func_151237_a((double)((double)(this.dragX - x) + this.startScrollX), (double)-40.0, (double)(this.sizeX() * this.cellWidth)));
            this.scrolledY.set(MathHelper.func_151237_a((double)((double)(this.dragY - y) + this.startScrollY), (double)-40.0, (double)(this.sizeY() * this.cellHeight)));
        }
        super.mouseMove(x, y, button);
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        this.scrolledX.tick();
        this.scrolledY.tick();
        this.zoom.tick();
        super.renderContent(helper, style, width, height);
    }

    public void mouseDragged(int x, int y, int button, long time) {
        super.mouseDragged(x, y, button, time);
        if (time > 200L && this.dragged != null) {
            this.startedDragging = true;
            this.set(this.dragged, (int)Math.max(0.0, ((double)((float)((x - this.posX) * 1) / this.getScaleFactor()) + this.scrolledX.current()) / (double)this.cellWidth), (int)Math.max(0.0, ((double)((float)((y - this.posY) * 1) / this.getScaleFactor()) + this.scrolledY.current()) / (double)this.cellHeight));
        }
    }

    public void mouseReleased(int x, int y, int button) {
        super.mouseReleased(x, y, button);
        this.scrolling = false;
        this.startedDragging = false;
        this.dragged = null;
    }

    public void setOutput(int cell, SubGuiDialogSignal.GuiSignalComponent output) {
        if (this.output != null) {
            this.removeNode(this.output);
        }
        this.output = new GuiSignalNodeOutput(output);
        this.setToFreeCell(cell, this.output);
        this.addControl((GuiControl)this.output);
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public GuiGridLine getCol(int x) {
        while (this.cols.size() <= x) {
            this.cols.add(new GuiGridLine(true, this.cols.size()));
        }
        return this.cols.get(x);
    }

    public GuiGridLine getRow(int y) {
        while (this.rows.size() <= y) {
            this.rows.add(new GuiGridLine(false, this.rows.size()));
        }
        return this.rows.get(y);
    }

    public void tryConnect(GuiSignalNode node1, GuiSignalNode node2) {
        if (node1 != node2 && node1.canConnectTo(node2) && node2.canConnectFrom(node1)) {
            NodeConnection connection = new NodeConnection(node1, node2);
            connection.build();
            node1.connect(connection);
            node2.connect(connection);
            this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
        }
        this.select(null);
    }

    public static class GeneratePatternException
    extends Exception {
        public final GuiSignalNode node;

        public GeneratePatternException(GuiSignalNode node, String msg) {
            super("exception.pattern." + msg);
            this.node = node;
            this.node.setError(this.getMessage());
        }
    }

    public class IteratorIterator<T>
    implements Iterator<T> {
        private final Iterator<T>[] is;
        private int current;

        public IteratorIterator(Iterator<T> ... iterators) {
            this.is = iterators;
            this.current = 0;
        }

        @Override
        public boolean hasNext() {
            while (this.current < this.is.length && !this.is[this.current].hasNext()) {
                ++this.current;
            }
            return this.current < this.is.length;
        }

        @Override
        public T next() {
            while (this.current < this.is.length && !this.is[this.current].hasNext()) {
                ++this.current;
            }
            return this.is[this.current].next();
        }
    }

    public static class GuiNodeConnectionPart
    extends GuiControl {
        private NodeConnectionPoint from;
        private NodeConnectionPoint to;
        public final NodeConnection connection;

        public GuiNodeConnectionPart(NodeConnectionPoint from, NodeConnectionPoint to, NodeConnection connection) {
            super("", 0, 0, 0, 0);
            this.from = from;
            this.from.after = this;
            this.to = to;
            this.to.before = this;
            this.connection = connection;
            this.updateBounds();
        }

        public void updateBounds() {
            this.posX = Math.min(this.from.x, this.to.x);
            this.posY = Math.min(this.from.y, this.to.y);
            if (this.from.x == this.to.x) {
                this.width = 1;
                this.height = Math.max(this.from.y, this.to.y) - this.posY;
            } else {
                this.width = Math.max(this.from.x, this.to.x) - this.posX;
                this.height = 1;
            }
        }

        protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        }

        public boolean mousePressed(int x, int y, int button) {
            if (button == 1) {
                this.connection.remove();
            }
            return super.mousePressed(x, y, button);
        }
    }

    public class NodeConnection {
        public final GuiSignalNode from;
        public final GuiSignalNode to;
        private List<GuiNodeConnectionPart> controls = new ArrayList<GuiNodeConnectionPart>();
        private List<NodeConnectionLine> lines = new ArrayList<NodeConnectionLine>();

        public NodeConnection(GuiSignalNode from, GuiSignalNode to) {
            this.from = from;
            this.to = to;
        }

        public void addPart(GuiNodeConnectionPart part) {
            GuiSignalController.this.addControl(part);
            this.controls.add(part);
        }

        public void build() {
            boolean neighbor;
            int startX = this.from.col;
            int startY = this.from.row;
            int endX = this.to.col;
            int endY = this.to.row;
            NodeConnectionPoint startPoint = new NodeConnectionPoint(this.from.posX + this.from.width, this.from.posY + this.from.height / 2);
            NodeConnectionPoint endPoint = new NodeConnectionPoint(this.to.posX, this.to.posY + this.to.height / 2);
            boolean bl = neighbor = startX + 1 == endX;
            if (startY == endY && neighbor) {
                this.addPart(new GuiNodeConnectionPart(startPoint, endPoint, this));
            } else {
                GuiGridLine startCol = GuiSignalController.this.getCol(startX + 1);
                NodeConnectionPoint colStart = new NodeConnectionPoint(0, this.from.posY + this.from.height / 2);
                NodeConnectionPoint colEnd = neighbor ? new NodeConnectionPoint(0, this.to.posY + this.to.height / 2) : new NodeConnectionPoint(0, 0);
                this.addPart(new GuiNodeConnectionPart(startPoint, colStart, this));
                this.lines.add(startCol.addLine(colStart, colEnd));
                this.addPart(new GuiNodeConnectionPart(colStart, colEnd, this));
                if (neighbor) {
                    this.addPart(new GuiNodeConnectionPart(colEnd, endPoint, this));
                } else {
                    GuiGridLine startRow = GuiSignalController.this.getRow(startY > endY ? startY : endY);
                    NodeConnectionPoint rowEnd = new NodeConnectionPoint(0, 0);
                    this.lines.add(startRow.addLine(colEnd, rowEnd));
                    this.addPart(new GuiNodeConnectionPart(colEnd, rowEnd, this));
                    GuiGridLine endCol = GuiSignalController.this.getCol(endX);
                    NodeConnectionPoint endColEnd = new NodeConnectionPoint(0, this.to.posY + this.to.height / 2);
                    this.lines.add(endCol.addLine(rowEnd, endColEnd));
                    this.addPart(new GuiNodeConnectionPart(rowEnd, endColEnd, this));
                    this.addPart(new GuiNodeConnectionPart(endColEnd, endPoint, this));
                }
            }
        }

        public void rebuild() {
            for (GuiNodeConnectionPart part : this.controls) {
                GuiSignalController.this.removeControl(part);
            }
            for (NodeConnectionLine line : this.lines) {
                line.remove();
            }
            this.build();
        }

        public void remove() {
            this.from.removeConnection(this);
            this.to.removeConnection(this);
            for (GuiNodeConnectionPart part : this.controls) {
                GuiSignalController.this.removeControl(part);
            }
            for (NodeConnectionLine line : this.lines) {
                line.remove();
            }
            GuiSignalController.this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)GuiSignalController.this));
        }
    }

    private class NodeConnectionLine {
        private final NodeConnectionPoint from;
        private final NodeConnectionPoint to;
        public final GuiGridLine line;

        public NodeConnectionLine(GuiGridLine line, NodeConnectionPoint from, NodeConnectionPoint to) {
            this.line = line;
            this.from = from;
            this.to = to;
        }

        public void remove() {
            this.line.removeLine(this);
        }

        public void setX(int x) {
            this.from.setX(x);
            this.to.setX(x);
        }

        public void setY(int y) {
            this.from.setY(y);
            this.to.setY(y);
        }
    }

    private class NodeConnectionPoint {
        private int x;
        private int y;
        public GuiNodeConnectionPart before;
        public GuiNodeConnectionPart after;

        public NodeConnectionPoint(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void setX(int x) {
            this.x = x;
            if (this.before != null) {
                this.before.updateBounds();
            }
            if (this.after != null) {
                this.after.updateBounds();
            }
        }

        public void setY(int y) {
            this.y = y;
            if (this.before != null) {
                this.before.updateBounds();
            }
            if (this.after != null) {
                this.after.updateBounds();
            }
        }
    }

    public class GuiSignalNodeOutput
    extends GuiSignalNodeComponent {
        public NodeConnection from;

        public GuiSignalNodeOutput(SubGuiDialogSignal.GuiSignalComponent component) {
            super(component);
        }

        @Override
        public boolean canConnectTo(GuiSignalNode node) {
            return false;
        }

        @Override
        public boolean canConnectFrom(GuiSignalNode node) {
            return this.from == null;
        }

        @Override
        public Iterator<NodeConnection> iterator() {
            return new Iterator<NodeConnection>(){
                public boolean has;
                {
                    this.has = GuiSignalNodeOutput.this.from != null;
                }

                @Override
                public boolean hasNext() {
                    return this.has;
                }

                @Override
                public NodeConnection next() {
                    this.has = false;
                    return GuiSignalNodeOutput.this.from;
                }
            };
        }

        @Override
        public Iterable<NodeConnection> toConnections() {
            return new Iterable<NodeConnection>(){

                @Override
                public Iterator<NodeConnection> iterator() {
                    return new Iterator<NodeConnection>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public NodeConnection next() {
                            return null;
                        }
                    };
                }
            };
        }

        @Override
        public void removeConnection(NodeConnection connection) {
            this.from = null;
        }

        @Override
        public void connect(NodeConnection connection) {
            this.from = connection;
        }

        @Override
        public void remove() {
            if (this.from != null) {
                this.from.remove();
            }
        }

        @Override
        public int indexOf(NodeConnection connection) {
            return 0;
        }

        @Override
        public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
            this.reset();
            if (this.from == null) {
                throw new GeneratePatternException(this, "empty");
            }
            return this.from.from.generateCondition(processed);
        }
    }

    public class GuiSignalNodeVirtualInput
    extends GuiSignalNode {
        public List<NodeConnection> tos;
        public SignalInputCondition[] conditions;

        public GuiSignalNodeVirtualInput() {
            super("v[]");
            this.tos = new ArrayList<NodeConnection>();
            this.conditions = new SignalInputCondition[0];
        }

        public GuiSignalNodeVirtualInput(SignalInputCondition.SignalInputVirtualVariable variable, SubGuiDialogSignal signal) throws ParseException {
            super("v[]");
            this.tos = new ArrayList<NodeConnection>();
            this.conditions = variable.conditions;
            this.updateLabel();
        }

        public void updateLabel() {
            String conditionsText = "";
            for (int i = 0; i < this.conditions.length; ++i) {
                if (i > 0) {
                    conditionsText = conditionsText + ",";
                }
                conditionsText = conditionsText + this.conditions[i].write();
            }
            if (conditionsText.length() > 10) {
                conditionsText = "...";
            }
            this.caption = "v[" + conditionsText + "]";
            this.width = font.func_78256_a(this.caption) + this.getContentOffset() * 2;
            this.posX = this.getCol() * GuiSignalController.this.cellWidth + GuiSignalController.this.cellWidth / 2 - this.width / 2;
            this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)GuiSignalController.this));
        }

        @Override
        public void onDoubleClicked(int x, int y, int button) {
            this.openClientLayer(new SubGuiDialogSignalVirtualInput(GuiSignalController.this.inputs, this));
        }

        @Override
        public boolean canConnectTo(GuiSignalNode node) {
            for (NodeConnection connectTo : this.tos) {
                if (connectTo.to != node) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean canConnectFrom(GuiSignalNode node) {
            return false;
        }

        @Override
        public void removeConnection(NodeConnection connection) {
            this.tos.remove(connection);
        }

        @Override
        public void connect(NodeConnection connection) {
            this.tos.add(connection);
        }

        @Override
        public Iterator<NodeConnection> iterator() {
            return this.tos.iterator();
        }

        @Override
        public Iterable<NodeConnection> toConnections() {
            return this.tos;
        }

        @Override
        public void remove() {
            for (NodeConnection connection : new ArrayList<NodeConnection>(this.tos)) {
                connection.remove();
            }
        }

        @Override
        public int indexOf(NodeConnection connection) {
            return this.tos.indexOf(connection);
        }

        @Override
        public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
            this.reset();
            return new SignalInputCondition.SignalInputVirtualVariable(this.conditions);
        }
    }

    public class GuiSignalNodeInput
    extends GuiSignalNodeComponent {
        public List<NodeConnection> tos;
        public SignalTarget.SignalCustomIndex[] indexes;
        public int operator;
        public SignalLogicOperator logic;
        public int[] pattern;
        public SignalInputCondition equation;

        public GuiSignalNodeInput(SubGuiDialogSignal.GuiSignalComponent component) {
            super(component);
            this.tos = new ArrayList<NodeConnection>();
            this.operator = 0;
        }

        public GuiSignalNodeInput(SignalInputVariable variable, SubGuiDialogSignal signal) throws ParseException {
            super(signal.getInput(variable.target));
            this.tos = new ArrayList<NodeConnection>();
            this.operator = 0;
            SignalTarget target = variable.target.getNestedTarget();
            if (target instanceof SignalTarget.SignalTargetChildCustomIndex) {
                this.indexes = ((SignalTarget.SignalTargetChildCustomIndex)target).indexes;
            } else if (target instanceof SignalTarget.SignalTargetChildIndex) {
                this.indexes = new SignalTarget.SignalCustomIndex[]{new SignalTarget.SignalCustomIndexSingle(((SignalTarget.SignalTargetChildIndex)target).index)};
            } else if (target instanceof SignalTarget.SignalTargetChildIndexRange) {
                this.indexes = new SignalTarget.SignalCustomIndex[]{new SignalTarget.SignalCustomIndexRange(((SignalTarget.SignalTargetChildIndexRange)target).index, ((SignalTarget.SignalTargetChildIndexRange)target).index + ((SignalTarget.SignalTargetChildIndexRange)target).length - 1)};
            }
            if (variable instanceof SignalInputVariable.SignalInputVariableOperator) {
                this.operator = 1;
                this.logic = ((SignalInputVariable.SignalInputVariableOperator)variable).operator;
            } else if (variable instanceof SignalInputVariable.SignalInputVariablePattern) {
                this.operator = 2;
                this.pattern = ((SignalInputVariable.SignalInputVariablePattern)variable).indexes;
            } else if (variable instanceof SignalInputVariable.SignalInputVariableEquation) {
                this.operator = 3;
                this.equation = ((SignalInputVariable.SignalInputVariableEquation)variable).condition;
            } else {
                this.operator = 0;
            }
            this.updateLabel();
        }

        public void updateLabel() {
            this.caption = this.component.name;
            int length = 0;
            if (this.indexes != null) {
                String rangeText = this.getRange();
                if (rangeText.length() > 6) {
                    rangeText = "...";
                    length += 3;
                } else {
                    length += rangeText.length();
                }
                this.caption = this.caption + "[" + rangeText + "]";
            }
            String operatorText = "";
            switch (this.operator) {
                case 1: {
                    operatorText = (this.logic == SignalLogicOperator.AND ? "&" : Character.valueOf(this.logic.operator)) + "";
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.pattern.length; ++i) {
                        operatorText = operatorText + "" + (this.pattern[i] >= 2 ? "*" : Integer.valueOf(this.pattern[i]));
                    }
                    break;
                }
                case 3: {
                    if (this.equation == null) break;
                    operatorText = this.equation.write();
                }
            }
            if (operatorText.length() + length > 10) {
                operatorText = "...";
            }
            if (!operatorText.isEmpty()) {
                this.caption = this.caption + "{" + operatorText + "}";
            }
            this.width = font.func_78256_a(this.caption) + this.getContentOffset() * 2;
            this.posX = this.getCol() * GuiSignalController.this.cellWidth + GuiSignalController.this.cellWidth / 2 - this.width / 2;
            this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)GuiSignalController.this));
        }

        public String getRange() {
            if (this.indexes == null) {
                return "";
            }
            String result = "";
            for (int i = 0; i < this.indexes.length; ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + this.indexes[i].write();
            }
            return result;
        }

        @Override
        public void onDoubleClicked(int x, int y, int button) {
            this.openClientLayer(new SubGuiDialogSignalInput(this));
        }

        @Override
        public boolean canConnectTo(GuiSignalNode node) {
            for (NodeConnection connectTo : this.tos) {
                if (connectTo.to != node) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean canConnectFrom(GuiSignalNode node) {
            return false;
        }

        @Override
        public void removeConnection(NodeConnection connection) {
            this.tos.remove(connection);
        }

        @Override
        public void connect(NodeConnection connection) {
            this.tos.add(connection);
        }

        @Override
        public Iterator<NodeConnection> iterator() {
            return this.tos.iterator();
        }

        @Override
        public Iterable<NodeConnection> toConnections() {
            return this.tos;
        }

        @Override
        public void remove() {
            for (NodeConnection connection : new ArrayList<NodeConnection>(this.tos)) {
                connection.remove();
            }
        }

        @Override
        public int indexOf(NodeConnection connection) {
            return this.tos.indexOf(connection);
        }

        @Override
        public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
            this.reset();
            try {
                SignalTarget target = SignalTarget.parseTarget(new SignalPatternParser(this.component.name + (this.indexes != null ? "[" + this.getRange() + "]" : "")), false, false);
                switch (this.operator) {
                    case 1: {
                        return new SignalInputVariable.SignalInputVariableOperator(target, this.logic);
                    }
                    case 2: {
                        return new SignalInputVariable.SignalInputVariablePattern(target, this.pattern);
                    }
                    case 3: {
                        if (this.equation == null) break;
                        return new SignalInputVariable.SignalInputVariableEquation(target, this.equation);
                    }
                }
                return new SignalInputVariable(target);
            }
            catch (ParseException e) {
                throw new GeneratePatternException(this, "Invalid target");
            }
        }
    }

    public abstract class GuiSignalNodeComponent
    extends GuiSignalNode {
        public final String underline;
        public final SubGuiDialogSignal.GuiSignalComponent component;

        public GuiSignalNodeComponent(SubGuiDialogSignal.GuiSignalComponent component) {
            super(component.name);
            this.component = component;
            this.underline = component.totalName;
        }

        @Override
        protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
            super.renderContent(helper, style, width, height);
            if (!this.underline.equals(this.caption)) {
                helper.font.func_175063_a(this.underline, (float)(width / 2 - helper.font.func_78256_a(this.underline) / 2), 14.0f, -1);
            }
        }
    }

    public class GuiSignalNodeNotOperator
    extends GuiSignalNode {
        public final boolean bitwise;
        private NodeConnection from;
        private List<NodeConnection> to;

        public GuiSignalNodeNotOperator(boolean bitwise) {
            super(bitwise ? "b-not" : "not");
            this.to = new ArrayList<NodeConnection>();
            this.bitwise = bitwise;
        }

        @Override
        public boolean canConnectTo(GuiSignalNode node) {
            for (NodeConnection connectTo : this.to) {
                if (connectTo.to != node) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean canConnectFrom(GuiSignalNode node) {
            return this.from == null;
        }

        @Override
        public void removeConnection(NodeConnection connection) {
            if (connection.to == this) {
                this.from = null;
            } else {
                this.to.remove(connection);
            }
        }

        @Override
        public Iterator<NodeConnection> iterator() {
            return new Iterator<NodeConnection>(){
                public int index = 0;
                public Iterator<NodeConnection> iterator = GuiSignalNodeNotOperator.access$300(GuiSignalNodeNotOperator.this).iterator();

                @Override
                public boolean hasNext() {
                    if (this.index == 0) {
                        return GuiSignalNodeNotOperator.this.from != null || this.iterator.hasNext();
                    }
                    if (this.index == 1) {
                        return this.iterator.hasNext();
                    }
                    return false;
                }

                @Override
                public NodeConnection next() {
                    if (this.index == 0) {
                        ++this.index;
                        if (GuiSignalNodeNotOperator.this.from != null) {
                            return GuiSignalNodeNotOperator.this.from;
                        }
                        ++this.index;
                        return this.iterator.next();
                    }
                    if (this.index == 1) {
                        return this.iterator.next();
                    }
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterable<NodeConnection> toConnections() {
            return this.to;
        }

        @Override
        public void connect(NodeConnection connection) {
            if (connection.to == this) {
                this.from = connection;
            } else {
                this.to.add(connection);
            }
        }

        @Override
        public void remove() {
            if (this.from != null) {
                this.from.remove();
            }
            for (NodeConnection connection : new ArrayList<NodeConnection>(this.to)) {
                connection.remove();
            }
        }

        @Override
        public int indexOf(NodeConnection connection) {
            if (connection.to == this) {
                return 0;
            }
            return this.to.indexOf(connection);
        }

        @Override
        public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
            this.reset();
            if (this.from == null) {
                throw new GeneratePatternException(this, "empty");
            }
            if (processed.contains(this)) {
                throw new GeneratePatternException(this, "circular");
            }
            processed.add(this);
            return this.bitwise ? new SignalInputCondition.SignalInputConditionNotBitwise(this.from.from.generateCondition(processed)) : new SignalInputCondition.SignalInputConditionNot(this.from.from.generateCondition(processed));
        }

        static /* synthetic */ List access$300(GuiSignalNodeNotOperator x0) {
            return x0.to;
        }
    }

    public class GuiSignalNodeOperator
    extends GuiSignalNode {
        public final SignalLogicOperator operator;
        private List<NodeConnection> from;
        private List<NodeConnection> to;

        public GuiSignalNodeOperator(SignalLogicOperator operator) {
            super(operator.display);
            this.from = new ArrayList<NodeConnection>();
            this.to = new ArrayList<NodeConnection>();
            this.operator = operator;
        }

        @Override
        public boolean canConnectTo(GuiSignalNode node) {
            for (NodeConnection connectTo : this.to) {
                if (connectTo.to != node) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean canConnectFrom(GuiSignalNode node) {
            for (NodeConnection connectFrom : this.from) {
                if (connectFrom.from != node) continue;
                return false;
            }
            return true;
        }

        @Override
        public void removeConnection(NodeConnection connection) {
            if (connection.to == this) {
                this.from.remove(connection);
            } else {
                this.to.remove(connection);
            }
        }

        @Override
        public Iterator<NodeConnection> iterator() {
            return new IteratorIterator<NodeConnection>(this.from.iterator(), this.to.iterator());
        }

        @Override
        public Iterable<NodeConnection> toConnections() {
            return this.to;
        }

        @Override
        public void connect(NodeConnection connection) {
            if (connection.to == this) {
                this.from.add(connection);
            } else {
                this.to.add(connection);
            }
        }

        @Override
        public void remove() {
            for (NodeConnection connection : new ArrayList<NodeConnection>(this.from)) {
                connection.remove();
            }
            for (NodeConnection connection : new ArrayList<NodeConnection>(this.to)) {
                connection.remove();
            }
        }

        @Override
        public int indexOf(NodeConnection connection) {
            if (connection.to == this) {
                return this.from.indexOf(connection);
            }
            return this.to.indexOf(connection);
        }

        @Override
        public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
            this.reset();
            if (this.from.isEmpty()) {
                throw new GeneratePatternException(this, "empty");
            }
            if (processed.contains(this)) {
                throw new GeneratePatternException(this, "circular");
            }
            processed.add(this);
            if (this.from.size() == 1) {
                return this.from.get((int)0).from.generateCondition(processed);
            }
            ArrayList<SignalInputCondition> parsed = new ArrayList<SignalInputCondition>();
            for (int i = 0; i < this.from.size(); ++i) {
                try {
                    parsed.add(this.from.get((int)i).from.generateCondition(new ArrayList<GuiSignalNode>(processed)));
                    continue;
                }
                catch (GeneratePatternException generatePatternException) {
                    // empty catch block
                }
            }
            if (parsed.isEmpty()) {
                throw new GeneratePatternException(this, "novalidchildren");
            }
            if (parsed.size() == 1) {
                return (SignalInputCondition)parsed.get(0);
            }
            return this.operator.create(parsed.toArray(new SignalInputCondition[parsed.size()]));
        }
    }

    public abstract class GuiSignalNode
    extends GuiButton
    implements Iterable<NodeConnection> {
        private String error;
        private int col;
        private int row;
        private boolean added;
        private static final long DOUBLE_CLICK_WAITING_TIME = 200L;
        private long doubleClickTime;
        private int button;
        private int mouseX;
        private int mouseY;

        public GuiSignalNode(String caption) {
            super(caption, caption, 0, 0, GuiRenderHelper.instance.getStringWidth(caption), 8);
            this.added = false;
            this.doubleClickTime = -1L;
        }

        public void reset() {
            this.customTooltip = null;
            this.color = -1;
        }

        public void setError(String error) {
            this.setCustomTooltip(new String[]{GuiSignalNode.translate((String)error)});
            this.color = -65536;
        }

        public int getCol() {
            return this.col;
        }

        public int getRow() {
            return this.row;
        }

        public void updatePosition(int col, int row) {
            this.col = col;
            this.row = row;
            this.posX = col * GuiSignalController.this.cellWidth + GuiSignalController.this.cellWidth / 2 - this.width / 2;
            this.posY = row * GuiSignalController.this.cellHeight + GuiSignalController.this.cellHeight / 2 - this.height / 2;
            this.added = true;
            for (NodeConnection connection : this) {
                connection.rebuild();
            }
        }

        public boolean mousePressed(int x, int y, int button) {
            if (this.doubleClickTime == -1L || button != this.button) {
                this.doubleClickTime = System.currentTimeMillis();
                this.button = button;
                this.mouseX = x;
                this.mouseY = y;
            } else {
                this.doubleClickTime = -1L;
                this.onDoubleClicked(x, y, button);
                GuiSignalNode.playSound((SoundEvent)SoundEvents.field_194226_id);
                GuiSignalNode.playSound((SoundEvent)SoundEvents.field_187909_gi);
            }
            return true;
        }

        protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
            if (this.doubleClickTime != -1L && System.currentTimeMillis() > this.doubleClickTime + 200L) {
                GuiSignalNode.playSound((SoundEvent)SoundEvents.field_187909_gi);
                this.onClicked(this.mouseX, this.mouseY, this.button);
                this.doubleClickTime = -1L;
            }
            super.renderContent(helper, style, width, height);
        }

        public void onDoubleClicked(int x, int y, int button) {
        }

        public void onClicked(int x, int y, int button) {
            if (button == 1 && !(this instanceof GuiSignalNodeOutput)) {
                GuiSignalController.this.removeNode(this);
                return;
            }
            if (GuiSignalController.this.selected != null) {
                GuiSignalController.this.tryConnect(GuiSignalController.this.selected, this);
            } else if (Mouse.isButtonDown((int)this.button)) {
                GuiSignalController.this.dragged = this;
            } else {
                GuiSignalController.this.select(this);
            }
        }

        public abstract SignalInputCondition generateCondition(List<GuiSignalNode> var1) throws GeneratePatternException;

        public abstract void removeConnection(NodeConnection var1);

        public abstract boolean canConnectTo(GuiSignalNode var1);

        public abstract boolean canConnectFrom(GuiSignalNode var1);

        public abstract void connect(NodeConnection var1);

        public abstract void remove();

        public abstract int indexOf(NodeConnection var1);

        public abstract Iterable<NodeConnection> toConnections();
    }

    public class GuiGridLine {
        private List<NodeConnectionLine> lines = new ArrayList<NodeConnectionLine>();
        private final boolean col;
        private final int pos;

        public GuiGridLine(boolean col, int pos) {
            this.col = col;
            this.pos = pos;
        }

        public NodeConnectionLine addLine(NodeConnectionPoint from, NodeConnectionPoint to) {
            NodeConnectionLine line = new NodeConnectionLine(this, from, to);
            this.lines.add(line);
            this.refresh();
            return line;
        }

        public void removeLine(NodeConnectionLine line) {
            this.lines.remove(line);
            this.refresh();
        }

        public void refresh() {
            int distance = 0;
            if (this.col) {
                for (int i = 0; i < this.lines.size(); ++i) {
                    NodeConnectionLine line = this.lines.get(i);
                    line.setX(this.pos * GuiSignalController.this.cellWidth + 2 + distance);
                    distance = distance > 0 ? -distance : -distance + 2;
                }
            } else {
                for (int i = 0; i < this.lines.size(); ++i) {
                    NodeConnectionLine line = this.lines.get(i);
                    line.setY(this.pos * GuiSignalController.this.cellHeight + 2 + distance);
                    distance = distance > 0 ? -distance : -distance + 2;
                }
            }
        }
    }
}

