/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.signal;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCounter;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.client.gui.signal.GuiSignalController;
import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignal;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.List;

public class SubGuiDialogSignalVirtualInput
extends SubGui {
    public final GuiSignalController.GuiSignalNodeVirtualInput input;
    public final List<SubGuiDialogSignal.GuiSignalComponent> inputs;
    public GuiVirtualInputIndexConfiguration[] config;

    public SubGuiDialogSignalVirtualInput(List<SubGuiDialogSignal.GuiSignalComponent> inputs, GuiSignalController.GuiSignalNodeVirtualInput input) {
        this.input = input;
        this.inputs = inputs;
    }

    public void createControls() {
        this.controls.add(new GuiCounter("bandwidth", 0, 0, 40, this.input.conditions.length, 0, 256));
        this.controls.add(new GuiScrollBox("config", 0, 20, 170, 116));
        this.controls.add(new GuiButton("cancel", 0, 146){

            public void onClicked(int x, int y, int button) {
                SubGuiDialogSignalVirtualInput.this.closeGui();
            }
        });
        this.controls.add(new GuiButton("save", 146, 146){

            public void onClicked(int x, int y, int button) {
                SubGuiDialogSignalVirtualInput.this.input.conditions = new SignalInputCondition[SubGuiDialogSignalVirtualInput.this.config.length];
                for (int i = 0; i < SubGuiDialogSignalVirtualInput.this.config.length; ++i) {
                    SubGuiDialogSignalVirtualInput.this.input.conditions[i] = SubGuiDialogSignalVirtualInput.this.config[i].parse();
                }
                SubGuiDialogSignalVirtualInput.this.input.updateLabel();
                SubGuiDialogSignalVirtualInput.this.closeGui();
            }
        });
        this.loadConditions();
    }

    @CustomEventSubscribe
    public void changed(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"bandwidth"})) {
            this.loadConditions();
        }
    }

    public void loadConditions() {
        GuiScrollBox box = (GuiScrollBox)this.get("config");
        box.controls.clear();
        GuiCounter counter = (GuiCounter)this.get("bandwidth");
        int bandwidth = counter.getValue();
        this.config = new GuiVirtualInputIndexConfiguration[bandwidth];
        for (int i = 0; i < bandwidth; ++i) {
            GuiVirtualInputIndexConfiguration index = new GuiVirtualInputIndexConfiguration(i < this.input.conditions.length ? this.input.conditions[i] : new SignalInputCondition.SignalInputBit(false), i);
            index.create(box);
            this.config[i] = index;
        }
    }

    public class GuiVirtualInputIndexConfiguration
    implements SubGuiDialogSignal.IConditionConfiguration {
        public final SubGuiDialogSignal.GuiSignalComponent output;
        public final int index;
        public SignalInputCondition condition;
        public GuiPanel panel;

        public GuiVirtualInputIndexConfiguration(SignalInputCondition condition, int index) {
            this.output = new SubGuiDialogSignal.GuiSignalComponent("" + index, "" + index, 1, SignalComponentType.OUTPUT, false, index);
            this.index = index;
            this.condition = condition;
        }

        public void create(GuiScrollBox box) {
            this.panel = new GuiPanel(this.index + "", 0, this.index * 24, 162, 20);
            this.panel.addControl((GuiControl)new GuiLabel("label", this.index + ": " + (this.condition != null ? this.condition.write() : "0"), 0, 3));
            int state = 0;
            state = this.condition instanceof SignalInputCondition.SignalInputBit ? (((SignalInputCondition.SignalInputBit)this.condition).bit ? 1 : 0) : 2;
            this.panel.addControl((GuiControl)new GuiStateButton("type", state, 90, 0, 40, new String[]{"false", "true", "equation"}){

                public void onClicked(int x, int y, int button) {
                    GuiVirtualInputIndexConfiguration.this.update();
                }
            });
            this.panel.addControl((GuiControl)new GuiButton("edit", 138, 0){

                public void onClicked(int x, int y, int button) {
                    this.openClientLayer(new SubGuiDialogSignal(SubGuiDialogSignalVirtualInput.this.inputs, GuiVirtualInputIndexConfiguration.this));
                }
            });
            box.addControl((GuiControl)this.panel);
            this.update();
        }

        @Override
        public void update() {
            GuiLabel label = (GuiLabel)this.panel.get("label");
            GuiStateButton type = (GuiStateButton)this.panel.get("type");
            GuiButton edit = (GuiButton)this.panel.get("edit");
            label.setCaption(this.index + ": " + this.parse().write());
            edit.setEnabled(type.getState() == 2);
        }

        public SignalInputCondition parse() {
            GuiStateButton type = (GuiStateButton)this.panel.get("type");
            if (type.getState() == 0) {
                return new SignalInputCondition.SignalInputBit(false);
            }
            if (type.getState() == 1) {
                return new SignalInputCondition.SignalInputBit(true);
            }
            if (this.condition != null) {
                return this.condition;
            }
            return new SignalInputCondition.SignalInputBit(false);
        }

        @Override
        public SubGuiDialogSignal.GuiSignalComponent getOutput() {
            return this.output;
        }

        @Override
        public SignalInputCondition getCondition() {
            return this.condition;
        }

        @Override
        public void setCondition(SignalInputCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean hasModeConfiguration() {
            return false;
        }

        @Override
        public SignalMode.GuiSignalModeConfiguration getModeConfiguration() {
            return null;
        }

        @Override
        public void setModeConfiguration(SignalMode.GuiSignalModeConfiguration config) {
        }
    }
}

