/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.cache;

import com.creativemd.littletiles.client.render.cache.ChunkBlockLayerCache;
import com.creativemd.littletiles.client.render.world.RenderUploader;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ChunkBlockLayerManager {
    public static final Field blockLayerManager = ReflectionHelper.findField(VertexBuffer.class, (String[])new String[]{"blockLayerManager"});
    private final RenderChunk chunk;
    private final BlockRenderLayer layer;
    private final VertexBuffer buffer;
    private ChunkBlockLayerCache cache;
    private ChunkBlockLayerCache uploaded;

    public ChunkBlockLayerManager(RenderChunk chunk, BlockRenderLayer layer) {
        this.chunk = chunk;
        this.layer = layer;
        this.buffer = chunk.func_178565_b(layer.ordinal());
        try {
            blockLayerManager.set(this.buffer, this);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public synchronized void set(ChunkBlockLayerCache cache) {
        if (this.cache != null) {
            this.cache.discard();
        }
        this.cache = cache;
    }

    public synchronized void bindBuffer() {
        if (this.uploaded != null) {
            this.backToRAM();
        }
        this.uploaded = this.cache;
        this.cache = null;
        if (this.uploaded != null) {
            this.uploaded.uploaded();
        }
    }

    public void backToRAM() {
        if (this.uploaded == null) {
            return;
        }
        Callable<Boolean> run = () -> {
            ChunkBlockLayerManager chunkBlockLayerManager = this;
            synchronized (chunkBlockLayerManager) {
                if (Minecraft.func_71410_x().field_71441_e == null || this.uploaded == null || RenderUploader.getBufferId(this.buffer) == -1) {
                    if (this.uploaded != null) {
                        this.uploaded.discard();
                    }
                    this.uploaded = null;
                    return false;
                }
                this.buffer.func_177359_a();
                try {
                    ByteBuffer uploadedData = RenderUploader.glMapBufferRange(this.uploaded.totalSize());
                    if (uploadedData != null) {
                        this.uploaded.download(uploadedData);
                    } else {
                        this.uploaded.discard();
                    }
                    this.uploaded = null;
                }
                catch (RenderUploader.NotSupportedException e) {
                    e.printStackTrace();
                }
                this.buffer.func_177361_b();
                return true;
            }
        };
        try {
            if (Minecraft.func_71410_x().func_152345_ab()) {
                run.call();
            } else {
                ListenableFuture future = Minecraft.func_71410_x().func_152343_a(run);
                future.get();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

