/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.cache;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.client.render.cache.BufferLink;
import com.creativemd.littletiles.client.render.cache.IRenderDataCache;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayeredRenderBufferCache {
    private IRenderDataCache[] queue = new IRenderDataCache[BlockRenderLayer.values().length];
    private BufferLink[] uploaded = new BufferLink[BlockRenderLayer.values().length];

    public IRenderDataCache get(int layer) {
        if (this.queue[layer] == null) {
            return this.uploaded[layer];
        }
        return this.queue[layer];
    }

    public synchronized void setEmptyIfEqual(BufferLink link, int layer) {
        if (this.uploaded[layer] == link) {
            this.uploaded[layer] = null;
        }
    }

    public synchronized void setUploaded(BufferLink link, int layer) {
        this.queue[layer] = null;
        this.uploaded[layer] = link;
    }

    public synchronized void set(int layer, BufferBuilder buffer) {
        if (buffer == null) {
            this.uploaded[layer] = null;
        }
        this.queue[layer] = buffer != null ? new BufferBuilderWrapper(buffer) : null;
    }

    public synchronized void setEmpty() {
        for (int i = 0; i < this.queue.length; ++i) {
            this.queue[i] = null;
            this.uploaded[i] = null;
        }
    }

    public synchronized void combine(LayeredRenderBufferCache cache) {
        for (int i = 0; i < this.queue.length; ++i) {
            if (i == BlockRenderLayer.TRANSLUCENT.ordinal()) {
                this.queue[i] = this.combine(i, this.get(i), cache.get(i));
                continue;
            }
            this.uploaded[i] = this.combine(i, this.get(i), cache.get(i));
        }
    }

    private BufferLink combine(int layer, IRenderDataCache first, IRenderDataCache second) {
        int vertexCount = 0;
        int length = 0;
        ByteBuffer firstBuffer = null;
        if (first != null && (firstBuffer = first.byteBuffer()) != null) {
            vertexCount += first.vertexCount();
            length += first.length();
        }
        ByteBuffer secondBuffer = null;
        if (second != null && (secondBuffer = second.byteBuffer()) != null) {
            vertexCount += second.vertexCount();
            length += second.length();
        }
        if (vertexCount == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(length);
        if (firstBuffer != null) {
            firstBuffer.position(0);
            firstBuffer.limit(first.length());
            byteBuffer.put(firstBuffer);
        }
        if (secondBuffer != null) {
            secondBuffer.position(0);
            secondBuffer.limit(second.length());
            byteBuffer.put(secondBuffer);
        }
        return new BufferLink(byteBuffer, length, vertexCount);
    }

    public static BufferBuilder createVertexBuffer(VertexFormat format, List<? extends RenderBox> cubes) {
        int size = 1;
        for (RenderBox renderBox : cubes) {
            size += renderBox.countQuads();
        }
        return new BufferBuilder(format.func_177338_f() * size);
    }

    public static class BufferBuilderWrapper
    implements IRenderDataCache {
        public final BufferBuilder builder;

        public BufferBuilderWrapper(BufferBuilder builder) {
            this.builder = builder;
        }

        @Override
        public ByteBuffer byteBuffer() {
            return this.builder.func_178966_f();
        }

        @Override
        public int length() {
            return BufferBuilderUtils.getBufferSizeByte((BufferBuilder)this.builder);
        }

        @Override
        public int vertexCount() {
            return this.builder.func_178989_h();
        }
    }

    public static class ByteBufferWrapper
    implements IRenderDataCache {
        public ByteBuffer buffer;
        public int length;
        public int vertexCount;

        public ByteBufferWrapper(ByteBuffer buffer, int length, int vertexCount) {
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer byteBuffer() {
            return this.buffer;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public int vertexCount() {
            return this.vertexCount;
        }
    }
}

