/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.entity;

import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.client.render.cache.ChunkBlockLayerCache;
import com.creativemd.littletiles.client.render.cache.LayeredRenderBufferCache;
import com.creativemd.littletiles.client.render.world.LittleChunkDispatcher;
import com.creativemd.littletiles.client.render.world.RenderUploader;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;

public class LittleRenderChunk {
    protected int lastRenderIndex = LittleChunkDispatcher.currentRenderState;
    public final BlockPos pos;
    protected final VertexBuffer[] vertexBuffers = new VertexBuffer[BlockRenderLayer.values().length];
    protected BufferBuilder[] builders = new BufferBuilder[BlockRenderLayer.values().length];
    protected ChunkBlockLayerCache[] cachedBuffers = new ChunkBlockLayerCache[BlockRenderLayer.values().length];
    protected boolean[] bufferChanged = new boolean[BlockRenderLayer.values().length];
    private LinkedHashMap<BlockPos, TileEntityLittleTiles> tileEntities = new LinkedHashMap();
    private boolean modified = false;
    private boolean complete = false;
    public int transparencySortedIndex = 0;

    public LittleRenderChunk(BlockPos pos) {
        this.pos = pos;
        for (int i = 0; i < this.cachedBuffers.length; ++i) {
            this.cachedBuffers[i] = new ChunkBlockLayerCache(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderData(TileEntityLittleTiles te) {
        LinkedHashMap<BlockPos, TileEntityLittleTiles> linkedHashMap = this.tileEntities;
        synchronized (linkedHashMap) {
            TileEntityLittleTiles existing = this.tileEntities.get(te.func_174877_v());
            if (existing != null) {
                if (existing != te) {
                    if (te.isEmpty()) {
                        this.tileEntities.remove(te.func_174877_v());
                    } else {
                        this.tileEntities.put(te.func_174877_v(), te);
                    }
                } else if (te.isEmpty()) {
                    this.tileEntities.remove(te.func_174877_v());
                }
                this.modified = true;
            } else {
                if (te.isEmpty()) {
                    return;
                }
                this.tileEntities.put(te.func_174877_v(), te);
                if (this.complete) {
                    this.modified = true;
                }
                if (!this.modified) {
                    this.addRenderDataInternal(te);
                }
            }
            if (this.modified) {
                this.complete = false;
            }
        }
    }

    private void addRenderDataInternal(TileEntityLittleTiles te) {
        LayeredRenderBufferCache cache = te.render.getBufferCache();
        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
            this.cachedBuffers[i].add(te.render, cache.get(i));
        }
    }

    public void resortTransparency(int index, float x, float y, float z) {
        if (index == this.transparencySortedIndex) {
            return;
        }
        this.transparencySortedIndex = index;
        int translucentIndex = BlockRenderLayer.TRANSLUCENT.ordinal();
        BufferBuilder builder = this.builders[translucentIndex];
        if (builder != null) {
            builder.func_181674_a(x, y, z);
            if (this.vertexBuffers[translucentIndex] != null) {
                this.vertexBuffers[translucentIndex].func_177362_c();
            }
            this.vertexBuffers[translucentIndex] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            this.vertexBuffers[translucentIndex].func_181722_a(builder.func_178966_f());
        }
    }

    protected void processQueue() {
        for (int i = 0; i < this.cachedBuffers.length; ++i) {
            if (this.cachedBuffers[i].expanded() <= (this.builders[i] != null ? BufferBuilderUtils.getBufferSizeByte((BufferBuilder)this.builders[i]) : 0)) continue;
            if (this.builders[i] == null) {
                BufferBuilder tempBuffer = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_177338_f() + this.cachedBuffers[i].expanded());
                tempBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                tempBuffer.func_178969_c((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
                this.builders[i] = tempBuffer;
            } else {
                BufferBuilderUtils.ensureTotalSize((BufferBuilder)this.builders[i], (int)(this.builders[i].func_178973_g().func_177338_f() + this.cachedBuffers[i].expanded()));
            }
            this.cachedBuffers[i].fillBuilder(this.builders[i]);
            this.bufferChanged[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadBuffer() {
        LinkedHashMap<BlockPos, TileEntityLittleTiles> linkedHashMap = this.tileEntities;
        synchronized (linkedHashMap) {
            if (this.modified) {
                this.backToRAM();
                for (int i = 0; i < this.vertexBuffers.length; ++i) {
                    this.cachedBuffers[i].reset();
                    this.builders[i] = null;
                }
                this.modified = false;
                for (TileEntityLittleTiles te : this.tileEntities.values()) {
                    this.addRenderDataInternal(te);
                }
            }
            this.processQueue();
            for (int i = 0; i < this.bufferChanged.length; ++i) {
                if (!this.bufferChanged[i]) continue;
                if (this.vertexBuffers[i] == null) {
                    this.vertexBuffers[i] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
                }
                int vertexCount = this.builders[i].func_178989_h();
                this.builders[i].func_178966_f().rewind();
                this.builders[i].func_178966_f().limit(BufferBuilderUtils.getBufferSizeByte((BufferBuilder)this.builders[i]));
                this.vertexBuffers[i].func_181722_a(this.builders[i].func_178966_f());
                this.bufferChanged[i] = false;
            }
            if (this.complete) {
                for (int j = 0; j < this.builders.length; ++j) {
                    if (j == BlockRenderLayer.TRANSLUCENT.ordinal() || this.builders[j] == null) continue;
                    this.builders[j] = null;
                    this.cachedBuffers[j].uploaded();
                }
                this.complete = false;
            }
            if (this.lastRenderIndex != LittleChunkDispatcher.currentRenderState) {
                ArrayList<TileEntityLittleTiles> temp = new ArrayList<TileEntityLittleTiles>(this.tileEntities.values());
                this.tileEntities.clear();
                for (TileEntityLittleTiles te : temp) {
                    te.updateQuadCache(this);
                }
            }
        }
    }

    public VertexBuffer getLayerBuffer(BlockRenderLayer layer) {
        return this.vertexBuffers[layer.ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompleted() {
        LinkedHashMap<BlockPos, TileEntityLittleTiles> linkedHashMap = this.tileEntities;
        synchronized (linkedHashMap) {
            this.complete = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backToRAM() {
        LinkedHashMap<BlockPos, TileEntityLittleTiles> linkedHashMap = this.tileEntities;
        synchronized (linkedHashMap) {
            for (int j = 0; j < this.vertexBuffers.length; ++j) {
                if (j == BlockRenderLayer.TRANSLUCENT.ordinal() || this.cachedBuffers[j].isEmpty() || this.vertexBuffers[j] == null) continue;
                this.vertexBuffers[j].func_177359_a();
                try {
                    ByteBuffer uploadedData = RenderUploader.glMapBufferRange(this.cachedBuffers[j].totalSize());
                    if (uploadedData != null) {
                        this.cachedBuffers[j].download(uploadedData);
                    } else {
                        this.cachedBuffers[j].discard();
                    }
                }
                catch (RenderUploader.NotSupportedException e) {
                    e.printStackTrace();
                }
                this.vertexBuffers[j].func_177361_b();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        LinkedHashMap<BlockPos, TileEntityLittleTiles> linkedHashMap = this.tileEntities;
        synchronized (linkedHashMap) {
            for (int i = 0; i < this.vertexBuffers.length; ++i) {
                if (this.vertexBuffers[i] != null) {
                    this.vertexBuffers[i].func_177362_c();
                }
                this.builders[i] = null;
                this.cachedBuffers[i].reset();
            }
            this.tileEntities.clear();
        }
    }
}

