/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.overlay;

import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.mc.GuiContainerSub;
import com.creativemd.creativecore.common.gui.premade.SubContainerEmpty;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.api.ILittleEditor;
import com.creativemd.littletiles.common.api.ILittlePlacer;
import com.creativemd.littletiles.common.api.ILittleTool;
import com.creativemd.littletiles.common.packet.LittleFlipPacket;
import com.creativemd.littletiles.common.packet.LittleRotatePacket;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.IMarkMode;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PreviewRenderer {
    public static final ResourceLocation WHITE_TEXTURE = new ResourceLocation("littletiles", "textures/preview.png");
    public static Minecraft mc = Minecraft.func_71410_x();
    public static IMarkMode marked;

    public static boolean isCentered(EntityPlayer player, ILittlePlacer iTile) {
        if (iTile.snapToGridByDefault()) {
            return LittleAction.isUsingSecondMode(player) && marked == null;
        }
        return LittleTiles.CONFIG.building.invertStickToGrid == LittleAction.isUsingSecondMode(player) || marked != null;
    }

    public static boolean isFixed(EntityPlayer player, ILittlePlacer iTile) {
        if (iTile.snapToGridByDefault()) {
            return !LittleAction.isUsingSecondMode(player) && marked == null;
        }
        return LittleTiles.CONFIG.building.invertStickToGrid != LittleAction.isUsingSecondMode(player) && marked == null;
    }

    public static void handleUndoAndRedo(EntityPlayer player) {
        while (LittleTilesClient.undo.func_151468_f()) {
            try {
                if (!LittleAction.canUseUndoOrRedo(player)) continue;
                LittleAction.undo();
            }
            catch (LittleActionException e) {
                LittleAction.handleExceptionClient(e);
            }
        }
        while (LittleTilesClient.redo.func_151468_f()) {
            try {
                if (!LittleAction.canUseUndoOrRedo(player)) continue;
                LittleAction.redo();
            }
            catch (LittleActionException e) {
                LittleAction.handleExceptionClient(e);
            }
        }
    }

    @SubscribeEvent
    public void unload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            LittleAction.unloadWorld();
        }
    }

    @SubscribeEvent
    public void tick(RenderWorldLastEvent event) {
        if (PreviewRenderer.mc.field_71439_g != null && PreviewRenderer.mc.field_71415_G && !PreviewRenderer.mc.field_71474_y.field_74319_N) {
            WorldClient world = PreviewRenderer.mc.field_71441_e;
            EntityPlayerSP player = PreviewRenderer.mc.field_71439_g;
            ItemStack stack = PreviewRenderer.mc.field_71439_g.func_184614_ca();
            if (!LittleAction.canPlace((EntityPlayer)player)) {
                return;
            }
            PreviewRenderer.handleUndoAndRedo((EntityPlayer)player);
            if (stack.func_77973_b() instanceof ILittleTool && (marked != null || PreviewRenderer.mc.field_71476_x != null && PreviewRenderer.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && PreviewRenderer.mc.field_71476_x.field_178784_b != null)) {
                PlacementPosition position = marked != null ? marked.getPosition() : PlacementHelper.getPosition((World)world, PreviewRenderer.mc.field_71476_x, ((ILittleTool)stack.func_77973_b()).getPositionContext(stack), (ILittleTool)stack.func_77973_b(), stack);
                double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                this.processRotateKeys(stack, position.getContext());
                ((ILittleTool)stack.func_77973_b()).tick((EntityPlayer)player, stack, position, PreviewRenderer.mc.field_71476_x);
                if (PlacementHelper.isLittleBlock(stack)) {
                    ILittlePlacer iTile = PlacementHelper.getLittleInterface(stack);
                    PlacementMode mode = iTile.getPlacementMode(stack);
                    if (mode.getPreviewMode() == PlacementMode.PreviewMode.PREVIEWS) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        GlStateManager.func_179098_w();
                        PreviewRenderer.mc.field_71446_o.func_110577_a(WHITE_TEXTURE);
                        GlStateManager.func_179132_a((boolean)false);
                        boolean allowLowResolution = marked != null ? marked.allowLowResolution() : true;
                        PlacementPreview result = PlacementHelper.getPreviews((World)world, stack, position, PreviewRenderer.isCentered((EntityPlayer)player, iTile), PreviewRenderer.isFixed((EntityPlayer)player, iTile), allowLowResolution, mode);
                        if (result != null) {
                            this.processMarkKey((EntityPlayer)player, iTile, stack, result);
                            List<PlacePreview> placePreviews = result.getPreviews();
                            double posX = (double)result.pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
                            double posY = (double)result.pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
                            double posZ = (double)result.pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
                            float alpha = (float)(Math.sin((float)System.nanoTime() / 2.0E8f) * (double)0.2f + 0.5);
                            for (int i = 0; i < placePreviews.size(); ++i) {
                                PlacePreview preview = placePreviews.get(i);
                                List<LittleRenderBox> cubes = preview.getPreviews(result.context);
                                for (LittleRenderBox cube : cubes) {
                                    cube.renderPreview(posX, posY, posZ, (int)(alpha * iTile.getPreviewAlphaFactor() * 255.0f));
                                }
                            }
                            if (position.positingCubes != null) {
                                for (LittleRenderBox cube : position.positingCubes) {
                                    cube.renderPreview(posX, posY, posZ, (int)(alpha * ColorUtils.getAlphaDecimal((int)cube.color) * iTile.getPreviewAlphaFactor() * 255.0f));
                                }
                            }
                        }
                        GlStateManager.func_179132_a((boolean)true);
                        GlStateManager.func_179098_w();
                        GlStateManager.func_179084_k();
                    }
                } else {
                    this.processMarkKey((EntityPlayer)player, (ILittleTool)stack.func_77973_b(), stack, null);
                }
                ((ILittleTool)stack.func_77973_b()).render((EntityPlayer)player, stack, x, y, z);
                if (marked != null) {
                    marked.render(x, y, z);
                }
            } else {
                marked = null;
            }
        }
    }

    public void processMarkKey(EntityPlayer player, ILittleTool iTile, ItemStack stack, PlacementPreview preview) {
        while (LittleTilesClient.mark.func_151468_f()) {
            if (marked == null) {
                marked = iTile.onMark(player, stack, PlacementHelper.getPosition(player.field_70170_p, PreviewRenderer.mc.field_71476_x, iTile.getPositionContext(stack), iTile, stack), PreviewRenderer.mc.field_71476_x, preview);
                if (!GuiScreen.func_146271_m()) continue;
                FMLClientHandler.instance().displayGuiScreen(player, (GuiScreen)new GuiContainerSub(player, marked.getConfigurationGui(), (SubContainer)new SubContainerEmpty(player)));
                continue;
            }
            if (GuiScreen.func_146271_m()) {
                FMLClientHandler.instance().displayGuiScreen(player, (GuiScreen)new GuiContainerSub(player, marked.getConfigurationGui(), (SubContainer)new SubContainerEmpty(player)));
                continue;
            }
            marked.done();
            marked = null;
        }
    }

    public static void processRotateKey(EntityPlayer player, Rotation rotation, ItemStack stack) {
        LittleRotatePacket packet = new LittleRotatePacket(rotation);
        packet.executeClient(player);
        if (stack.func_77973_b() instanceof ILittleTool && !((ILittleTool)stack.func_77973_b()).sendTransformationUpdate()) {
            return;
        }
        PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
    }

    public void processRotateKeys(ItemStack stack, LittleGridContext context) {
        boolean repeated;
        while (LittleTilesClient.flip.func_151468_f()) {
            PreviewRenderer.processFlipKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, stack);
        }
        boolean bl = repeated = marked != null;
        while (LittleTilesClient.up.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, LittleAction.isUsingSecondMode((EntityPlayer)PreviewRenderer.mc.field_71439_g) ? EnumFacing.UP : EnumFacing.EAST);
                continue;
            }
            PreviewRenderer.processRotateKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, Rotation.Z_CLOCKWISE, stack);
        }
        while (LittleTilesClient.down.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, LittleAction.isUsingSecondMode((EntityPlayer)PreviewRenderer.mc.field_71439_g) ? EnumFacing.DOWN : EnumFacing.WEST);
                continue;
            }
            PreviewRenderer.processRotateKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, Rotation.Z_COUNTER_CLOCKWISE, stack);
        }
        while (LittleTilesClient.right.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, EnumFacing.SOUTH);
                continue;
            }
            PreviewRenderer.processRotateKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, Rotation.Y_COUNTER_CLOCKWISE, stack);
        }
        while (LittleTilesClient.left.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, EnumFacing.NORTH);
                continue;
            }
            PreviewRenderer.processRotateKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, Rotation.Y_CLOCKWISE, stack);
        }
    }

    public static void processFlipKey(EntityPlayer player, ItemStack stack) {
        int i4 = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing direction = null;
        switch (i4) {
            case 0: {
                direction = EnumFacing.SOUTH;
                break;
            }
            case 1: {
                direction = EnumFacing.WEST;
                break;
            }
            case 2: {
                direction = EnumFacing.NORTH;
                break;
            }
            case 3: {
                direction = EnumFacing.EAST;
            }
        }
        if (player.field_70125_A > 45.0f) {
            direction = EnumFacing.DOWN;
        }
        if (player.field_70125_A < -45.0f) {
            direction = EnumFacing.UP;
        }
        LittleFlipPacket packet = new LittleFlipPacket(direction.func_176740_k());
        packet.executeClient(player);
        if (stack.func_77973_b() instanceof ILittleTool && !((ILittleTool)stack.func_77973_b()).sendTransformationUpdate()) {
            return;
        }
        PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        if (!LittleAction.canPlace(player)) {
            return;
        }
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        if ((event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK || marked != null) && stack.func_77973_b() instanceof ILittleTool) {
            ILittlePlacer iTile;
            PlacementMode mode;
            BlockPos pos = marked != null ? marked.getPosition().getPos() : event.getTarget().func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            if (stack.func_77973_b() instanceof ILittleEditor) {
                ILittleEditor selector = (ILittleEditor)stack.func_77973_b();
                this.processMarkKey(player, selector, stack, null);
                PlacementPosition result = new PlacementPosition(event.getTarget(), selector.getPositionContext(stack));
                if (selector.hasCustomBoxes(world, stack, player, state, result, event.getTarget()) || marked != null) {
                    LittleBoxes boxes = ((ILittleEditor)stack.func_77973_b()).getBoxes(world, stack, player, result, event.getTarget());
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_179098_w();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(WHITE_TEXTURE);
                    GlStateManager.func_179132_a((boolean)false);
                    double posX = x - (double)boxes.pos.func_177958_n();
                    double posY = y - (double)boxes.pos.func_177956_o();
                    double posZ = z - (double)boxes.pos.func_177952_p();
                    GlStateManager.func_187441_d((float)4.0f);
                    for (LittleBox box : boxes.all()) {
                        LittleRenderBox cube = box.getRenderingCube(boxes.getContext(), null, 0);
                        if (cube == null) continue;
                        cube.color = 0;
                        cube.renderLines(-posX, -posY, -posZ, 102, cube.getCenter(), 0.002);
                    }
                    if (state.func_185904_a() != Material.field_151579_a && world.func_175723_af().func_177746_a(pos)) {
                        GlStateManager.func_187441_d((float)1.0f);
                        RenderGlobal.func_189697_a((AxisAlignedBB)state.func_185918_c(world, pos).func_186662_g(0.002).func_72317_d(-x, -y, -z), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    }
                    GlStateManager.func_179143_c((int)515);
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179084_k();
                    event.setCanceled(true);
                }
            } else if (stack.func_77973_b() instanceof ILittlePlacer && (mode = (iTile = PlacementHelper.getLittleInterface(stack)).getPlacementMode(stack)).getPreviewMode() == PlacementMode.PreviewMode.LINES) {
                PlacementPosition position = marked != null ? marked.getPosition() : PlacementHelper.getPosition(world, PreviewRenderer.mc.field_71476_x, iTile.getPositionContext(stack), iTile, stack);
                boolean allowLowResolution = marked != null ? marked.allowLowResolution() : true;
                PlacementPreview result = PlacementHelper.getPreviews(world, stack, position, PreviewRenderer.isCentered(player, iTile), PreviewRenderer.isFixed(player, iTile), allowLowResolution, mode);
                if (result != null) {
                    this.processMarkKey(player, iTile, stack, result);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_187441_d((float)((float)LittleTiles.CONFIG.rendering.previewLineThickness));
                    GlStateManager.func_179098_w();
                    PreviewRenderer.mc.field_71446_o.func_110577_a(WHITE_TEXTURE);
                    GlStateManager.func_179132_a((boolean)false);
                    double posX = x - (double)result.pos.func_177958_n();
                    double posY = y - (double)result.pos.func_177956_o();
                    double posZ = z - (double)result.pos.func_177952_p();
                    List<PlacePreview> placePreviews = result.getPreviews();
                    for (int i = 0; i < placePreviews.size(); ++i) {
                        for (LittleRenderBox cube : placePreviews.get(i).getPreviews(result.context)) {
                            cube.renderLines(-posX, -posY, -posZ, 102, cube.getCenter(), 0.002);
                        }
                    }
                    if (position.positingCubes != null) {
                        for (LittleRenderBox cube : position.positingCubes) {
                            cube.renderLines(-posX, -posY, -posZ, 102, cube.getCenter(), 0.002);
                        }
                    }
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179084_k();
                }
            }
        }
    }
}

