/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.world;

import com.creativemd.littletiles.client.render.cache.LayeredRenderBoxCache;
import com.creativemd.littletiles.client.render.cache.LayeredRenderBufferCache;
import com.creativemd.littletiles.client.render.cache.RenderingThread;
import com.creativemd.littletiles.client.render.world.LittleChunkDispatcher;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityRenderManager {
    private TileEntityLittleTiles te;
    private int requestedIndex = -1;
    private int finishedIndex = -1;
    private int renderState = -1;
    private boolean queued = false;
    private boolean building = false;
    public boolean hasLightChanged = false;
    public boolean hasNeighbourChanged = false;
    private double cachedRenderDistance = 0.0;
    private AxisAlignedBB cachedRenderBoundingBox = null;
    private boolean requireRenderingBoundingBoxUpdate = false;
    private final LayeredRenderBufferCache bufferCache = new LayeredRenderBufferCache();
    private final LayeredRenderBoxCache boxCache = new LayeredRenderBoxCache();

    public TileEntityRenderManager(TileEntityLittleTiles te) {
        this.te = te;
    }

    public void setTe(TileEntityLittleTiles te) {
        this.te = te;
    }

    public boolean isInQueue() {
        return this.queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkUpdate(Object chunk) {
        TileEntityRenderManager tileEntityRenderManager = this;
        synchronized (tileEntityRenderManager) {
            boolean doesNeedUpdate;
            boolean bl = doesNeedUpdate = this.hasNeighbourChanged || this.hasLightChanged || this.requestedIndex == -1;
            if (this.renderState != LittleChunkDispatcher.currentRenderState) {
                if (!this.building) {
                    this.boxCache.clear();
                }
                doesNeedUpdate = true;
            }
            this.hasLightChanged = false;
            this.hasNeighbourChanged = false;
            if (doesNeedUpdate) {
                this.queue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tilesChanged() {
        this.requireRenderingBoundingBoxUpdate = true;
        this.cachedRenderDistance = 0.0;
        TileEntityRenderManager tileEntityRenderManager = this;
        synchronized (tileEntityRenderManager) {
            if (!this.building) {
                this.boxCache.clear();
            }
            this.queue();
        }
    }

    public double getMaxRenderDistanceSquared() {
        if (this.cachedRenderDistance == 0.0) {
            double renderDistance = 25.0;
            for (LittleStructure structure : this.te.rendering()) {
                renderDistance = Math.max(renderDistance, structure.getMaxRenderDistanceSquared());
            }
            this.cachedRenderDistance = renderDistance;
        }
        return this.cachedRenderDistance;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.requireRenderingBoundingBoxUpdate || this.cachedRenderBoundingBox == null) {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double minZ = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            double maxZ = -1.7976931348623157E308;
            boolean found = false;
            for (LittleStructure structure : this.te.rendering()) {
                AxisAlignedBB box = structure.getRenderBoundingBox();
                if (box == null) continue;
                box = box.func_186670_a(this.te.func_174877_v());
                minX = Math.min(box.field_72340_a, minX);
                minY = Math.min(box.field_72338_b, minY);
                minZ = Math.min(box.field_72339_c, minZ);
                maxX = Math.max(box.field_72336_d, maxX);
                maxY = Math.max(box.field_72337_e, maxY);
                maxZ = Math.max(box.field_72334_f, maxZ);
                found = true;
            }
            this.cachedRenderBoundingBox = found ? new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ) : new AxisAlignedBB(this.te.func_174877_v());
            this.requireRenderingBoundingBoxUpdate = false;
        }
        return this.cachedRenderBoundingBox;
    }

    public void neighborChanged() {
        this.hasNeighbourChanged = true;
        this.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue() {
        TileEntityRenderManager tileEntityRenderManager = this;
        synchronized (tileEntityRenderManager) {
            ++this.requestedIndex;
            if (!this.queued && RenderingThread.addCoordToUpdate(this.te)) {
                this.queued = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startBuildingCache() {
        TileEntityRenderManager tileEntityRenderManager = this;
        synchronized (tileEntityRenderManager) {
            this.building = true;
            return this.requestedIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishBuildingCache(int index, int renderState, boolean force) {
        TileEntityRenderManager tileEntityRenderManager = this;
        synchronized (tileEntityRenderManager) {
            boolean done;
            this.building = false;
            this.finishedIndex = index;
            this.renderState = renderState;
            boolean bl = done = force || index == this.requestedIndex && this.renderState == renderState;
            if (done) {
                this.queued = false;
            }
            this.hasLightChanged = false;
            this.hasNeighbourChanged = false;
            return done;
        }
    }

    public void resetRenderingState() {
        this.queued = false;
        this.building = false;
        this.requestedIndex = -1;
        this.finishedIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkUnload() {
        TileEntityRenderManager tileEntityRenderManager = this;
        synchronized (tileEntityRenderManager) {
            this.bufferCache.setEmpty();
            this.boxCache.clear();
            this.cachedRenderBoundingBox = null;
        }
    }

    public LayeredRenderBoxCache getBoxCache() {
        return this.boxCache;
    }

    public LayeredRenderBufferCache getBufferCache() {
        return this.bufferCache;
    }
}

