/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionDestroy;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxReturnedVolume;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.ParentTileList;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.selection.selector.TileSelector;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleActionDestroyBoxes
extends LittleActionBoxes {
    public List<LittleActionDestroy.StructurePreview> destroyedStructures;
    public LittleAbsolutePreviews previews;
    public boolean doneSomething;

    public LittleActionDestroyBoxes(LittleBoxes boxes) {
        super(boxes);
    }

    public LittleActionDestroyBoxes() {
    }

    private boolean containsStructure(LittleStructure structure) {
        for (LittleActionDestroy.StructurePreview structurePreview : this.destroyedStructures) {
            if (structurePreview.structure != structure) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSkipTile(IParentTileList parent, LittleTile tile) {
        return false;
    }

    public LittleIngredients action(EntityPlayer player, TileEntityLittleTiles te, List<LittleBox> boxes, boolean simulate, LittleGridContext context) {
        this.doneSomething = false;
        if (this.previews == null) {
            this.previews = new LittleAbsolutePreviews(te.func_174877_v(), context);
        }
        LittleIngredients ingredients = new LittleIngredients();
        ArrayList<LittleTile> placedTiles = new ArrayList<LittleTile>();
        ArrayList<LittleTile> destroyedTiles = new ArrayList<LittleTile>();
        for (IParentTileList parent : te.groups()) {
            if (parent.isStructure()) {
                if (simulate) continue;
                boolean intersects = false;
                block5: for (LittleTile tile : parent) {
                    for (int j = 0; j < boxes.size(); ++j) {
                        if (!tile.intersectsWith(boxes.get(j))) continue;
                        intersects = true;
                        break block5;
                    }
                }
                if (!intersects) continue;
                try {
                    LittleStructure structure = parent.getStructure();
                    if (this.containsStructure(structure)) continue;
                    this.destroyedStructures.add(new LittleActionDestroy.StructurePreview(structure));
                }
                catch (CorruptedConnectionException | NotYetConnectedException structure) {}
                continue;
            }
            for (LittleTile tile : parent) {
                if (this.shouldSkipTile(parent, tile)) continue;
                LittleBox intersecting = null;
                boolean intersects = false;
                for (int j = 0; j < boxes.size(); ++j) {
                    if (!tile.intersectsWith(boxes.get(j))) continue;
                    intersects = true;
                    intersecting = boxes.get(j);
                    break;
                }
                if (!intersects) continue;
                this.doneSomething = true;
                if (!tile.equalsBox(intersecting)) {
                    double volume = 0.0;
                    LittlePreview preview = tile.getPreviewTile();
                    ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                    LittleBoxReturnedVolume returnedVolume = new LittleBoxReturnedVolume();
                    List<LittleBox> newBoxes = tile.cutOut(boxes, cutout, returnedVolume);
                    if (newBoxes != null) {
                        if (!simulate) {
                            for (int i = 0; i < newBoxes.size(); ++i) {
                                LittleTile newTile = tile.copy();
                                newTile.setBox(newBoxes.get(i));
                                placedTiles.add(newTile);
                            }
                            destroyedTiles.add(tile);
                        }
                        for (int l = 0; l < cutout.size(); ++l) {
                            volume += ((LittleBox)cutout.get(l)).getPercentVolume(context);
                            if (simulate) continue;
                            LittlePreview preview2 = preview.copy();
                            preview2.box = ((LittleBox)cutout.get(l)).copy();
                            this.previews.addPreview(te.func_174877_v(), preview2, context);
                        }
                    }
                    if (volume > 0.0) {
                        ingredients.add(LittleActionDestroyBoxes.getIngredients(preview, volume));
                    }
                    if (!returnedVolume.has()) continue;
                    ingredients.add(LittleActionDestroyBoxes.getIngredients(preview, returnedVolume.getPercentVolume(context)));
                    continue;
                }
                ingredients.add(LittleActionDestroyBoxes.getIngredients(parent, tile));
                if (simulate) continue;
                this.previews.addTile(parent, tile);
                destroyedTiles.add(tile);
            }
        }
        if (!simulate) {
            for (LittleActionDestroy.StructurePreview structure : this.destroyedStructures) {
                try {
                    if (structure.structure.mainBlock.isRemoved()) continue;
                    structure.structure.onLittleTileDestroy();
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
            }
            te.updateTiles(x -> {
                ParentTileList parent = x.noneStructureTiles();
                parent.removeAll(destroyedTiles);
                parent.addAll((Collection<? extends LittleTile>)placedTiles);
            });
        }
        return ingredients;
    }

    @Override
    public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state, List<LittleBox> boxes, LittleGridContext context) throws LittleActionException {
        LittleActionDestroyBoxes.fireBlockBreakEvent(world, pos, player);
        TileEntityLittleTiles tileEntity = LittleActionDestroyBoxes.loadTe(player, world, pos, null, true, 0);
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te = tileEntity;
            if (context != te.getContext()) {
                if (context.size < te.getContext().size) {
                    for (LittleBox box : boxes) {
                        box.convertTo(context, te.getContext());
                    }
                    context = te.getContext();
                } else {
                    te.convertTo(context);
                }
            }
            if (LittleActionDestroyBoxes.checkAndGive(player, new LittleInventory(player), this.action(player, tileEntity, boxes, true, context))) {
                this.action(player, tileEntity, boxes, false, context);
            }
            tileEntity.combineTiles();
            if (!this.doneSomething) {
                tileEntity.convertBlockToVanilla();
            }
        }
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        this.destroyedStructures = new ArrayList<LittleActionDestroy.StructurePreview>();
        return super.action(player);
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert(EntityPlayer player) {
        boolean additionalPreviews = this.previews != null && this.previews.size() > 0;
        LittleAction[] actions = new LittleAction[(additionalPreviews ? 1 : 0) + this.destroyedStructures.size()];
        if (additionalPreviews) {
            this.previews.convertToSmallest();
            actions[0] = new LittleActionPlaceAbsolute(this.previews, PlacementMode.fill, true);
        }
        for (int i = 0; i < this.destroyedStructures.size(); ++i) {
            actions[(additionalPreviews ? 1 : 0) + i] = this.destroyedStructures.get(i).getPlaceAction();
        }
        return new LittleActionCombined(actions);
    }

    public static List<LittleTile> removeBox(TileEntityLittleTiles te, LittleGridContext context, LittleBox toCut, boolean update) {
        if (context != te.getContext()) {
            if (context.size > te.getContext().size) {
                te.convertTo(context);
            } else {
                toCut.convertTo(context, te.getContext());
                context = te.getContext();
            }
        }
        ArrayList<LittleTile> removed = new ArrayList<LittleTile>();
        Consumer<TileEntityLittleTiles.TileEntityInteractor> consumer = x -> {
            ArrayList<LittleTile> toAdd = new ArrayList<LittleTile>();
            for (LittleTile tile : x.noneStructureTiles()) {
                if (!tile.intersectsWith(toCut)) continue;
                x.noneStructureTiles().remove(tile);
                if (!tile.equalsBox(toCut)) {
                    LittleTile copy;
                    double volume = 0.0;
                    LittlePreview preview = tile.getPreviewTile();
                    ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                    ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
                    boxes.add(toCut);
                    LittleBoxReturnedVolume returnedVolume = new LittleBoxReturnedVolume();
                    List<LittleBox> newBoxes = tile.cutOut(boxes, cutout, returnedVolume);
                    if (newBoxes == null) continue;
                    for (LittleBox box : newBoxes) {
                        copy = tile.copy();
                        copy.setBox(box);
                        toAdd.add(copy);
                    }
                    for (LittleBox box : cutout) {
                        copy = tile.copy();
                        copy.setBox(box);
                        removed.add(copy);
                    }
                    if (!returnedVolume.has()) continue;
                    removed.add(returnedVolume.createFakeTile(tile));
                    continue;
                }
                removed.add(tile);
            }
            x.noneStructureTiles().addAll((Collection<? extends LittleTile>)toAdd);
        };
        if (update) {
            te.updateTiles(consumer);
        } else {
            te.updateTilesSecretly(consumer);
        }
        return removed;
    }

    public static List<LittleTile> removeBoxes(TileEntityLittleTiles te, LittleGridContext context, List<LittleBox> boxes) {
        if (context != te.getContext()) {
            if (context.size > te.getContext().size) {
                te.convertTo(context);
            } else {
                for (LittleBox box : boxes) {
                    box.convertTo(context, te.getContext());
                }
                context = te.getContext();
            }
        }
        ArrayList<LittleTile> removed = new ArrayList<LittleTile>();
        te.updateTiles(x -> {
            ArrayList<LittleTile> toAdd = new ArrayList<LittleTile>();
            Iterator iterator = x.noneStructureTiles().iterator();
            while (iterator.hasNext()) {
                LittleTile tile = (LittleTile)iterator.next();
                LittleBox intersecting = null;
                boolean intersects = false;
                for (int j = 0; j < boxes.size(); ++j) {
                    if (!tile.intersectsWith((LittleBox)boxes.get(j))) continue;
                    intersects = true;
                    intersecting = (LittleBox)boxes.get(j);
                    break;
                }
                if (!intersects) continue;
                iterator.remove();
                if (!tile.equalsBox(intersecting)) {
                    LittleTile copy;
                    double volume = 0.0;
                    LittlePreview preview = tile.getPreviewTile();
                    ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                    LittleBoxReturnedVolume returnedVolume = new LittleBoxReturnedVolume();
                    List<LittleBox> newBoxes = tile.cutOut(boxes, cutout, returnedVolume);
                    if (newBoxes == null) continue;
                    for (LittleBox box : newBoxes) {
                        copy = tile.copy();
                        copy.setBox(box);
                        toAdd.add(copy);
                    }
                    for (LittleBox box : cutout) {
                        copy = tile.copy();
                        copy.setBox(box);
                        removed.add(copy);
                    }
                    if (!returnedVolume.has()) continue;
                    removed.add(returnedVolume.createFakeTile(tile));
                    continue;
                }
                removed.add(tile);
            }
            x.noneStructureTiles().addAll((Collection<? extends LittleTile>)toAdd);
        });
        return removed;
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        return this.assignFlip(new LittleActionDestroyBoxes(), axis, box);
    }

    public static class LittleActionDestroyBoxesFiltered
    extends LittleActionDestroyBoxes {
        public TileSelector selector;

        public LittleActionDestroyBoxesFiltered(LittleBoxes boxes, TileSelector selector) {
            super(boxes);
            this.selector = selector;
        }

        public LittleActionDestroyBoxesFiltered() {
        }

        @Override
        public void writeBytes(ByteBuf buf) {
            super.writeBytes(buf);
            LittleActionDestroyBoxesFiltered.writeSelector(this.selector, buf);
        }

        @Override
        public void readBytes(ByteBuf buf) {
            super.readBytes(buf);
            this.selector = LittleActionDestroyBoxesFiltered.readSelector(buf);
        }

        @Override
        public boolean shouldSkipTile(IParentTileList parent, LittleTile tile) {
            return !this.selector.is(parent, tile);
        }
    }
}

