/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.block;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.face.CachedFaceRenderType;
import com.creativemd.creativecore.client.rendering.face.FaceRenderType;
import com.creativemd.creativecore.client.rendering.face.IFaceRenderType;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.cache.LayeredRenderBoxCache;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.action.block.LittleActionDestroy;
import com.creativemd.littletiles.common.item.ItemBlockTiles;
import com.creativemd.littletiles.common.item.ItemLittlePaintBrush;
import com.creativemd.littletiles.common.item.ItemLittleSaw;
import com.creativemd.littletiles.common.item.ItemLittleWrench;
import com.creativemd.littletiles.common.mod.ctm.CTMManager;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.type.LittleBed;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.face.LittleBoxFace;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.parent.ParentTileList;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTilesRendered;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTilesTicking;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTilesTickingRendered;
import com.creativemd.littletiles.server.LittleTilesServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.ctm.api.IFacade;

@Optional.Interface(iface="team.chisel.ctm.api.IFacade", modid="ctm")
public class BlockTile
extends BlockContainer
implements ICreativeRendered,
IFacade {
    private static final TEResult FAILED = new TEResult(null, null, null);
    public static final SoundType SILENT = new SoundType(-1.0f, 1.0f, SoundEvents.field_187835_fT, SoundEvents.field_187902_gb, SoundEvents.field_187845_fY, SoundEvents.field_187843_fX, SoundEvents.field_187841_fW);
    public final boolean ticking;
    public final boolean rendered;
    @SideOnly(value=Side.CLIENT)
    public static Minecraft mc;
    private boolean lightLoopPreventer = true;
    private static boolean loadingTileEntityFromWorld;

    public static TileEntityLittleTiles loadTe(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        loadingTileEntityFromWorld = true;
        TileEntity tileEntity = null;
        try {
            tileEntity = world.func_175625_s(pos);
        }
        catch (Exception e) {
            return null;
        }
        loadingTileEntityFromWorld = false;
        if (tileEntity instanceof TileEntityLittleTiles && ((TileEntityLittleTiles)tileEntity).hasLoaded()) {
            return (TileEntityLittleTiles)tileEntity;
        }
        return null;
    }

    public static TEResult loadTeAndTile(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return BlockTile.loadTeAndTile(world, pos, player, TickUtils.getPartialTickTime());
    }

    public static TEResult loadTeAndTile(IBlockAccess world, BlockPos pos, EntityPlayer player, float partialTickTime) {
        Pair<IParentTileList, LittleTile> pair;
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null && (pair = te.getFocusedTile(player, partialTickTime)) != null) {
            return new TEResult(te, (IParentTileList)pair.key, (LittleTile)pair.value);
        }
        return FAILED;
    }

    public static boolean selectEntireBlock(EntityPlayer player, boolean secondMode) {
        return secondMode && !(player.func_184614_ca().func_77973_b() instanceof ItemLittleSaw) && !(player.func_184614_ca().func_77973_b() instanceof ItemLittlePaintBrush);
    }

    public BlockTile(Material material, boolean ticking, boolean rendered) {
        super(material);
        this.ticking = ticking;
        this.rendered = rendered;
        this.func_149647_a(LittleTiles.littleTab);
        this.func_149752_b(3.0f);
        this.func_149672_a(SILENT);
    }

    public static int getStateId(TileEntityLittleTiles te) {
        return BlockTile.getStateId(te.isTicking(), te.isRendered());
    }

    public static int getStateId(boolean ticking, boolean rendered) {
        return rendered ? (ticking ? 3 : 2) : (ticking ? 1 : 0);
    }

    public static IBlockState getState(int id) {
        switch (id) {
            case 0: {
                return LittleTiles.blockTileNoTicking.func_176223_P();
            }
            case 1: {
                return LittleTiles.blockTileTicking.func_176223_P();
            }
            case 2: {
                return LittleTiles.blockTileNoTickingRendered.func_176223_P();
            }
            case 3: {
                return LittleTiles.blockTileTickingRendered.func_176223_P();
            }
        }
        return null;
    }

    public static IBlockState getStateByAttribute(int attribute) {
        return BlockTile.getState(LittleStructureAttribute.ticking(attribute), LittleStructureAttribute.tickRendering(attribute));
    }

    public static IBlockState getState(boolean ticking, boolean rendered) {
        return rendered ? (ticking ? LittleTiles.blockTileTickingRendered.func_176223_P() : LittleTiles.blockTileNoTickingRendered.func_176223_P()) : (ticking ? LittleTiles.blockTileTicking.func_176223_P() : LittleTiles.blockTileNoTicking.func_176223_P());
    }

    public static IBlockState getState(TileEntityLittleTiles te) {
        return BlockTile.getState(te.isTicking(), te.isRendered());
    }

    public static IBlockState getState(List<StructureTileList> structures) {
        boolean ticking = false;
        boolean rendered = false;
        for (StructureTileList structure : structures) {
            if (LittleStructureAttribute.ticking(structure.getAttribute())) {
                ticking = true;
            }
            if (LittleStructureAttribute.tickRendering(structure.getAttribute())) {
                rendered = true;
            }
            if (!ticking || !rendered) continue;
            break;
        }
        return BlockTile.getState(ticking, rendered);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            LittleStructure bed = null;
            if (player != null) {
                try {
                    bed = (LittleStructure)LittleBed.littleBed.get(player);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            for (LittleStructure structure : te.loadedStructures()) {
                if (structure != bed && !structure.isBed((EntityLivingBase)player)) continue;
                return true;
            }
        }
        return false;
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        return EnumFacing.SOUTH;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return false;
    }

    public BlockPos getBedSpawnPosition(IBlockState state, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        int tries = 0;
        EnumFacing enumfacing = EnumFacing.EAST;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!BlockTile.hasRoomForPlayer(world, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    protected static boolean hasRoomForPlayer(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid(worldIn, pos, EnumFacing.UP) && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null && entity != null && entity.func_174813_aQ() != null) {
            AxisAlignedBB bb = entity.func_174813_aQ().func_186662_g(0.001);
            for (IStructureTileList structure : te.structures()) {
                if (!LittleStructureAttribute.ladder(structure.getAttribute())) continue;
                for (LittleTile tile : structure) {
                    LittleBox box = tile.getCollisionBox();
                    if (box == null || !bb.func_72326_a(box.getBox(te.getContext(), te.func_174877_v()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return 0.1f;
    }

    public static boolean canHarvestBlock(EntityPlayer player, IBlockState state) {
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        String tool = state.func_177230_c().getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return player.func_184823_b(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= state.func_177230_c().getHarvestLevel(state);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, player);
        if (result.isComplete()) {
            state = result.tile.getBlockState();
            float hardness = state.func_185887_b(world, pos);
            if (hardness < 0.0f) {
                return 0.0f;
            }
            if (!BlockTile.canHarvestBlock(player, state)) {
                return player.getDigSpeed(state, pos) / hardness / 40.0f;
            }
            return player.getDigSpeed(state, pos) / hardness / 20.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)worldIn, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete()) {
            if (BlockTile.selectEntireBlock((EntityPlayer)BlockTile.mc.field_71439_g, LittleAction.isUsingSecondMode((EntityPlayer)BlockTile.mc.field_71439_g))) {
                return result.te.getSelectionBox();
            }
            if (LittleTiles.CONFIG.rendering.highlightStructureBox && result.parent.isStructure()) {
                try {
                    return result.parent.getStructure().getSurroundingBox().getAABB();
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return result.tile.getSelectedBox(pos, result.te.getContext());
        }
        return new AxisAlignedBB(pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null) {
            for (IParentTileList list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                if (list.isStructure() && LittleStructureAttribute.extraCollision(list.getAttribute())) {
                    try {
                        list.getStructure().addCollisionBoxes(pos, entityBox, collidingBoxes, entityIn);
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
                for (LittleTile tile : list) {
                    LittleBox box = tile.getCollisionBox();
                    if (box == null) continue;
                    box.addCollisionBoxes(te.getContext(), entityBox, collidingBoxes, pos);
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null && te.isEmpty()) {
            super.func_180663_b(world, pos, state);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntityLittleTiles te;
        if (LittleTiles.CONFIG.rendering.enableRandomDisplayTick && (te = BlockTile.loadTe((IBlockAccess)worldIn, pos)) != null) {
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                ((LittleTile)pair.value).randomDisplayTick((IParentTileList)pair.key, rand);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return this.onBlockActivatedClient(worldIn, pos, state, playerIn, hand, playerIn.func_184586_b(hand), facing, hitX, hitY, hitZ);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onBlockActivatedClient(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)worldIn, pos, playerIn);
        if (result.isComplete() && !(playerIn.func_184614_ca().func_77973_b() instanceof ItemLittleWrench)) {
            return new LittleActionActivated(worldIn, pos, playerIn).execute();
        }
        return false;
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity entity) {
        float slipperiness = 1.0f;
        boolean found = false;
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null && entity != null && entity.func_174813_aQ() != null) {
            AxisAlignedBB bb = entity.func_174813_aQ().func_72317_d(0.0, -0.001, 0.0);
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                LittleBox box = ((LittleTile)pair.value).getCollisionBox();
                if (box == null || !box.getBox(te.getContext(), pos).func_72326_a(bb)) continue;
                slipperiness = Math.min(slipperiness, ((LittleTile)pair.value).getSlipperiness(world, pos, entity));
                found = true;
            }
        }
        if (found) {
            return slipperiness;
        }
        return super.getSlipperiness(state, world, pos, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int light = 0;
        if (!this.lightLoopPreventer) {
            return 0;
        }
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            for (IParentTileList list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.lightEmitter(list.getAttribute())) {
                    try {
                        light = Math.max(light, list.getStructure().getLightValue(pos));
                        continue;
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
                for (LittleTile tile : list) {
                    this.lightLoopPreventer = false;
                    int tempLight = (int)Math.ceil((double)tile.getLightValue(world, pos) * tile.getPercentVolume(te.getContext()));
                    this.lightLoopPreventer = true;
                    if (tempLight <= light) continue;
                    light = tempLight;
                }
            }
        }
        return light;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (this.isSideSolid(state, worldIn, pos, face)) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            return te.sideCache.get(face).doesBlockLight();
        }
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            return te.sideCache.get(side).isFilled();
        }
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return this.removedByPlayerClient(state, world, pos, player, willHarvest);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean removedByPlayerClient(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, player, 1.0f);
        if (result.isComplete()) {
            return new LittleActionDestroy(world, pos, player).execute();
        }
        return false;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            return te.isEmpty();
        }
        return true;
    }

    public IBlockState getStateAtViewpoint(IBlockState state, IBlockAccess world, BlockPos pos, Vec3d viewpoint) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            int x = te.getContext().toGrid(viewpoint.field_72450_a);
            int y = te.getContext().toGrid(viewpoint.field_72448_b);
            int z = te.getContext().toGrid(viewpoint.field_72449_c);
            LittleBox box = new LittleBox(x, y, z, x + 1, y + 1, z + 1);
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                if (!((LittleTile)pair.value).intersectsWith(box)) continue;
                return ((LittleTile)pair.value).getBlockState();
            }
        }
        return state;
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete()) {
            if (BlockTile.selectEntireBlock((EntityPlayer)BlockTile.mc.field_71439_g, LittleAction.isUsingSecondMode(player))) {
                ItemStack drop = new ItemStack(LittleTiles.multiTiles);
                LittlePreview.saveTiles(world, result.te.getContext(), result.te, drop);
                return drop;
            }
            if (result.parent.isStructure()) {
                try {
                    return result.parent.getStructure().getStructureDrop();
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return result.tile.getDrop(result.te.getContext());
        }
        return ItemStack.field_190927_a;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            int heighest = 0;
            LittleTile heighestTile = null;
            for (IParentTileList list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                for (LittleTile tile : list) {
                    LittleBox box = tile.getCollisionBox();
                    if (box == null || box.maxY <= heighest) continue;
                    heighest = box.maxY;
                    heighestTile = tile;
                }
            }
            if (heighestTile != null) {
                world.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)heighestTile.getBlockState())});
            }
        }
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            int heighest = 0;
            LittleTile heighestTile = null;
            for (IParentTileList list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                for (LittleTile tile : list) {
                    LittleBox box = tile.getCollisionBox();
                    if (box == null || box.maxY <= heighest) continue;
                    heighest = box.maxY;
                    heighestTile = tile;
                }
            }
            Random random = new Random();
            if (heighestTile != null) {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + ((double)random.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)random.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)heighestTile.getBlockState())});
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState oldstate, World worldObj, RayTraceResult target, ParticleManager manager) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)worldObj, target.func_178782_a(), (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete()) {
            IBlockState state = result.tile.getBlockState();
            BlockPos pos = target.func_178782_a();
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = result.tile.getSelectedBox(BlockPos.field_177992_a, result.te.getContext());
            double d0 = (double)i + worldObj.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + worldObj.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + worldObj.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            EnumFacing side = target.field_178784_b;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            ((ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)})).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete()) {
            IBlockState state = result.tile.getBlockState();
            int i = 4;
            for (int j = 0; j < 1; ++j) {
                for (int k = 0; k < 1; ++k) {
                    for (int l = 0; l < 1; ++l) {
                        double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / 4.0;
                        double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / 4.0;
                        double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / 4.0;
                        manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public SoundType getSoundTypeClient(IBlockState state, World world, BlockPos pos) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result != null && result.tile != null) {
            return result.tile.getSound();
        }
        return null;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        TileEntityLittleTiles te;
        if (entity == null) {
            return SILENT;
        }
        SoundType sound = null;
        if (entity instanceof EntityPlayer && world.field_72995_K) {
            sound = this.getSoundTypeClient(state, world, pos);
        }
        if (sound == null && (te = BlockTile.loadTe((IBlockAccess)world, pos)) != null) {
            int heighest = 0;
            LittleTile heighestTile = null;
            for (IParentTileList list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                for (LittleTile tile : list) {
                    LittleBox box = tile.getCollisionBox();
                    if (box == null || box.maxY <= heighest) continue;
                    heighest = box.maxY;
                    heighestTile = tile;
                }
            }
            if (heighestTile != null) {
                return heighestTile.getSound();
            }
        }
        if (sound == null) {
            sound = SoundType.field_185851_d;
        }
        return sound;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        float bonus = 0.0f;
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                bonus = (float)((double)bonus + (double)((LittleTile)pair.value).getEnchantPowerBonus(world, pos) * ((LittleTile)pair.value).getPercentVolume(te.getContext()));
            }
        }
        return bonus;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null) {
            te.onNeighbourChanged();
            if (!worldIn.field_72995_K) {
                LittleTilesServer.NEIGHBOR.add(worldIn, pos);
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (loadingTileEntityFromWorld) {
            return;
        }
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            te.onNeighbourChanged();
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult moving;
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null && (moving = te.rayTrace(start, end)) != null) {
            return new RayTraceResult(moving.field_72307_f, moving.field_178784_b, pos);
        }
        return null;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null && te.shouldCheckForCollision()) {
            for (IStructureTileList iStructureTileList : te.structures()) {
                if (!LittleStructureAttribute.collisionListener(iStructureTileList.getAttribute())) continue;
                try {
                    iStructureTileList.getStructure().onEntityCollidedWithBlock(worldIn, iStructureTileList, pos, entityIn);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
            }
            for (Pair pair : te.allTiles()) {
                if (!((LittleTile)pair.value).shouldCheckForCollision()) continue;
                ((LittleTile)pair.value).onEntityCollidedWithBlock((IParentTileList)pair.key, entityIn);
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (this.rendered) {
            if (this.ticking) {
                return new TileEntityLittleTilesTickingRendered();
            }
            return new TileEntityLittleTilesRendered();
        }
        if (this.ticking) {
            return new TileEntityLittleTilesTicking();
        }
        return new TileEntityLittleTiles();
    }

    @SideOnly(value=Side.CLIENT)
    private static TileEntityLittleTiles checkforTileEntity(World world, EnumFacing facing, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing));
        if (tileEntity instanceof TileEntityLittleTiles) {
            return (TileEntityLittleTiles)tileEntity;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean checkforNeighbor(World world, EnumFacing facing, BlockPos pos) {
        BlockPos newPos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(newPos);
        return !state.doesSideBlockRendering((IBlockAccess)world, newPos, facing.func_176734_d());
    }

    @SideOnly(value=Side.CLIENT)
    private static void updateRenderer(TileEntityLittleTiles tileEntity, EnumFacing facing, HashMap<EnumFacing, Boolean> neighbors, HashMap<EnumFacing, TileEntityLittleTiles> neighborsTiles, RenderBox cube, LittleBoxFace face) {
        if (face == null) {
            cube.setType(facing, (IFaceRenderType)FaceRenderType.INSIDE_RENDERED);
            return;
        }
        Boolean shouldRender = neighbors.get(facing);
        if (shouldRender == null) {
            shouldRender = BlockTile.checkforNeighbor(tileEntity.func_145831_w(), facing, tileEntity.func_174877_v());
            neighbors.put(facing, shouldRender);
        }
        if (shouldRender.booleanValue()) {
            TileEntityLittleTiles otherTile = null;
            if (!neighborsTiles.containsKey(facing)) {
                otherTile = BlockTile.checkforTileEntity(tileEntity.func_145831_w(), facing, tileEntity.func_174877_v());
                neighborsTiles.put(facing, otherTile);
            } else {
                otherTile = neighborsTiles.get(facing);
            }
            if (otherTile != null) {
                face.move(facing);
                shouldRender = otherTile.shouldSideBeRendered(facing.func_176734_d(), face, (LittleTile)cube.customData);
            }
        }
        if (shouldRender.booleanValue()) {
            if (((LittleTile)cube.customData).isTranslucent() && face.isPartiallyFilled()) {
                cube.setType(facing, (IFaceRenderType)new CachedFaceRenderType(face.generateFans(), (float)face.context.pixelSize, true, true));
            } else {
                cube.setType(facing, (IFaceRenderType)FaceRenderType.OUTSIDE_RENDERED);
            }
        } else {
            cube.setType(facing, (IFaceRenderType)FaceRenderType.OUTSIDE_NOT_RENDERD);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<? extends RenderBox> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityLittleTiles) {
            return Collections.emptyList();
        }
        return BlockTile.getRenderingCubes(state, te, stack, MinecraftForgeClient.getRenderLayer());
    }

    @SideOnly(value=Side.CLIENT)
    public static List<LittleRenderBox> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack, BlockRenderLayer layer) {
        ArrayList<LittleRenderBox> cubes = new ArrayList<LittleRenderBox>();
        if (te instanceof TileEntityLittleTiles) {
            HashMap<EnumFacing, Boolean> neighbors = new HashMap<EnumFacing, Boolean>();
            HashMap<EnumFacing, TileEntityLittleTiles> neighborsTiles = new HashMap<EnumFacing, TileEntityLittleTiles>();
            TileEntityLittleTiles tileEntity = (TileEntityLittleTiles)te;
            LayeredRenderBoxCache cache = tileEntity.render.getBoxCache();
            List<LittleRenderBox> cachedCubes = cache.get(layer);
            if (cachedCubes != null) {
                if (tileEntity.render.hasNeighbourChanged) {
                    for (BlockRenderLayer tempLayer : BlockRenderLayer.values()) {
                        List<LittleRenderBox> renderCubes = cache.get(tempLayer);
                        if (renderCubes == null) continue;
                        for (int i = 0; i < renderCubes.size(); ++i) {
                            LittleRenderBox cube = renderCubes.get(i);
                            for (int k = 0; k < EnumFacing.field_82609_l.length; ++k) {
                                EnumFacing facing = EnumFacing.field_82609_l[k];
                                if (!cube.getType(facing).isOutside()) continue;
                                LittleBoxFace face = cube.box.generateFace(tileEntity.getContext(), facing);
                                boolean shouldRenderBefore = cube.renderSide(facing);
                                BlockTile.updateRenderer(tileEntity, facing, neighbors, neighborsTiles, cube, face);
                                if (cube.renderSide(facing)) {
                                    if (shouldRenderBefore) continue;
                                    cube.doesNeedQuadUpdate = true;
                                    continue;
                                }
                                cube.setQuad(facing, null);
                            }
                        }
                    }
                }
                tileEntity.render.hasNeighbourChanged = false;
                return cachedCubes;
            }
            for (Pair<IParentTileList, LittleTile> pair : tileEntity.allTiles()) {
                LittleRenderBox cube;
                LittleTile tile = (LittleTile)pair.value;
                if (!tile.shouldBeRenderedInLayer(layer) || (cube = ((IParentTileList)pair.key).getTileRenderingCube(tile, ((TileEntityLittleTiles)te).getContext(), layer)) == null) continue;
                for (int k = 0; k < EnumFacing.field_82609_l.length; ++k) {
                    EnumFacing facing = EnumFacing.field_82609_l[k];
                    LittleBoxFace face = cube.box.generateFace(tileEntity.getContext(), facing);
                    cube.customData = tile;
                    if (face == null) {
                        cube.setType(facing, (IFaceRenderType)FaceRenderType.INSIDE_RENDERED);
                        continue;
                    }
                    if (face.isFaceInsideBlock()) {
                        if (((TileEntityLittleTiles)te).shouldSideBeRendered(facing, face, tile)) {
                            if (tile.isTranslucent() && face.isPartiallyFilled()) {
                                cube.setType(facing, (IFaceRenderType)new CachedFaceRenderType(face.generateFans(), (float)face.context.pixelSize, true, false));
                                continue;
                            }
                            cube.setType(facing, (IFaceRenderType)FaceRenderType.INSIDE_RENDERED);
                            continue;
                        }
                        cube.setType(facing, (IFaceRenderType)FaceRenderType.INSIDE_NOT_RENDERED);
                        continue;
                    }
                    BlockTile.updateRenderer(tileEntity, facing, neighbors, neighborsTiles, cube, face);
                }
                cubes.add(cube);
            }
            for (LittleStructure structure : tileEntity.loadedStructures(512)) {
                try {
                    structure.load();
                    structure.getRenderingCubes(tileEntity.func_174877_v(), layer, cubes);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
            }
            cache.set(cubes, layer);
        } else if (stack != null) {
            return ItemBlockTiles.getItemRenderingCubes(stack);
        }
        return cubes;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        float calculatedResistance = 0.0f;
        float structureResistance = 0.0f;
        if (te != null) {
            for (IParentTileList list : te.groups()) {
                try {
                    if (list.isStructure() && list.getStructure().getExplosionResistance() > 0.0f) {
                        structureResistance = Math.max(structureResistance, list.getStructure().getExplosionResistance());
                        continue;
                    }
                    for (LittleTile tile : list) {
                        calculatedResistance = (float)((double)calculatedResistance + (double)tile.getExplosionResistance() * tile.getPercentVolume(te.getContext()));
                    }
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                }
            }
        }
        if (calculatedResistance > structureResistance) {
            return calculatedResistance;
        }
        return structureResistance;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            te.updateTiles(x -> {
                ParentTileList parent = x.noneStructureTiles();
                for (LittleTile tile : parent) {
                    tile.onTileExplodes(parent, explosion);
                }
                parent.clear();
                for (StructureTileList list : x.structures()) {
                    try {
                        list.getStructure().onLittleTileDestroy();
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                if (!((LittleTile)pair.value).getBox().getBox(te.getContext(), pos).func_72326_a(entity.func_174813_aQ())) continue;
                return ((LittleTile)pair.value).getFogColor((IParentTileList)pair.key, entity, originalColor, partialTicks);
            }
        }
        return super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
    }

    public Vec3d func_176197_a(World world, BlockPos pos, Entity entityIn, Vec3d motion) {
        AxisAlignedBB boundingBox = entityIn.func_174813_aQ();
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            Vec3d vec = Vec3d.field_186680_a;
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                Vec3d tileMotion;
                if (!((LittleTile)pair.value).getBox().getBox(te.getContext(), pos).func_72326_a(boundingBox) || (tileMotion = ((LittleTile)pair.value).modifyAcceleration((IParentTileList)pair.key, entityIn, motion)) == null) continue;
                vec = vec.func_178787_e(tileMotion);
            }
            return motion.func_178787_e(vec);
        }
        return motion;
    }

    @Nullable
    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        return this.isAABBInsideMaterial(entity.field_70170_p, blockpos, entity.func_174813_aQ(), materialIn);
    }

    @Nullable
    public Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB boundingBox, Material materialIn) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                if (!((LittleTile)pair.value).isMaterial(materialIn) || !((LittleTile)pair.value).getBox().getBox(te.getContext(), pos).func_72326_a(boundingBox)) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean isAABBInsideLiquid(World world, BlockPos pos, AxisAlignedBB boundingBox) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                if (!((LittleTile)pair.value).isLiquid() || !((LittleTile)pair.value).getBox().getBox(te.getContext(), pos).func_72326_a(boundingBox)) continue;
                return true;
            }
        }
        return false;
    }

    public float getBlockLiquidHeight(World world, BlockPos pos, IBlockState state, Material material) {
        float height = 0.0f;
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                if (!((LittleTile)pair.value).isMaterial(material)) continue;
                height = Math.max(height, (float)te.getContext().toVanillaGrid(((LittleTile)pair.value).getMaxY()));
            }
        }
        return height;
    }

    @Optional.Method(modid="ctm")
    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos);
    }

    @Optional.Method(modid="ctm")
    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side, BlockPos connection) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            IBlockState lookingFor = CTMManager.isInstalled() ? CTMManager.getCorrectStateOrigin(world, connection) : world.func_180495_p(connection);
            for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                if (((LittleTile)pair.value).getBlock() != lookingFor.func_177230_c() || ((LittleTile)pair.value).getMeta() != lookingFor.func_177230_c().func_176201_c(lookingFor)) continue;
                return lookingFor;
            }
        }
        return this.func_176223_P();
    }

    static {
        loadingTileEntityFromWorld = false;
    }

    public static class TEResult {
        public final TileEntityLittleTiles te;
        public final IParentTileList parent;
        public final LittleTile tile;

        public TEResult(TileEntityLittleTiles te, IParentTileList parent, LittleTile tile) {
            this.te = te;
            this.parent = parent;
            this.tile = tile;
        }

        public boolean isComplete() {
            return this.te != null && this.tile != null;
        }
    }
}

