/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.config;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import com.creativemd.creativecore.common.config.converation.ConfigTypeConveration;

public class LittleBuildingConfig {
    @CreativeConfig
    public boolean limitAffectedBlocks;
    @CreativeConfig
    public int maxAffectedBlocks = 2;
    @CreativeConfig
    public int harvestLevelBlock;
    @CreativeConfig
    public boolean editUnbreakable;
    @CreativeConfig
    @CreativeConfig.IntRange(min=0, max=255)
    public int minimumTransparency;
    @CreativeConfig
    public boolean limitEditBlocks;
    @CreativeConfig
    public int maxEditBlocks = 10;
    @CreativeConfig
    public boolean limitPlaceBlocks;
    @CreativeConfig
    public int maxPlaceBlocks = 10;

    public LittleBuildingConfig() {
        this.limitAffectedBlocks = true;
        this.editUnbreakable = false;
        this.minimumTransparency = 0;
        this.limitEditBlocks = true;
        this.limitPlaceBlocks = true;
        this.harvestLevelBlock = 0;
        this.maxAffectedBlocks = 0;
        this.maxEditBlocks = 0;
        this.maxPlaceBlocks = 0;
    }

    public LittleBuildingConfig(boolean survival) {
        this.limitAffectedBlocks = survival;
        this.editUnbreakable = !survival;
        this.minimumTransparency = survival ? 255 : 0;
        this.limitEditBlocks = survival;
        this.limitPlaceBlocks = survival;
        this.harvestLevelBlock = survival ? 1 : 4;
    }

    static {
        ConfigTypeConveration.registerTypeCreator(LittleBuildingConfig.class, () -> new LittleBuildingConfig());
    }
}

