/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.gui.opener.IGuiCreator;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.SubGuiBag;
import com.creativemd.littletiles.common.api.ILittleIngredientInventory;
import com.creativemd.littletiles.common.container.SubContainerBag;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredient;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import com.creativemd.littletiles.common.util.ingredient.ColorIngredient;
import com.creativemd.littletiles.common.util.ingredient.IngredientUtils;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLittleBag
extends Item
implements IGuiCreator,
ILittleIngredientInventory {
    public static int colorUnitMaximum = 10000000;
    public static int inventoryWidth = 6;
    public static int inventoryHeight = 4;
    public static int inventorySize = inventoryWidth * inventoryHeight;
    public static int maxStackSize = 64;
    public static int maxStackSizeOfTiles;

    public ItemLittleBag() {
        this.func_77637_a(LittleTiles.littleTab);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    @SideOnly(value=Side.CLIENT)
    public SubGui getGui(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubGuiBag(stack);
    }

    public SubContainer getContainer(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubContainerBag(player, stack, player.field_71071_by.field_70461_c);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            GuiHandler.openGuiItem((EntityPlayer)player, (World)world);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public LittleIngredients getInventory(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        LittleIngredients ingredients = new LittleIngredients(){

            @Override
            protected boolean canAddNewIngredients() {
                return false;
            }
        };
        BlockIngredient blocks = new BlockIngredient().setLimits(inventorySize, maxStackSize);
        NBTTagList list = stack.func_77978_p().func_150295_c("inv", 10);
        int size = Math.min(inventorySize, list.func_74745_c());
        for (int i = 0; i < size; ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            BlockIngredientEntry ingredient = IngredientUtils.loadBlockIngredient(nbt);
            if (ingredient == null || !(ingredient.value >= LittleGridContext.getMax().pixelVolume)) continue;
            blocks.add(ingredient);
        }
        ingredients.set(blocks.getClass(), blocks);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        ColorIngredient color = new ColorIngredient(stack.func_77978_p().func_74762_e("black"), stack.func_77978_p().func_74762_e("cyan"), stack.func_77978_p().func_74762_e("magenta"), stack.func_77978_p().func_74762_e("yellow"));
        color.setLimit(colorUnitMaximum);
        ingredients.set(color.getClass(), color);
        return ingredients;
    }

    @Override
    public void setInventory(ItemStack stack, LittleIngredients ingredients, LittleInventory inventory) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = new NBTTagList();
        int i = 0;
        for (BlockIngredientEntry ingredient : ingredients.get(BlockIngredient.class).getContent()) {
            if (ingredient.block instanceof BlockAir && ingredient.value < LittleGridContext.getMax().pixelVolume) continue;
            if (i >= inventorySize) break;
            list.func_74742_a((NBTBase)ingredient.writeToNBT(new NBTTagCompound()));
            ++i;
        }
        stack.func_77978_p().func_74782_a("inv", (NBTBase)list);
        ColorIngredient color = ingredients.get(ColorIngredient.class);
        stack.func_77978_p().func_74768_a("black", color.black);
        stack.func_77978_p().func_74768_a("cyan", color.cyan);
        stack.func_77978_p().func_74768_a("magenta", color.magenta);
        stack.func_77978_p().func_74768_a("yellow", color.yellow);
    }
}

