/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.tooltip.TooltipUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.gui.SubGuiChisel;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.gui.configure.SubGuiModeSelector;
import com.creativemd.littletiles.client.render.overlay.PreviewRenderer;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittlePlacer;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.item.ItemLittleGrabber;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.packet.LittleBlockPacket;
import com.creativemd.littletiles.common.packet.LittleVanillaBlockPacket;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.IMarkMode;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeRegistry;
import com.creativemd.littletiles.common.util.shape.ShapeSelection;
import com.creativemd.littletiles.common.util.tooltip.IItemTooltip;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Color;

public class ItemLittleChisel
extends Item
implements ICreativeRendered,
ILittlePlacer,
IItemTooltip {
    public static ShapeSelection selection;
    @SideOnly(value=Side.CLIENT)
    public static IBakedModel model;
    public static PlacementMode currentMode;

    public ItemLittleChisel() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LittleShape shape = ItemLittleChisel.getShape(stack);
        tooltip.add("shape: " + shape.getKey());
        shape.addExtraInformation(stack.func_77978_p(), tooltip);
        LittlePreview preview = ItemLittleGrabber.SimpleMode.getPreview(stack);
        tooltip.add(TooltipUtils.printRGB((int)(preview.hasColor() ? preview.getColor() : -1)));
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public static LittleShape getShape(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return ShapeRegistry.getShape(stack.func_77978_p().func_74779_i("shape"));
    }

    public static void setShape(ItemStack stack, LittleShape shape) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("shape", shape.getKey());
    }

    public static LittlePreview getPreview(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b("preview")) {
            return LittleTileRegistry.loadPreview(stack.func_77978_p().func_74775_l("preview"));
        }
        IBlockState state = stack.func_77978_p().func_74764_b("state") ? Block.func_176220_d((int)stack.func_77978_p().func_74762_e("state")) : Blocks.field_150348_b.func_176223_P();
        LittleTile tile = stack.func_77978_p().func_74764_b("color") ? new LittleTileColored(state.func_177230_c(), state.func_177230_c().func_176201_c(state), stack.func_77978_p().func_74762_e("color")) : new LittleTile(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
        LittleGridContext context = LittleGridContext.get();
        tile.setBox(new LittleBox(0, 0, 0, context.size, context.size, context.size));
        LittlePreview preview = tile.getPreviewTile();
        ItemLittleChisel.setPreview(stack, preview);
        return preview;
    }

    public static void setPreview(ItemStack stack, LittlePreview preview) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        preview.writeToNBT(nbt);
        stack.func_77978_p().func_74782_a("preview", (NBTBase)nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public List<RenderBox> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        return Collections.emptyList();
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCustomOpenGLHackery(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        if (model == null) {
            model = mc.func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("littletiles:chisel_background", "inventory"));
        }
        ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND ? 1 : 0) != 0);
        mc.func_175599_af().func_180454_a(new ItemStack(Items.field_151121_aF), model);
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
            GlStateManager.func_179137_b((double)0.1, (double)0.1, (double)0.0);
            GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
            LittlePreview preview = ItemLittleChisel.getPreview(stack);
            ItemStack blockStack = new ItemStack(preview.getBlock(), 1, preview.getMeta());
            IBakedModel model = mc.func_175599_af().func_184393_a(blockStack, (World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g);
            if (!(model instanceof CreativeBakedModel)) {
                ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            try {
                if (model.func_188618_c()) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179091_B();
                    TileEntityItemStackRenderer.field_147719_a.func_179022_a(blockStack);
                } else {
                    Color color = preview.hasColor() ? ColorUtils.IntToRGBA((int)preview.getColor()) : ColorUtils.IntToRGBA((int)-1);
                    color.setAlpha(255);
                    ReflectionHelper.findMethod(RenderItem.class, (String)"renderModel", (String)"func_191967_a", (Class[])new Class[]{IBakedModel.class, Integer.TYPE, ItemStack.class}).invoke((Object)mc.func_175599_af(), model, preview.hasColor() ? ColorUtils.RGBAToInt((Color)color) : -1, blockStack);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public LittleAbsolutePreviews getLittlePreview(ItemStack stack) {
        return null;
    }

    @Override
    public LittleAbsolutePreviews getLittlePreview(ItemStack stack, boolean allowLowResolution) {
        if (selection != null) {
            LittleBoxes boxes = selection.getBoxes(allowLowResolution);
            LittleAbsolutePreviews previews = new LittleAbsolutePreviews(boxes.pos, boxes.context);
            LittlePreview preview = ItemLittleChisel.getPreview(stack);
            for (LittleBox box : boxes.all()) {
                LittlePreview newPreview = preview.copy();
                newPreview.box = box.copy();
                previews.addWithoutCheckingPreview(newPreview);
            }
            return previews;
        }
        return null;
    }

    @Override
    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
    }

    @Override
    public void rotate(EntityPlayer player, ItemStack stack, Rotation rotation, boolean client) {
        if (client && selection != null) {
            selection.rotate(player, stack, rotation);
        } else {
            new ShapeSelection(stack, false).rotate(player, stack, rotation);
        }
    }

    @Override
    public void flip(EntityPlayer player, ItemStack stack, EnumFacing.Axis axis, boolean client) {
        if (client && selection != null) {
            selection.flip(player, stack, axis);
        } else {
            new ShapeSelection(stack, false).flip(player, stack, axis);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getPreviewAlphaFactor() {
        return 0.4f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tick(EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        if (selection == null) {
            selection = new ShapeSelection(stack, false);
        }
        selection.setLast(player, stack, ItemLittleChisel.getPosition(position, result, currentMode), result);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldCache() {
        return false;
    }

    @Override
    public void onDeselect(World world, ItemStack stack, EntityPlayer player) {
        selection = null;
    }

    protected static PlacementPosition getPosition(PlacementPosition position, RayTraceResult result, PlacementMode mode) {
        position = position.copy();
        EnumFacing facing = position.facing;
        if (mode.placeInside) {
            facing = facing.func_176734_d();
        }
        if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            position.getVec().add(facing);
        }
        return position;
    }

    @Override
    public void onClickAir(EntityPlayer player, ItemStack stack) {
        if (selection != null) {
            selection.click(player);
        }
    }

    @Override
    public boolean onClickBlock(World world, EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        if (selection != null) {
            selection.click(player);
        }
        return false;
    }

    @Override
    public boolean onRightClick(World world, EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        if (LittleAction.isUsingSecondMode(player)) {
            selection = null;
            PreviewRenderer.marked = null;
        } else if (selection != null) {
            return selection.addAndCheckIfPlace(player, ItemLittleChisel.getPosition(position, result, currentMode), result);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onMouseWheelClickBlock(World world, EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        IBlockState state = world.func_180495_p(result.func_178782_a());
        if (LittleAction.isBlockValid(state)) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleVanillaBlockPacket(result.func_178782_a(), LittleVanillaBlockPacket.VanillaBlockAction.CHISEL));
            return true;
        }
        if (state.func_177230_c() instanceof BlockTile) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(world, result.func_178782_a(), player, LittleBlockPacket.BlockPacketAction.CHISEL, new NBTTagCompound()));
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        return new SubGuiChisel(stack);
    }

    @Override
    public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        return currentMode;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiModeSelector(stack, ItemMultiTiles.currentContext, currentMode){

            @Override
            public void saveConfiguration(LittleGridContext context, PlacementMode mode) {
                currentMode = mode;
                if (selection != null) {
                    selection.convertTo(context);
                }
                ItemMultiTiles.currentContext = context;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMarkMode onMark(EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result, PlacementPreview previews) {
        if (selection != null) {
            selection.toggleMark();
        }
        return selection;
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return false;
    }

    @Override
    public LittleGridContext getPositionContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{ItemLittleChisel.getShape(stack).getLocalizedName(), Minecraft.func_71410_x().field_71474_y.field_74322_I.getDisplayName(), LittleTilesClient.mark.getDisplayName(), LittleTilesClient.configure.getDisplayName(), LittleTilesClient.configureAdvanced.getDisplayName()};
    }

    static {
        currentMode = PlacementMode.fill;
    }
}

