/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleEntityFixControllerPacket;
import com.creativemd.littletiles.common.packet.LittleEntityRequestPacket;
import com.creativemd.littletiles.common.packet.LittleResetAnimationPacket;
import com.creativemd.littletiles.common.packet.LittleUpdateStructurePacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleActivateDoorPacket
extends CreativeCorePacket {
    public StructureLocation location;
    public LittleDoor.DoorActivator activator;
    public UUID uuid;

    public LittleActivateDoorPacket(LittleDoor.DoorActivator activator, StructureLocation location, UUID uuid) {
        this.location = location;
        this.activator = activator;
        this.uuid = uuid;
    }

    public LittleActivateDoorPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeStructureLocation(this.location, buf);
        LittleActivateDoorPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        buf.writeInt(this.activator.ordinal());
    }

    public void readBytes(ByteBuf buf) {
        this.location = LittleAction.readStructureLocation(buf);
        this.uuid = UUID.fromString(LittleActivateDoorPacket.readString((ByteBuf)buf));
        this.activator = LittleDoor.DoorActivator.values()[buf.readInt()];
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
        try {
            LittleStructure structure = this.location.find(player.field_70170_p);
            if (structure instanceof LittleDoor) {
                LittleDoor door = (LittleDoor)structure;
                door.activate(this.activator, null, this.uuid, false);
            }
        }
        catch (LittleDoor.StillInMotionException e) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleEntityFixControllerPacket(this.uuid, new NBTTagCompound()));
        }
        catch (LittleActionException e) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleUpdateStructurePacket(this.location, new NBTTagCompound()));
        }
    }

    public void executeServer(EntityPlayer player) {
        EntityAnimation animation = null;
        try {
            LittleStructure structure = this.location.find(player.field_70170_p);
            if (structure instanceof LittleDoor) {
                LittleDoor door = (LittleDoor)structure;
                World world = door.getWorld();
                if (world instanceof SubWorld) {
                    animation = (EntityAnimation)((SubWorld)world).parent;
                }
                door.activate(this.activator, player, this.uuid, true);
            }
        }
        catch (LittleActionException e) {
            if (animation != null) {
                PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(animation.func_110124_au(), animation.func_189511_e(new NBTTagCompound()), false), (EntityPlayerMP)((EntityPlayerMP)player));
            }
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleResetAnimationPacket(this.uuid), (EntityPlayerMP)((EntityPlayerMP)player));
        }
    }
}

