/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.item.ItemLittleChisel;
import com.creativemd.littletiles.common.item.ItemLittleGrabber;
import com.creativemd.littletiles.common.item.ItemLittlePaintBrush;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleBlockPacket
extends CreativeCorePacket {
    public BlockPos blockPos;
    public Vec3d pos;
    public Vec3d look;
    public BlockPacketAction action;
    public World world;
    public NBTTagCompound nbt;
    public UUID uuid;

    public LittleBlockPacket() {
    }

    public LittleBlockPacket(World world, BlockPos blockPos, EntityPlayer player, BlockPacketAction action) {
        this(world, blockPos, player, action, new NBTTagCompound());
    }

    public LittleBlockPacket(World world, BlockPos blockPos, EntityPlayer player, BlockPacketAction action, NBTTagCompound nbt) {
        this.blockPos = blockPos;
        this.action = action;
        this.pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        this.look = this.pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        this.nbt = nbt;
        if (world instanceof CreativeWorld) {
            this.uuid = ((CreativeWorld)world).parent.func_110124_au();
        }
    }

    public void writeBytes(ByteBuf buf) {
        LittleBlockPacket.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        LittleBlockPacket.writeVec3d((Vec3d)this.pos, (ByteBuf)buf);
        LittleBlockPacket.writeVec3d((Vec3d)this.look, (ByteBuf)buf);
        buf.writeInt(this.action.ordinal());
        LittleBlockPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
        if (this.uuid != null) {
            buf.writeBoolean(true);
            LittleBlockPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readBytes(ByteBuf buf) {
        this.blockPos = LittleBlockPacket.readPos((ByteBuf)buf);
        this.pos = LittleBlockPacket.readVec3d((ByteBuf)buf);
        this.look = LittleBlockPacket.readVec3d((ByteBuf)buf);
        this.action = BlockPacketAction.values()[buf.readInt()];
        this.nbt = LittleBlockPacket.readNBT((ByteBuf)buf);
        this.uuid = buf.readBoolean() ? UUID.fromString(LittleBlockPacket.readString((ByteBuf)buf)) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        TileEntity tileEntity;
        World world = player.field_70170_p;
        if (this.uuid != null) {
            EntityAnimation animation = WorldAnimationHandler.findAnimation(false, this.uuid);
            if (animation == null) {
                return;
            }
            if (!LittleAction.isAllowedToInteract(player, animation, this.action.rightClick)) {
                LittleAction.sendEntityResetToClient(player, animation);
                return;
            }
            world = animation.fakeWorld;
            this.pos = animation.origin.transformPointToFakeWorld(this.pos);
            this.look = animation.origin.transformPointToFakeWorld(this.look);
        }
        if ((tileEntity = world.func_175625_s(this.blockPos)) instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
            Pair<IParentTileList, LittleTile> pair = te.getFocusedTile(this.pos, this.look);
            if (!LittleAction.isAllowedToInteract(world, player, this.blockPos, this.action.rightClick, EnumFacing.EAST)) {
                LittleAction.sendBlockResetToClient(world, player, (TileEntity)te);
                return;
            }
            if (pair != null) {
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                RayTraceResult moving = te.rayTrace(this.pos, this.look);
                this.action.action(world, te, (IParentTileList)pair.key, (LittleTile)pair.value, stack, player, moving, this.blockPos, this.nbt);
                if (!player.field_70170_p.field_72995_K) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
                    playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
                }
            }
        }
    }

    public static enum BlockPacketAction {
        COLOR_TUBE(true){

            @Override
            public void action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                if (parent.isStructure()) {
                    try {
                        LittleStructure structure = parent.getStructure();
                        if (structure.hasStructureColor()) {
                            ItemLittlePaintBrush.setColor(player.func_184614_ca(), structure.getStructureColor());
                            return;
                        }
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structure) {
                        // empty catch block
                    }
                }
                if (tile.getClass() == LittleTile.class || tile instanceof LittleTileColored) {
                    int color = -1;
                    if (tile instanceof LittleTileColored) {
                        color = ((LittleTileColored)tile).color;
                    }
                    ItemLittlePaintBrush.setColor(player.func_184614_ca(), color);
                }
            }
        }
        ,
        CHISEL(false){

            @Override
            public void action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                LittlePreview preview = tile.getPreviewTile();
                preview.box = new LittleBox(0, 0, 0, LittleGridContext.get().size, LittleGridContext.get().size, LittleGridContext.get().size);
                ItemLittleChisel.setPreview(stack, preview);
            }
        }
        ,
        GRABBER(false){

            @Override
            public void action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                ItemLittleGrabber.getMode(stack).littleBlockAction(world, te, tile, stack, pos, nbt);
            }
        }
        ,
        WRENCH(true){

            @Override
            public void action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                player.func_146105_b((ITextComponent)new TextComponentString("grid:" + te.getContext()), true);
                te.combineTiles();
                te.convertBlockToVanilla();
                te.updateTiles();
            }
        }
        ,
        WRENCH_INFO(true){

            @Override
            public void action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                if (parent.isStructure()) {
                    try {
                        String info = parent.getStructure().info();
                        if (!info.isEmpty()) {
                            player.func_145747_a((ITextComponent)new TextComponentString(info));
                        }
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
            }
        }
        ,
        RECIPE(false){

            @Override
            public void action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, NBTTagCompound nbt) {
                LittlePreviews previews = new LittlePreviews(te.getContext());
                if (parent.isStructure()) {
                    if (nbt.func_74767_n("secondMode")) {
                        try {
                            previews = parent.getStructure().getPreviews(parent.getStructure().getPos());
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            return;
                        }
                    } else {
                        try {
                            previews = parent.getStructure().findTopStructure().getPreviews(parent.getStructure().getPos());
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            return;
                        }
                    }
                } else if (nbt.func_74767_n("secondMode")) {
                    for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                        previews.addWithoutCheckingPreview(((LittleTile)pair.value).getPreviewTile());
                    }
                } else {
                    previews.addWithoutCheckingPreview(tile.getPreviewTile());
                }
                LittlePreview.savePreview(previews, stack);
            }
        };

        public final boolean rightClick;

        private BlockPacketAction(boolean rightClick) {
            this.rightClick = rightClick;
        }

        public abstract void action(World var1, TileEntityLittleTiles var2, IParentTileList var3, LittleTile var4, ItemStack var5, EntityPlayer var6, RayTraceResult var7, BlockPos var8, NBTTagCompound var9);
    }
}

