/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.connection;

import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.connection.IWorldPositionProvider;
import com.creativemd.littletiles.common.structure.connection.StructureChildConnection;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.MissingAnimationException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureChildToSubWorldConnection
extends StructureChildConnection {
    public final UUID entityUUID;

    public StructureChildToSubWorldConnection(IWorldPositionProvider parent, boolean dynamic, int childId, BlockPos relative, int index, int attribute, UUID entityUUID) {
        super(parent, false, dynamic, childId, relative, index, attribute);
        this.entityUUID = entityUUID;
    }

    public StructureChildToSubWorldConnection(IWorldPositionProvider parent, NBTTagCompound nbt) {
        super(parent, false, nbt);
        this.entityUUID = UUID.fromString(nbt.func_74779_i("entity"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74778_a("entity", this.entityUUID.toString());
        return nbt;
    }

    @Override
    protected World getWorld() throws CorruptedConnectionException, NotYetConnectedException {
        EntityAnimation animation = WorldAnimationHandler.getHandler(super.getWorld()).findAnimation(this.entityUUID);
        if (animation != null) {
            return animation.fakeWorld;
        }
        throw new MissingAnimationException(this.entityUUID);
    }

    @Override
    public EntityAnimation getAnimation() {
        return null;
    }

    @Override
    public void destroyStructure() throws CorruptedConnectionException, NotYetConnectedException {
        this.getStructure().onStructureDestroyed();
        EntityAnimation animation = WorldAnimationHandler.getHandler(super.getWorld()).findAnimation(this.entityUUID);
        if (animation != null) {
            animation.markRemoved();
        }
        for (StructureChildConnection child : this.getStructure().getChildren()) {
            child.destroyStructure();
        }
    }

    @Override
    public boolean isLinkToAnotherWorld() {
        return true;
    }
}

