/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.logic;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalPatternParser;
import java.text.ParseException;

public enum SignalLogicOperator {
    AND('\n', false, "and", ""){

        @Override
        public SignalLogicOperator lower() {
            return null;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first && second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackable(conditions){

                @Override
                public boolean perform(boolean first, boolean second) {
                    return first && second;
                }

                @Override
                public SignalLogicOperator operator() {
                    return AND;
                }

                @Override
                public boolean needsBrackets() {
                    return false;
                }

                @Override
                public float getModifier() {
                    return 0.1f;
                }
            };
        }
    }
    ,
    OR('+', false, "or"){

        @Override
        public SignalLogicOperator lower() {
            return AND;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first || second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackable(conditions){

                @Override
                public boolean perform(boolean first, boolean second) {
                    return first || second;
                }

                @Override
                public SignalLogicOperator operator() {
                    return OR;
                }

                @Override
                public boolean needsBrackets() {
                    return true;
                }

                @Override
                public float getModifier() {
                    return 0.01f;
                }
            };
        }
    }
    ,
    XOR('V', false, "xor"){

        @Override
        public SignalLogicOperator lower() {
            return OR;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first ^ second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackable(conditions){

                @Override
                public boolean perform(boolean first, boolean second) {
                    return first ^ second;
                }

                @Override
                public SignalLogicOperator operator() {
                    return XOR;
                }

                @Override
                public boolean needsBrackets() {
                    return true;
                }

                @Override
                public float getModifier() {
                    return 0.2f;
                }
            };
        }
    }
    ,
    BITWISE_AND('&', true, "b-and"){

        @Override
        public SignalLogicOperator lower() {
            return XOR;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first && second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableBitwise(conditions){

                @Override
                public boolean perform(boolean first, boolean second) {
                    return first && second;
                }

                @Override
                public SignalLogicOperator operator() {
                    return BITWISE_AND;
                }

                @Override
                public float getModifier() {
                    return 0.2f;
                }
            };
        }
    }
    ,
    BITWISE_OR('|', true, "b-or"){

        @Override
        public SignalLogicOperator lower() {
            return BITWISE_AND;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first || second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableBitwise(conditions){

                @Override
                public boolean perform(boolean first, boolean second) {
                    return first || second;
                }

                @Override
                public SignalLogicOperator operator() {
                    return BITWISE_OR;
                }

                @Override
                public float getModifier() {
                    return 0.02f;
                }
            };
        }
    }
    ,
    BITWISE_XOR('^', true, "b-xor"){

        @Override
        public SignalLogicOperator lower() {
            return BITWISE_OR;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first ^ second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableBitwise(conditions){

                @Override
                public boolean perform(boolean first, boolean second) {
                    return first ^ second;
                }

                @Override
                public SignalLogicOperator operator() {
                    return BITWISE_XOR;
                }

                @Override
                public float getModifier() {
                    return 0.4f;
                }
            };
        }
    }
    ,
    ADD('#', true, "add"){

        @Override
        public SignalLogicOperator lower() {
            return BITWISE_XOR;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return false;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableMath(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return ADD;
                }

                @Override
                public float getModifier() {
                    return 0.5f;
                }

                @Override
                public int perform(int first, int second) {
                    return first + second;
                }
            };
        }
    }
    ,
    SUB('-', true, "sub"){

        @Override
        public SignalLogicOperator lower() {
            return ADD;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return false;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableMath(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return SUB;
                }

                @Override
                public float getModifier() {
                    return 0.5f;
                }

                @Override
                public int perform(int first, int second) {
                    return first - second;
                }
            };
        }
    }
    ,
    MUL('*', true, "mul"){

        @Override
        public SignalLogicOperator lower() {
            return SUB;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return false;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableMath(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return MUL;
                }

                @Override
                public float getModifier() {
                    return 0.5f;
                }

                @Override
                public int perform(int first, int second) {
                    return first * second;
                }
            };
        }
    }
    ,
    DIV('/', true, "div"){

        @Override
        public SignalLogicOperator lower() {
            return MUL;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return false;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableMath(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return DIV;
                }

                @Override
                public float getModifier() {
                    return 5.0f;
                }

                @Override
                public int perform(int first, int second) {
                    return first / second;
                }
            };
        }
    };

    public static final SignalLogicOperator HIGHEST_GENERAL;
    public static final SignalLogicOperator HIGHEST;
    public final char operator;
    public final boolean bitwise;
    public final String display;
    public final String seperator;

    public static SignalLogicOperator getHighest(boolean includeBitwise) {
        if (includeBitwise) {
            return HIGHEST;
        }
        return HIGHEST_GENERAL;
    }

    public static SignalLogicOperator getOperator(char character) {
        switch (character) {
            case '&': {
                return BITWISE_AND;
            }
            case '+': {
                return OR;
            }
            case '|': {
                return BITWISE_OR;
            }
            case 'V': {
                return XOR;
            }
            case '^': {
                return BITWISE_XOR;
            }
            case '#': {
                return ADD;
            }
            case '-': {
                return SUB;
            }
            case '*': {
                return MUL;
            }
            case '/': {
                return DIV;
            }
        }
        return null;
    }

    private SignalLogicOperator(char operator, boolean bitwise, String display) {
        this(operator, bitwise, display, "" + operator);
    }

    private SignalLogicOperator(char operator, boolean bitwise, String display, String seperator) {
        this.operator = operator;
        this.bitwise = bitwise;
        this.display = display;
        this.seperator = seperator;
    }

    public abstract SignalLogicOperator lower();

    public boolean goOn(SignalPatternParser parser) throws ParseException {
        if (parser.hasNext()) {
            if (this == AND) {
                char next = parser.lookForNext(true);
                return next == '(' || next == '!' || next <= 'z' & next >= 'a';
            }
            if (parser.lookForNext(true) == this.operator) {
                parser.next(true);
                return true;
            }
        }
        return false;
    }

    public abstract boolean perform(boolean var1, boolean var2);

    public abstract SignalInputCondition create(SignalInputCondition[] var1);

    static {
        HIGHEST_GENERAL = XOR;
        HIGHEST = DIV;
    }

    public static abstract class SignalInputConditionOperatorStackableMath
    extends SignalInputConditionOperatorStackable {
        public SignalInputConditionOperatorStackableMath(SignalInputCondition[] conditions) {
            super(conditions);
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return false;
        }

        public abstract int perform(int var1, int var2);

        @Override
        public boolean[] test(LittleStructure structure) {
            boolean[][] state = new boolean[this.conditions.length][];
            int size = 0;
            for (int i = 0; i < this.conditions.length; ++i) {
                state[i] = this.conditions[i].test(structure, true);
                size = Math.max(size, state[i].length);
            }
            int result = 0;
            for (int i = 0; i < state.length; ++i) {
                result = i == 0 ? BooleanUtils.toNumber((boolean[])state[i]) : this.perform(result, BooleanUtils.toNumber((boolean[])state[i]));
            }
            return BooleanUtils.toBits((int)result, (int)Math.max(size, BooleanUtils.getRequiredBandwidth((int)result)));
        }

        @Override
        public boolean needsBrackets() {
            return true;
        }
    }

    public static abstract class SignalInputConditionOperatorStackableBitwise
    extends SignalInputConditionOperatorStackable {
        public SignalInputConditionOperatorStackableBitwise(SignalInputCondition[] conditions) {
            super(conditions);
        }

        @Override
        public boolean[] test(LittleStructure structure) {
            boolean[][] state = new boolean[this.conditions.length][];
            int size = 0;
            for (int i = 0; i < this.conditions.length; ++i) {
                state[i] = this.conditions[i].test(structure, true);
                size = Math.max(size, state[i].length);
            }
            boolean[] result = new boolean[size];
            for (int i = 0; i < state.length; ++i) {
                for (int j = 0; j < result.length; ++j) {
                    boolean value = state[i].length > j ? state[i][j] : false;
                    result[j] = i == 0 ? value : this.perform(result[j], value);
                }
            }
            return result;
        }

        @Override
        public boolean needsBrackets() {
            return true;
        }
    }

    public static abstract class SignalInputConditionOperatorStackable
    extends SignalInputCondition.SignalInputConditionOperator {
        public SignalInputCondition[] conditions;

        public SignalInputConditionOperatorStackable(SignalInputCondition[] conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean[] test(LittleStructure structure) {
            boolean[][] state = new boolean[this.conditions.length][];
            int size = 0;
            for (int i = 0; i < this.conditions.length; ++i) {
                state[i] = this.conditions[i].test(structure, false);
                size = Math.max(size, state[i].length);
            }
            boolean[] result = new boolean[size];
            for (int i = 0; i < state.length; ++i) {
                for (int j = 0; j < result.length; ++j) {
                    boolean value = state[i].length > j ? state[i][j] : (state[i].length == 1 ? state[i][0] : false);
                    result[j] = i == 0 ? value : this.perform(result[j], value);
                }
            }
            return result;
        }

        @Override
        public boolean testIndex(boolean[] state) {
            boolean result = false;
            for (int i = 0; i < this.conditions.length; ++i) {
                result = i == 0 ? this.conditions[i].testIndex(state) : this.perform(result, this.conditions[i].testIndex(state));
            }
            return result;
        }

        public abstract boolean perform(boolean var1, boolean var2);

        public abstract boolean needsBrackets();

        public abstract SignalLogicOperator operator();

        @Override
        public String write() {
            if (this.needsBrackets()) {
                String result = "(";
                for (int i = 0; i < this.conditions.length; ++i) {
                    if (i > 0) {
                        result = result + this.operator().seperator;
                    }
                    result = result + this.conditions[i].write();
                }
                return result + ")";
            }
            String result = "";
            for (int i = 0; i < this.conditions.length; ++i) {
                if (i > 0) {
                    result = result + this.operator().seperator;
                }
                result = result + this.conditions[i].write();
            }
            return result;
        }

        @Override
        public float calculateDelay() {
            float delay = (float)this.conditions.length * this.getModifier();
            for (SignalInputCondition condition : this.conditions) {
                delay += condition.calculateDelay();
            }
            return delay;
        }

        public abstract float getModifier();
    }
}

