/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.schedule;

import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.output.SignalOutputHandler;
import com.creativemd.littletiles.common.structure.signal.schedule.ISignalSchedulable;
import com.creativemd.littletiles.common.structure.signal.schedule.ISignalScheduleTicket;
import com.creativemd.littletiles.common.structure.signal.schedule.SignalScheduleTicket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SignalTicker {
    private static HashMap<World, SignalTicker> tickers = new HashMap();
    private static List<SignalScheduleTicket> unsortedTickets = new ArrayList<SignalScheduleTicket>();
    public static final int queueLength = 20;
    public final World world;
    private int queueIndex;
    private List<ISignalSchedulable> scheduled = new ArrayList<ISignalSchedulable>();
    private List<SignalScheduleTicket>[] queue;
    private List<SignalScheduleTicket> longQueue = new ArrayList<SignalScheduleTicket>();

    public static synchronized void serverTick() {
        if (unsortedTickets.isEmpty()) {
            return;
        }
        Iterator<SignalScheduleTicket> iterator = unsortedTickets.iterator();
        while (iterator.hasNext()) {
            SignalScheduleTicket ticket = iterator.next();
            World world = ticket.getWorld();
            if (world == null) continue;
            SignalTicker.get(world).openTicket(ticket);
            iterator.remove();
        }
    }

    public static synchronized List<ISignalScheduleTicket> findTickets(ISignalComponent component, SignalOutputHandler condition) {
        World world = component.getStructureWorld();
        if (world != null && !world.field_72995_K) {
            return SignalTicker.get(world).findTickets(condition);
        }
        return Collections.EMPTY_LIST;
    }

    public static synchronized SignalTicker get(ISignalComponent component) {
        return SignalTicker.get(component.getStructureWorld());
    }

    public static synchronized SignalTicker get(World world) {
        SignalTicker ticker;
        if (world.field_72995_K) {
            throw new RuntimeException("Client should never ask for a signal ticker");
        }
        if (world instanceof IOrientatedWorld) {
            world = ((IOrientatedWorld)world).getRealWorld();
        }
        if ((ticker = tickers.get(world)) == null) {
            ticker = new SignalTicker(world);
            tickers.put(world, ticker);
        }
        return ticker;
    }

    public static void schedule(World world, ISignalSchedulable schedulable) {
        if (world == null) {
            return;
        }
        SignalTicker.get(world).schedule(schedulable);
    }

    public static ISignalScheduleTicket schedule(SignalOutputHandler handler, boolean[] result, int tick) {
        World world = handler.component.getStructureWorld();
        if (world == null) {
            SignalScheduleTicket ticket = new SignalScheduleTicket(handler, result, tick);
            unsortedTickets.add(ticket);
            return ticket;
        }
        return SignalTicker.get(handler.component).openTicket(handler, result, tick);
    }

    private static synchronized void unload(SignalTicker ticker) {
        MinecraftForge.EVENT_BUS.unregister((Object)ticker);
        tickers.remove(ticker.world);
    }

    protected SignalTicker(World world) {
        this.world = world;
        this.queue = new List[20];
        for (int i = 0; i < this.queue.length; ++i) {
            this.queue[i] = new ArrayList<SignalScheduleTicket>();
        }
        this.queueIndex = 0;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public synchronized void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.world == event.world) {
            for (int i = 0; i < this.scheduled.size(); ++i) {
                try {
                    this.scheduled.get(i).updateSignaling();
                    continue;
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            this.scheduled.clear();
            List<SignalScheduleTicket> tickets = this.queue[this.queueIndex];
            for (int i = 0; i < tickets.size(); ++i) {
                tickets.get(i).run();
            }
            tickets.clear();
            this.longQueue.removeIf(x -> {
                if (x.tick() <= 20) {
                    x.enterShortQueue(this.queueIndex);
                    tickets.add((SignalScheduleTicket)x);
                    return true;
                }
                return false;
            });
            ++this.queueIndex;
            if (this.queueIndex >= 20) {
                this.queueIndex = 0;
            }
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld() == this.world) {
            SignalTicker.unload(this);
        }
    }

    public int getDelayOfQueue(int index) {
        if (index >= this.queueIndex) {
            return this.queueIndex - index + 1;
        }
        return 20 - index + this.queueIndex;
    }

    public synchronized List<ISignalScheduleTicket> findTickets(SignalOutputHandler condition) {
        ArrayList<ISignalScheduleTicket> tickets = new ArrayList<ISignalScheduleTicket>();
        for (int i = 0; i < this.queue.length; ++i) {
            for (SignalScheduleTicket ticket : this.queue[i]) {
                if (!ticket.is(condition)) continue;
                tickets.add(ticket);
            }
        }
        for (SignalScheduleTicket ticket : this.longQueue) {
            if (!ticket.is(condition)) continue;
            tickets.add(ticket);
        }
        return tickets;
    }

    public synchronized void schedule(ISignalSchedulable schedulable) {
        this.scheduled.add(schedulable);
    }

    public synchronized ISignalScheduleTicket openTicket(SignalScheduleTicket ticket) {
        int delay;
        int tick = ticket.getExactDelayValue();
        if (tick <= 20) {
            delay = this.queueIndex + tick - 1;
            if (delay >= 20) {
                delay -= 20;
            }
        } else {
            delay = tick;
        }
        if (tick <= 20) {
            ticket.enterShortQueue(delay);
            this.queue[delay].add(ticket);
        } else {
            this.longQueue.add(ticket);
        }
        return ticket;
    }

    public synchronized ISignalScheduleTicket openTicket(SignalOutputHandler handler, boolean[] result, int tick) {
        int delay;
        if (tick <= 20) {
            delay = this.queueIndex + tick - 1;
            if (delay >= 20) {
                delay -= 20;
            }
        } else {
            delay = tick;
        }
        SignalScheduleTicket ticket = new SignalScheduleTicket(handler, result, delay);
        if (tick <= 20) {
            this.queue[delay].add(ticket);
        } else {
            this.longQueue.add(ticket);
        }
        return ticket;
    }
}

