/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleLight
extends LittleStructure {
    public int level;
    public boolean disableRightClick = false;

    public LittleLight(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.level = nbt.func_74762_e("level");
        this.disableRightClick = nbt.func_74767_n("disableRightClick");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("level", this.level);
        nbt.func_74757_a("disableRightClick", this.disableRightClick);
    }

    @Override
    public int getLightValue(BlockPos pos) {
        return this.getOutput(0).getState()[0] ? this.level : 0;
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (!world.field_72995_K && !this.disableRightClick) {
            this.getOutput(0).toggle();
        }
        return true;
    }

    @Override
    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("enabled")) {
            World world = this.getWorld();
            try {
                this.tryAttributeChangeForBlocks();
                for (IStructureTileList list : this.blocksList()) {
                    IBlockState state = world.func_180495_p(list.getPos());
                    world.func_184138_a(list.getPos(), state, state, 2);
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getAttribute() {
        if (this.getOutput(0).getState()[0]) {
            return super.getAttribute() | 8;
        }
        return super.getAttribute();
    }

    public static class LittleLightStructureParser
    extends LittleStructureGuiParser {
        public LittleLightStructureParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            this.parent.addControl((GuiControl)new GuiSteppedSlider("level", 0, 0, 100, 12, structure instanceof LittleLight ? ((LittleLight)structure).level : 15, 0, 15));
            this.parent.addControl((GuiControl)new GuiCheckBox("rightclick", CoreControl.translate((String)"gui.door.rightclick"), 0, 20, structure instanceof LittleLight ? !((LittleLight)structure).disableRightClick : true));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleLight parseStructure(LittlePreviews previews) {
            LittleLight structure = this.createStructure(LittleLight.class, null);
            GuiSteppedSlider slider = (GuiSteppedSlider)this.parent.get("level");
            GuiCheckBox rightclick = (GuiCheckBox)this.parent.get("rightclick");
            structure.level = (int)slider.value;
            structure.disableRightClick = !rightclick.value;
            return structure;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleLight.class);
        }
    }
}

