/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade.signal;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.network.ISignalStructureTransmitter;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalCableBase;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.vec.SurroundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSignalCable
extends LittleSignalCableBase
implements ISignalStructureTransmitter {
    public LittleSignalCable(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean canConnect(EnumFacing facing) {
        return true;
    }

    @Override
    public int getIndex(EnumFacing facing) {
        return facing.ordinal();
    }

    @Override
    public EnumFacing getFacing(int index) {
        return EnumFacing.field_82609_l[index];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(SurroundingBox box, LittleBox overallBox, List<LittleRenderBox> cubes) {
        super.render(box, overallBox, cubes);
        AlignedBox structureBox = new AlignedBox(overallBox.getBox(box.getContext()));
        LittleRenderBox block = (LittleRenderBox)new LittleRenderBox(structureBox, null, LittleTiles.dyeableBlock, 0).setColor(this.color);
        block.allowOverlap = true;
        cubes.add(block);
    }

    public static class LittleStructureTypeCable
    extends LittleSignalCableBase.LittleStructureTypeNetwork {
        public LittleStructureTypeCable(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid, int bandwidth) {
            super(id, category, structureClass, attribute, modid, bandwidth, 6);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<RenderBox> getRenderingCubes(LittlePreviews previews) {
            ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
            int color = this.getColor(previews);
            float size = (float)((Math.sqrt(this.bandwidth) * 1.0 / 32.0 + 0.05) * 1.4);
            cubes = new ArrayList();
            cubes.add(new RenderBox(0.0f, 0.5f - size, 0.5f - size, size * 2.0f, 0.5f + size, 0.5f + size, (Block)LittleTiles.dyeableBlock).setColor(color));
            cubes.add(new RenderBox(0.0f + size * 2.0f, 0.5f - size * 0.8f, 0.5f - size * 0.8f, 1.0f - size * 2.0f, 0.5f + size * 0.8f, 0.5f + size * 0.8f, LittleTiles.singleCable).setColor(color).setKeepUV(true));
            cubes.add(new RenderBox(1.0f - size * 2.0f, 0.5f - size, 0.5f - size, 1.0f, 0.5f + size, 0.5f + size, (Block)LittleTiles.dyeableBlock).setColor(color));
            return cubes;
        }

        @Override
        public int getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public void changed() {
        }

        @Override
        public boolean[] getState() {
            return null;
        }

        @Override
        public SignalComponentType getType() {
            return SignalComponentType.TRANSMITTER;
        }
    }
}

