/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box.face;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.vec.VectorFan;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.util.EnumFacing;

public class LittleBoxFace {
    public LittleGridContext context;
    public LittleBox box;
    public final EnumFacing.Axis one;
    public final EnumFacing.Axis two;
    public final EnumFacing facing;
    public int minOne;
    public int minTwo;
    public int maxOne;
    public int maxTwo;
    public int origin;
    public int oldOrigin;
    public boolean[][] filled;
    private List<VectorFan> toCut = null;
    private List<VectorFan> cachedFans = null;
    private List<VectorFan> faceFans = null;
    private Iterable<VectorFan> tiltedFans = null;

    public LittleBoxFace(LittleBox box, List<VectorFan> faceFans, Iterable<VectorFan> tiltedFans, LittleGridContext context, EnumFacing facing, int minOne, int minTwo, int maxOne, int maxTwo, int origin) {
        this.box = box;
        this.faceFans = faceFans;
        this.tiltedFans = tiltedFans;
        this.context = context;
        this.facing = facing;
        this.one = RotationUtils.getOne((EnumFacing.Axis)facing.func_176740_k());
        this.two = RotationUtils.getTwo((EnumFacing.Axis)facing.func_176740_k());
        this.minOne = minOne;
        this.minTwo = minTwo;
        this.maxOne = maxOne;
        this.maxTwo = maxTwo;
        this.origin = origin;
        this.oldOrigin = origin;
        this.filled = new boolean[maxOne - minOne][maxTwo - minTwo];
    }

    public void ensureContext(LittleGridContext context) {
        if (context == this.context || this.context.size > context.size) {
            return;
        }
        int ratio = context.size / this.context.size;
        this.minOne *= ratio;
        this.minTwo *= ratio;
        this.maxOne *= ratio;
        this.maxTwo *= ratio;
        this.origin *= ratio;
        this.oldOrigin *= ratio;
        this.box = this.box.copy();
        this.box.convertTo(this.context, context);
        this.context = context;
        this.filled = new boolean[this.maxOne - this.minOne][this.maxTwo - this.minTwo];
        if (this.faceFans != null) {
            ArrayList<VectorFan> newFans = new ArrayList<VectorFan>(this.faceFans.size());
            for (VectorFan fan : this.faceFans) {
                fan = fan.copy();
                fan.scale((float)ratio);
                newFans.add(fan);
            }
            if (this.tiltedFans != null) {
                ArrayList<VectorFan> tiledFansNew = new ArrayList<VectorFan>();
                for (VectorFan fan : this.tiltedFans) {
                    fan = fan.copy();
                    fan.scale((float)ratio);
                    tiledFansNew.add(fan);
                }
                this.tiltedFans = tiledFansNew;
            }
            this.faceFans = newFans;
        }
    }

    public boolean isPartiallyFilled() {
        if (this.toCut != null) {
            return true;
        }
        for (int one = 0; one < this.filled.length; ++one) {
            for (int two = 0; two < this.filled[one].length; ++two) {
                if (!this.filled[one][two]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFilled(boolean important) {
        if (important && this.toCut != null) {
            return this.generateFans().isEmpty();
        }
        for (int one = 0; one < this.filled.length; ++one) {
            for (int two = 0; two < this.filled[one].length; ++two) {
                if (this.filled[one][two]) continue;
                return false;
            }
        }
        return true;
    }

    private float get(LittleBox box, int index) {
        EnumFacing direction = EnumFacing.field_82609_l[index];
        if (direction.func_176740_k() == this.one) {
            return (direction.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? box.maxX : box.minX) + this.minOne;
        }
        if (direction.func_176740_k() == this.two) {
            return (direction.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? box.maxY : box.minY) + this.minTwo;
        }
        return this.oldOrigin;
    }

    public void cut(List<VectorFan> fans) {
        if (this.toCut == null) {
            this.toCut = new ArrayList<VectorFan>();
        }
        this.toCut.addAll(fans);
    }

    public List<VectorFan> generateFans() {
        if (this.cachedFans != null) {
            return this.cachedFans;
        }
        ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
        int startOne = 0;
        int startTwo = 0;
        boolean toAdd = false;
        for (int one = 0; one < this.filled.length; ++one) {
            for (int two = 0; two < this.filled[one].length; ++two) {
                if (this.filled[one][two]) {
                    if (toAdd) {
                        boxes.add(new LittleBox(startOne, startTwo, 0, one + 1, two, 0));
                        toAdd = false;
                    }
                    startOne = one;
                    startTwo = two;
                    continue;
                }
                if (toAdd) continue;
                startOne = one;
                startTwo = two;
                toAdd = true;
            }
            if (!toAdd) continue;
            boxes.add(new LittleBox(startOne, startTwo, 0, one + 1, this.filled[one].length, 0));
            toAdd = false;
        }
        BasicCombiner.combineBoxes(boxes);
        Object fans = new ArrayList<VectorFan>(boxes.size());
        for (LittleBox iterator : boxes) {
            EnumFaceDirection face = EnumFaceDirection.func_179027_a((EnumFacing)this.facing);
            Vector3f[] coords = new Vector3f[4];
            for (int i = 0; i < coords.length; ++i) {
                EnumFaceDirection.VertexInformation info = face.func_179025_a(i);
                Vector3f vec = new Vector3f();
                vec.x = this.get(iterator, info.field_179184_a);
                vec.y = this.get(iterator, info.field_179182_b);
                vec.z = this.get(iterator, info.field_179183_c);
                coords[i] = vec;
            }
            fans.add(new VectorFan(coords));
        }
        if (this.faceFans != null) {
            ArrayList newFans = new ArrayList();
            Iterator iterator = fans.iterator();
            while (iterator.hasNext()) {
                VectorFan fan3 = (VectorFan)iterator.next();
                newFans.addAll(fan3.cut2d(this.faceFans, this.one, this.two, this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE, true));
            }
            fans = newFans;
        }
        if (this.toCut == null) {
            if (this.tiltedFans != null) {
                for (VectorFan vectorFan : this.tiltedFans) {
                    fans.add(vectorFan);
                }
            }
            return fans;
        }
        ArrayList<VectorFan> result = new ArrayList<VectorFan>();
        Iterator iterator = fans.iterator();
        while (iterator.hasNext()) {
            VectorFan fan = (VectorFan)iterator.next();
            result.addAll(fan.cut2d(this.toCut, this.one, this.two, this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE, false));
        }
        if (this.tiltedFans != null) {
            for (VectorFan fan : this.tiltedFans) {
                result.add(fan);
            }
        }
        this.cachedFans = result;
        return result;
    }

    public LittleBox getBox() {
        return this.box;
    }

    public boolean isFaceInsideBlock() {
        return this.origin > 0 && this.origin < this.context.maxPos;
    }

    public void move(EnumFacing facing) {
        this.origin = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0 : this.context.maxPos;
    }
}

