/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.place;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxReturnedVolume;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.Placement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public class PlacePreview {
    public LittleBox box;
    public LittlePreview preview;

    public PlacePreview(LittleBox box, LittlePreview preview) {
        this.box = box;
        this.preview = preview;
    }

    public PlacePreview copy() {
        return new PlacePreview(this.box.copy(), this.preview.copy());
    }

    public boolean needsCollisionTest() {
        return true;
    }

    public List<LittleRenderBox> getPreviews(LittleGridContext context) {
        ArrayList<LittleRenderBox> previews = new ArrayList<LittleRenderBox>();
        previews.add(this.box.getRenderingCube(context, null, 0));
        return previews;
    }

    public List<LittleTile> placeTile(Placement placement, Placement.PlacementBlock block, IParentTileList parent, LittleStructure structure, boolean requiresCollisionTest) {
        LittleTile LT = this.preview.getLittleTile();
        if (LT == null) {
            return Collections.EMPTY_LIST;
        }
        LT.setBox(this.box.copy());
        return placement.mode.placeTile(placement, block, parent, structure, LT, requiresCollisionTest);
    }

    public PlacePreview copyWithBox(LittleBox box) {
        PlacePreview tile = this.copy();
        tile.box = box;
        return tile;
    }

    public boolean split(LittleGridContext context, HashMapList<BlockPos, PlacePreview> tiles, BlockPos pos, LittleBoxReturnedVolume volume) {
        if (!this.requiresSplit()) {
            tiles.add((Object)pos, (Object)this);
            return true;
        }
        HashMapList boxes = new HashMapList();
        this.box.split(context, pos, (HashMapList<BlockPos, LittleBox>)boxes, volume);
        for (Map.Entry entry : boxes.entrySet()) {
            for (LittleBox box : (ArrayList)entry.getValue()) {
                tiles.add(entry.getKey(), (Object)this.copyWithBox(box));
            }
        }
        return true;
    }

    public boolean requiresSplit() {
        return true;
    }

    public void add(LittleVec vec) {
        this.box.add(vec);
    }

    public void convertTo(LittleGridContext context, LittleGridContext to) {
        this.box.convertTo(context, to);
    }

    public int getSmallestContext(LittleGridContext context) {
        return this.box.getSmallestContext(context);
    }
}

