/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tileentity;

import com.creativemd.creativecore.common.tileentity.TileEntityCreative;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.block.BlockSignalConverter;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.component.ISignalStructureBase;
import com.creativemd.littletiles.common.structure.signal.component.ISignalStructureComponent;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.network.SignalNetwork;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TESignalConverter
extends TileEntityCreative
implements ISignalStructureComponent {
    private SignalNetwork network;
    private boolean[] inputSignalState = new boolean[4];
    private boolean[] inputRedstoneState = new boolean[4];
    private int redstoneState;
    private List<SignalConnection> connections = new ArrayList<SignalConnection>();

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return state.func_185897_m() && side != null;
    }

    @Override
    public World getStructureWorld() {
        return this.func_145831_w();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    @Override
    public int getBandwidth() {
        return 4;
    }

    @Override
    public SignalNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(SignalNetwork network) {
        this.network = network;
    }

    @Override
    public Iterator<ISignalStructureBase> connections() {
        return new Iterator<ISignalStructureBase>(){
            Iterator<SignalConnection> iterator;
            {
                this.iterator = TESignalConverter.this.connections.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ISignalStructureBase next() {
                return this.iterator.next().base;
            }
        };
    }

    @Override
    public boolean canConnect(EnumFacing facing) {
        return true;
    }

    public int indexOf(ISignalStructureBase base) {
        for (int i = 0; i < this.connections.size(); ++i) {
            if (this.connections.get((int)i).base != base) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean connect(EnumFacing facing, ISignalStructureBase base, LittleGridContext context, int distance, boolean oneSidedRenderer) {
        int index = this.indexOf(base);
        if (index == -1) {
            this.connections.add(new SignalConnection(facing, base));
        }
        return true;
    }

    @Override
    public void disconnect(EnumFacing facing, ISignalStructureBase base) {
        int index = this.indexOf(base);
        if (index != -1) {
            this.connections.remove(index);
        }
    }

    @Override
    public SignalComponentType getType() {
        return SignalComponentType.IOSPECIAL;
    }

    @Override
    public void updateState(boolean[] state) {
        if (!BooleanUtils.equals((boolean[])state, (boolean[])this.inputSignalState)) {
            BooleanUtils.set((boolean[])this.inputSignalState, (boolean[])state);
            this.changed();
        }
    }

    @Override
    public void changed() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockSignalConverter.FACING);
        this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(facing), state.func_177230_c(), this.field_174879_c);
    }

    public int getPower() {
        boolean[] toReturn = new boolean[4];
        BooleanUtils.or((boolean[])toReturn, (boolean[])this.inputRedstoneState);
        BooleanUtils.or((boolean[])toReturn, (boolean[])this.inputSignalState);
        return BooleanUtils.toNumber((boolean[])toReturn);
    }

    @Override
    public boolean[] getState() {
        return this.inputRedstoneState;
    }

    @Override
    public LittleStructure getStructure() {
        return null;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public int getColor() {
        return -1;
    }

    public void setPower(int level) {
        boolean[] newLevel = BooleanUtils.toBits((int)level, (int)4);
        if (!BooleanUtils.equals((boolean[])this.inputRedstoneState, (boolean[])newLevel)) {
            BooleanUtils.set((boolean[])this.inputRedstoneState, (boolean[])newLevel);
            this.changed();
            this.findNetwork().update();
        }
    }

    public class SignalConnection {
        public final EnumFacing facing;
        public final ISignalStructureBase base;

        public SignalConnection(EnumFacing facing, ISignalStructureBase base) {
            this.facing = facing;
            this.base = base;
        }
    }
}

