/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.util.place.PlaceModeAll;
import com.creativemd.littletiles.common.util.place.PlaceModeFill;
import com.creativemd.littletiles.common.util.place.PlaceModeNormal;
import com.creativemd.littletiles.common.util.place.PlaceModeOverwrite;
import com.creativemd.littletiles.common.util.place.PlaceModeOverwriteAll;
import com.creativemd.littletiles.common.util.place.PlaceModeReplace;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementModeColorize;
import com.creativemd.littletiles.common.util.place.PlacementModeStencil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PlacementMode {
    private static LinkedHashMap<String, PlacementMode> modes = new LinkedHashMap();
    public static final PlacementMode normal = new PlaceModeNormal("placement.mode.default", PreviewMode.PREVIEWS, false);
    public static final PlacementMode fill = new PlaceModeFill("placement.mode.fill", PreviewMode.PREVIEWS);
    public static final PlacementMode all = new PlaceModeAll("placement.mode.all", PreviewMode.PREVIEWS);
    public static final PlacementMode overwrite = new PlaceModeOverwrite("placement.mode.overwrite", PreviewMode.PREVIEWS);
    public static final PlacementMode overwrite_all = new PlaceModeOverwriteAll("placement.mode.overwriteall", PreviewMode.PREVIEWS);
    public static final PlacementMode replace = new PlaceModeReplace("placement.mode.replace", PreviewMode.LINES);
    public static final PlacementMode stencil = new PlacementModeStencil("placement.mode.stencil", PreviewMode.LINES);
    public static final PlacementMode colorize = new PlacementModeColorize("placement.mode.colorize", PreviewMode.LINES);
    public final String name;
    public final boolean placeInside;
    private final PreviewMode mode;

    public static PlacementMode getDefault() {
        return normal;
    }

    public static PlacementMode getStructureDefault() {
        return all;
    }

    public static PlacementMode getModeOrDefault(String name) {
        PlacementMode mode = PlacementMode.getMode(name);
        if (mode != null) {
            return mode;
        }
        return PlacementMode.getDefault();
    }

    public static PlacementMode getMode(String name) {
        return modes.get(name);
    }

    public static Collection<String> getModeNames() {
        return modes.keySet();
    }

    public static List<String> getLocalizedModeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String mode : PlacementMode.getModeNames()) {
            names.add(I18n.func_74838_a((String)mode));
        }
        return names;
    }

    public PlacementMode(String name, PreviewMode mode, boolean placeInside) {
        this.name = name;
        this.mode = mode;
        this.placeInside = placeInside;
        modes.put(name, this);
    }

    public PreviewMode getPreviewMode() {
        if (LittleTiles.CONFIG.rendering.previewLines) {
            return PreviewMode.LINES;
        }
        return this.mode;
    }

    public abstract List<BlockPos> getCoordsToCheck(Set<BlockPos> var1, BlockPos var2);

    public abstract List<LittleTile> placeTile(Placement var1, Placement.PlacementBlock var2, IParentTileList var3, LittleStructure var4, LittleTile var5, boolean var6);

    @SideOnly(value=Side.CLIENT)
    public PlacementMode place() {
        return this;
    }

    public boolean canPlaceStructures() {
        return false;
    }

    public boolean checkAll() {
        return true;
    }

    public boolean shouldConvertBlock() {
        return false;
    }

    public void prepareBlock(Placement placement, Placement.PlacementBlock block, boolean requiresCollisionTest) {
    }

    public static enum PreviewMode {
        LINES,
        PREVIEWS;

    }
}

