/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape;

import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.littletiles.client.gui.SubGuiMarkShapeSelection;
import com.creativemd.littletiles.common.api.ILittleTool;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.IMarkMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ShapeSelection
implements Iterable<ShapeSelectPos>,
IGridBased,
IMarkMode {
    public ItemStack stack;
    public ILittleTool tool;
    private final List<ShapeSelectPos> positions = new ArrayList<ShapeSelectPos>();
    protected LittleShape shape;
    protected String shapeKey;
    public final boolean inside;
    private ShapeSelectPos last;
    protected LittleBoxes cachedBoxesLowRes;
    protected LittleBoxes cachedBoxes;
    protected BlockPos pos;
    protected LittleGridContext context = LittleGridContext.getMin();
    protected LittleBox overallBox;
    private boolean marked;
    private int markedPosition;
    public boolean allowLowResolution = true;

    public ShapeSelection(ItemStack stack, boolean inside) {
        this.inside = inside;
        this.tool = (ILittleTool)stack.func_77973_b();
        this.stack = stack;
        this.shapeKey = this.getNBT().func_74779_i("shape");
        this.shape = ShapeRegistry.getShape(this.shapeKey);
    }

    public NBTTagCompound getNBT() {
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        return this.stack.func_77978_p();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    public LittleBox getOverallBox() {
        return this.overallBox;
    }

    public LittleBoxes getBoxes(boolean allowLowResolution) {
        if (this.marked ? this.allowLowResolution : allowLowResolution) {
            return this.cachedBoxesLowRes;
        }
        if (this.cachedBoxes == null) {
            this.forceHighResCache();
        }
        return this.cachedBoxes;
    }

    private void forceHighResCache() {
        this.cachedBoxes = this.shape.getBoxes(this, false);
    }

    private void rebuildShapeCache() {
        if (!this.marked && this.last == null) {
            return;
        }
        LittleGridContext context = this.tool.getPositionContext(this.stack);
        this.convertToAtMinimum(context);
        NBTTagCompound nbt = this.getNBT();
        if (!this.shapeKey.equals(nbt.func_74779_i("shape"))) {
            this.shapeKey = nbt.func_74779_i("shape");
            this.shape = ShapeRegistry.getShape(this.shapeKey);
        }
        this.cachedBoxes = null;
        this.cachedBoxesLowRes = null;
        LittleBox[] pointBoxes = new LittleBox[this.positions.size() + (this.marked ? 0 : 1)];
        int i = 0;
        for (ShapeSelectPos pos : this) {
            pointBoxes[i] = new LittleBox(pos.pos.getRelative(this.pos));
            ++i;
        }
        this.overallBox = new LittleBox(pointBoxes);
        this.cachedBoxesLowRes = this.shape.getBoxes(this, true);
    }

    public void deleteCache() {
        this.cachedBoxes = null;
        this.cachedBoxesLowRes = null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addAndCheckIfPlace(EntityPlayer player, PlacementPosition position, RayTraceResult result) {
        if (this.marked) {
            return true;
        }
        ShapeSelectPos pos = new ShapeSelectPos(player, position, result);
        if (!(this.shape.pointsBeforePlacing <= this.positions.size() + 1 && !GuiScreen.func_146271_m() || this.shape.maxAllowed() != -1 && this.shape.maxAllowed() <= this.positions.size() + 1)) {
            this.positions.add(pos);
            this.ensureSameContext(pos);
            this.rebuildShapeCache();
            return false;
        }
        this.last = pos;
        this.ensureSameContext(this.last);
        this.rebuildShapeCache();
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setLast(EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        this.stack = stack;
        if (this.positions.isEmpty()) {
            this.pos = position.getPos();
        }
        this.last = new ShapeSelectPos(player, position, result);
        this.ensureSameContext(this.last);
        this.rebuildShapeCache();
    }

    private void ensureSameContext(ShapeSelectPos pos) {
        if (this.context.size > pos.getContext().size) {
            pos.convertTo(this.context);
        } else if (this.context.size < pos.getContext().size) {
            this.convertTo(pos.getContext());
        }
    }

    public void toggleMark() {
        if (this.marked) {
            while (this.shape.maxAllowed() != -1 && this.positions.size() >= this.shape.maxAllowed()) {
                this.positions.remove(this.positions.size() - 1);
            }
            this.marked = false;
        } else {
            this.markedPosition = this.positions.size();
            this.positions.add(this.last);
            this.marked = true;
        }
    }

    @Override
    public boolean allowLowResolution() {
        return this.allowLowResolution;
    }

    @Override
    public PlacementPosition getPosition() {
        return this.positions.get((int)this.markedPosition).pos.copy();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGui getConfigurationGui() {
        return new SubGuiMarkShapeSelection(this);
    }

    @Override
    public void move(LittleGridContext context, EnumFacing facing) {
        this.positions.get(this.markedPosition).move(context, facing);
        this.forceHighResCache();
    }

    @Override
    public void done() {
        this.toggleMark();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(double x, double y, double z) {
        if (this.marked) {
            for (int i = 0; i < this.positions.size(); ++i) {
                this.positions.get(i).render(x, y, z, this.markedPosition == i);
            }
        }
    }

    public void rotate(EntityPlayer player, ItemStack stack, Rotation rotation) {
        this.shape.rotate(this.getNBT(), rotation);
        this.rebuildShapeCache();
    }

    public void flip(EntityPlayer player, ItemStack stack, EnumFacing.Axis axis) {
        this.shape.flip(this.getNBT(), axis);
        this.rebuildShapeCache();
    }

    @SideOnly(value=Side.CLIENT)
    public void click(EntityPlayer player) {
        if (!this.marked) {
            return;
        }
        int index = -1;
        double distance = Double.MAX_VALUE;
        float partialTickTime = TickUtils.getPartialTickTime();
        Vec3d pos = player.func_174824_e(partialTickTime);
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(partialTickTime);
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        for (int i = 0; i < this.positions.size(); ++i) {
            double tempDistance;
            RayTraceResult result = this.positions.get((int)i).box.func_72327_a(pos, vec32);
            if (result == null || !((tempDistance = pos.func_72436_e(result.field_72307_f)) < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        if (index != -1) {
            this.markedPosition = index;
        }
    }

    @Override
    public Iterator<ShapeSelectPos> iterator() {
        if (this.marked) {
            return this.positions.iterator();
        }
        return new Iterator<ShapeSelectPos>(){
            private Iterator<ShapeSelectPos> iter;
            private boolean last;
            {
                this.iter = ShapeSelection.this.positions.iterator();
                this.last = false;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext() || !this.last;
            }

            @Override
            public ShapeSelectPos next() {
                if (this.iter.hasNext()) {
                    return this.iter.next();
                }
                if (!this.last) {
                    this.last = true;
                    return ShapeSelection.this.last;
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    public ShapeSelectPos getFirst() {
        if (this.positions.size() > 0) {
            return this.positions.get(0);
        }
        return this.last;
    }

    public ShapeSelectPos getLast() {
        return this.last;
    }

    @Override
    public void convertTo(LittleGridContext to) {
        for (ShapeSelectPos other : this.positions) {
            other.convertTo(to);
        }
        this.context = to;
    }

    @Override
    public void convertToSmallest() {
        int smallest = LittleGridContext.getMin().size;
        for (int i = 0; i < this.positions.size(); ++i) {
            smallest = Math.max(smallest, this.positions.get(i).getSmallestContext());
        }
        this.convertTo(LittleGridContext.get(smallest));
    }

    public class ShapeSelectPos
    implements IGridBased {
        public final PlacementPosition pos;
        public final RayTraceResult ray;
        public final BlockTile.TEResult result;
        public AxisAlignedBB box;

        public ShapeSelectPos(EntityPlayer player, PlacementPosition position, RayTraceResult result) {
            this.pos = position;
            this.ray = result;
            this.result = BlockTile.loadTeAndTile((IBlockAccess)player.field_70170_p, result.func_178782_a(), player);
            this.box = this.pos.getBox().func_186662_g(0.002);
            if (ShapeSelection.this.inside && result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && ShapeSelection.this.context.isAtEdge(VectorUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                this.pos.getVec().sub(result.field_178784_b);
            }
        }

        public void move(LittleGridContext context, EnumFacing facing) {
            LittleVec vec = new LittleVec(facing);
            vec.scale(GuiScreen.func_146271_m() ? context.size : 1);
            this.pos.subVec(vec);
            this.box = this.pos.getBox().func_186662_g(0.002);
        }

        @SideOnly(value=Side.CLIENT)
        public void render(double x, double y, double z, boolean selected) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            AxisAlignedBB box = this.box.func_72317_d(-x, -y, -z);
            GlStateManager.func_187441_d((float)4.0f);
            RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_187441_d((float)1.0f);
            if (selected) {
                RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)1.0f, (float)0.3f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }

        @Override
        public LittleGridContext getContext() {
            return this.pos.getContext();
        }

        @Override
        public void convertTo(LittleGridContext to) {
            this.pos.convertTo(to);
        }

        @Override
        public void convertToSmallest() {
            this.pos.convertToSmallest();
        }

        public int getSmallestContext() {
            return this.pos.getSmallestContext();
        }
    }
}

