/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.drag;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleTransformableBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.shape.drag.DragShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DragShapePillar
extends DragShape {
    public DragShapePillar() {
        super("pillar");
    }

    @Override
    public LittleBoxes getBoxes(LittleBoxes boxes, LittleVec min, LittleVec max, EntityPlayer player, NBTTagCompound nbt, boolean preview, PlacementPosition originalMin, PlacementPosition originalMax) {
        int thickness = Math.max(0, nbt.func_74762_e("thickness") - 1);
        originalMin.convertTo(boxes.getContext());
        originalMax.convertTo(boxes.getContext());
        LittleTransformableBox box = new LittleTransformableBox(new LittleBox(min, max), new int[0]);
        EnumFacing.Axis axis = box.getSize().getLongestAxis();
        LittleTransformableBox littleTransformableBox = box;
        littleTransformableBox.getClass();
        LittleTransformableBox.CornerCache cache = littleTransformableBox.new LittleTransformableBox.CornerCache(false);
        LittleVec originalMinVec = originalMin.getRelative(boxes.pos);
        LittleVec originalMaxVec = originalMax.getRelative(boxes.pos);
        LittleBox minBox = new LittleBox(originalMinVec);
        LittleBox maxBox = new LittleBox(originalMaxVec);
        boolean facingPositive = originalMinVec.get(axis) > originalMaxVec.get(axis);
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
        EnumFacing minFacing = originalMin.facing;
        EnumFacing maxFacing = originalMax.facing;
        if (box.getSize(minFacing.func_176740_k()) == 1) {
            minFacing = null;
        }
        if (box.getSize(maxFacing.func_176740_k()) == 1) {
            maxFacing = null;
        }
        int invSize = thickness / 2;
        int size = thickness - invSize;
        minBox.growCentered(thickness);
        LittleVec vec = new LittleVec(originalMin.facing);
        if (originalMin.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            vec.scale(size);
        } else {
            vec.scale(-invSize);
        }
        minBox.add(vec);
        maxBox.growCentered(thickness);
        vec = new LittleVec(originalMax.facing);
        if (originalMax.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            vec.scale(size);
        } else {
            vec.scale(-invSize);
        }
        maxBox.add(vec);
        box.growToInclude(minBox);
        box.growToInclude(maxBox);
        this.shrinkEdge(cache, axis, one, two, facingPositive, minFacing, minBox);
        this.shrinkEdge(cache, axis, one, two, !facingPositive, maxFacing, maxBox);
        box.setData(cache.getData());
        boxes.add(box);
        return boxes;
    }

    public void shrinkEdge(LittleTransformableBox.CornerCache cache, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, EnumFacing targetFace, LittleBox box) {
        EnumFacing facing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(positive ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)axis);
        if (targetFace == null) {
            targetFace = facing;
        } else if (targetFace == facing.func_176734_d()) {
            targetFace = facing;
        }
        EnumFacing.Axis targetAxis = targetFace.func_176740_k();
        BoxCorner[] corners = BoxCorner.faceCorners((EnumFacing)facing);
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner;
            cache.setAbsolute(corner, one, (corner = corners[i]).isFacingPositive(one) ? box.getMax(one) : box.getMin(one));
            cache.setAbsolute(corner, two, corner.isFacingPositive(two) ? box.getMax(two) : box.getMin(two));
            if (facing == targetFace) continue;
            if (corner.isFacingPositive(targetAxis) != (targetFace.func_176743_c() == EnumFacing.AxisDirection.POSITIVE)) {
                cache.setAbsolute(corner, axis, positive ? box.getMin(axis) : box.getMax(axis));
                continue;
            }
            cache.setAbsolute(corner, targetAxis, targetFace.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? box.getMin(targetAxis) : box.getMax(targetAxis));
        }
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 5, 100, 14, nbt.func_74762_e("thickness"), 1, context.size));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.func_74768_a("thickness", (int)slider.value);
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

