/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.type;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeSelection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleShapeConnected
extends LittleShape {
    private static final ConnectedBlock EMPTY = new ConnectedBlock(null, null);

    public LittleShapeConnected() {
        super(1);
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        for (ShapeSelection.ShapeSelectPos pos : selection) {
            if (pos.result.isComplete()) {
                ConnectedBlock block = new ConnectedBlock(pos.result.te, pos.result.tile);
                boxes = block.start(boxes, pos.result.tile, selection.inside ? null : pos.pos.facing);
                continue;
            }
            LittleGridContext context = selection.getContext();
            if (selection.inside) {
                boxes.addBox(context, pos.ray.func_178782_a(), new LittleBox(0, 0, 0, context.size, context.size, context.size));
                continue;
            }
            boxes.addBox(context, pos.ray.func_178782_a().func_177972_a(pos.pos.facing), new LittleBox(0, 0, 0, context.size, context.size, context.size));
        }
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        return Collections.EMPTY_LIST;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }

    private static class ConnectedBlock {
        private final TileEntityLittleTiles parent;
        private final List<LittleBox> potential;
        private ConnectedBlock[] neighborCache = new ConnectedBlock[6];

        public ConnectedBlock(TileEntityLittleTiles te, LittleTile startTile) {
            this.parent = te;
            this.potential = new ArrayList<LittleBox>();
            if (te != null) {
                for (LittleTile tile : te.noneStructureTiles()) {
                    if (tile == startTile || !tile.canBeCombined(startTile) || !startTile.canBeCombined(tile)) continue;
                    this.potential.add(tile.getBox());
                }
            }
        }

        private void addBox(LittleBoxes boxes, LittleBox box, EnumFacing facing) {
            if (facing == null) {
                boxes.addBox(this.parent.getContext(), this.parent.func_174877_v(), box);
            } else {
                LittleVec vec = new LittleVec(facing);
                vec.scale(box.getSize(facing.func_176740_k()));
                box.add(vec);
                boxes.addBox(this.parent.getContext(), this.parent.func_174877_v(), box);
            }
        }

        public LittleBoxes start(LittleBoxes boxes, LittleTile startTile, EnumFacing facing) {
            HashMap<BlockPos, ConnectedBlock> blocks = new HashMap<BlockPos, ConnectedBlock>();
            blocks.put(this.parent.func_174877_v(), this);
            this.addBox(boxes, startTile.getBox().copy(), facing);
            this.performSearchIn(boxes, blocks, startTile, true, this.parent.getContext(), startTile.getBox().copy(), facing);
            return boxes;
        }

        public void performSearchIn(LittleBoxes boxes, HashMap<BlockPos, ConnectedBlock> blocks, LittleTile startTile, boolean start, LittleGridContext other, LittleBox otherBox, EnumFacing insideFace) {
            LittleGridContext context = this.parent.getContext();
            ArrayList<LittleBox> added = new ArrayList<LittleBox>();
            for (int index = 0; index <= added.size(); ++index) {
                Iterator<LittleBox> iterator = this.potential.iterator();
                while (iterator.hasNext()) {
                    LittleBox box = iterator.next();
                    if (!(index == 0 ? box.doesTouch(context, other, otherBox) : box.doesTouch((LittleBox)added.get(index - 1)))) continue;
                    LittleBox copy = box.copy();
                    this.addBox(boxes, copy, insideFace);
                    added.add(box.copy());
                    iterator.remove();
                }
            }
            if (start) {
                added.add(otherBox);
            }
            for (LittleBox box : added) {
                for (int i = 0; i < this.neighborCache.length; ++i) {
                    ConnectedBlock block;
                    EnumFacing facing = EnumFacing.func_82600_a((int)i);
                    if (!box.isFaceAtEdge(context, facing)) continue;
                    if (this.neighborCache[i] == null) {
                        BlockPos pos = this.parent.func_174877_v().func_177972_a(facing);
                        ConnectedBlock block2 = blocks.get(pos);
                        if (block2 == null) {
                            TileEntity te = this.parent.func_145831_w().func_175625_s(pos);
                            block2 = te instanceof TileEntityLittleTiles ? new ConnectedBlock((TileEntityLittleTiles)te, startTile) : EMPTY;
                            blocks.put(pos, block2);
                        }
                        this.neighborCache[i] = block2;
                    }
                    if ((block = this.neighborCache[i]).isEmpty()) continue;
                    LittleBox copyBox = box.copy();
                    copyBox.sub(context.size * facing.func_82601_c(), context.size * facing.func_96559_d(), context.size * facing.func_82599_e());
                    LittleGridContext used = context;
                    if (block.getContext().size > context.size) {
                        copyBox.convertTo(context, block.getContext());
                        used = block.getContext();
                    }
                    block.performSearchIn(boxes, blocks, startTile, false, used, copyBox, insideFace);
                }
            }
        }

        public LittleGridContext getContext() {
            return this.parent.getContext();
        }

        public boolean isEmpty() {
            return this.potential.isEmpty();
        }
    }
}

