/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.type;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleTransformableBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeSelection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleShapeWall
extends LittleShape {
    public LittleShapeWall() {
        super(2);
    }

    public void shrinkEdge(LittleTransformableBox.CornerCache cache, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, LittleBox box) {
        EnumFacing facing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(positive ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)axis);
        BoxCorner[] corners = BoxCorner.faceCorners((EnumFacing)facing);
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner;
            cache.setAbsolute(corner, one, (corner = corners[i]).isFacingPositive(one) ? box.getMax(one) : box.getMin(one));
            cache.setAbsolute(corner, two, corner.isFacingPositive(two) ? box.getMax(two) : box.getMin(two));
        }
    }

    public void shrinkEdge(LittleTransformableBox.CornerCache cache, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, EnumFacing targetFace, LittleBox box) {
        EnumFacing facing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(positive ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)axis);
        if (targetFace == null) {
            targetFace = facing;
        } else if (targetFace == facing.func_176734_d()) {
            targetFace = facing;
        }
        EnumFacing.Axis targetAxis = targetFace.func_176740_k();
        BoxCorner[] corners = BoxCorner.faceCorners((EnumFacing)facing);
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner;
            cache.setAbsolute(corner, one, (corner = corners[i]).isFacingPositive(one) ? box.getMax(one) : box.getMin(one));
            cache.setAbsolute(corner, two, corner.isFacingPositive(two) ? box.getMax(two) : box.getMin(two));
            if (facing == targetFace) continue;
            if (corner.isFacingPositive(targetAxis) != (targetFace.func_176743_c() == EnumFacing.AxisDirection.POSITIVE)) {
                cache.setAbsolute(corner, axis, positive ? box.getMin(axis) : box.getMax(axis));
                continue;
            }
            cache.setAbsolute(corner, targetAxis, targetFace.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? box.getMin(targetAxis) : box.getMax(targetAxis));
        }
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        int direction = selection.getNBT().func_74762_e("direction");
        PlacementPosition originalMin = selection.getFirst().pos.copy();
        PlacementPosition originalMax = selection.getLast().pos.copy();
        originalMin.convertTo(boxes.getContext());
        originalMax.convertTo(boxes.getContext());
        int thickness = Math.max(0, selection.getNBT().func_74762_e("thickness") - 1);
        LittleTransformableBox box = new LittleTransformableBox(selection.getOverallBox(), new int[1]);
        EnumFacing.Axis toIgnore = direction == 0 ? EnumFacing.Axis.Y : (direction == 1 ? EnumFacing.Axis.X : EnumFacing.Axis.Z);
        EnumFacing.Axis oneIgnore = RotationUtils.getOne((EnumFacing.Axis)toIgnore);
        EnumFacing.Axis twoIgnore = RotationUtils.getTwo((EnumFacing.Axis)toIgnore);
        EnumFacing.Axis axis = box.getSize(oneIgnore) > box.getSize(twoIgnore) ? oneIgnore : twoIgnore;
        LittleTransformableBox littleTransformableBox = box;
        littleTransformableBox.getClass();
        LittleTransformableBox.CornerCache cache = littleTransformableBox.new LittleTransformableBox.CornerCache(false);
        LittleVec originalMinVec = originalMin.getRelative(boxes.pos);
        LittleVec originalMaxVec = originalMax.getRelative(boxes.pos);
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
        LittleBox minBox = new LittleBox(originalMinVec);
        LittleBox maxBox = new LittleBox(originalMaxVec);
        EnumFacing minFacing = originalMin.facing;
        EnumFacing maxFacing = originalMax.facing;
        if (minFacing.func_176740_k() == toIgnore || box.getSize(minFacing.func_176740_k()) == 1) {
            minFacing = null;
        }
        if (maxFacing.func_176740_k() == toIgnore || box.getSize(maxFacing.func_176740_k()) == 1) {
            maxFacing = null;
        }
        int invSize = thickness / 2;
        int size = thickness - invSize;
        minBox.growCentered(thickness);
        LittleVec vec = new LittleVec(originalMin.facing);
        if (originalMin.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            vec.scale(size);
        } else {
            vec.scale(-invSize);
        }
        minBox.add(vec);
        maxBox.growCentered(thickness);
        vec = new LittleVec(originalMax.facing);
        if (originalMax.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            vec.scale(size);
        } else {
            vec.scale(-invSize);
        }
        maxBox.add(vec);
        box.growToInclude(minBox);
        box.growToInclude(maxBox);
        minBox.setMin(toIgnore, box.getMin(toIgnore));
        maxBox.setMin(toIgnore, box.getMin(toIgnore));
        minBox.setMax(toIgnore, box.getMax(toIgnore));
        maxBox.setMax(toIgnore, box.getMax(toIgnore));
        boolean facingPositive = originalMinVec.get(axis) > originalMaxVec.get(axis);
        this.shrinkEdge(cache, axis, one, two, facingPositive, minFacing, minBox);
        this.shrinkEdge(cache, axis, one, two, !facingPositive, maxFacing, maxBox);
        box.setData(cache.getData());
        boxes.add(box);
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        list.add("thickness: " + nbt.func_74762_e("thickness") + " tiles");
        int facing = nbt.func_74762_e("direction");
        String text = "facing: ";
        switch (facing) {
            case 0: {
                text = text + "y";
                break;
            }
            case 1: {
                text = text + "x";
                break;
            }
            case 2: {
                text = text + "z";
            }
        }
        list.add(text);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 5, 100, 14, nbt.func_74762_e("thickness"), 1, context.size));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.func_74762_e("direction"), 5, 27, new String[]{"facing: y", "facing: x", "facing: z"}));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.func_74768_a("thickness", (int)slider.value);
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.func_74768_a("direction", state.getState());
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
        int direction = nbt.func_74762_e("direction");
        direction = rotation.axis != EnumFacing.Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.func_74768_a("direction", direction);
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

