/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.wiki.page.panel;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.client.screen.Texture;
import owmii.lib.client.screen.widget.IconButton;
import owmii.lib.client.screen.wiki.WikiScreen;
import owmii.lib.client.util.MC;
import owmii.lib.client.wiki.Section;
import owmii.lib.client.wiki.page.panel.Panel;
import owmii.lib.registry.IRegistryObject;

public class ItemPanel<T extends IItemProvider>
extends Panel {
    private final IItemProvider[] items;
    private int currItem;
    @OnlyIn(value=Dist.CLIENT)
    private IconButton nextItem = IconButton.EMPTY;
    @OnlyIn(value=Dist.CLIENT)
    private IconButton prevItem = IconButton.EMPTY;

    public ItemPanel(Section parent) {
        this(parent.getEntry().getStack().func_77973_b(), parent);
    }

    public ItemPanel(T item, Section parent) {
        this(ItemPanel.getSiblings(item), parent);
    }

    public ItemPanel(List<T> items, Section parent) {
        this(items.toArray(new IItemProvider[0]), parent);
    }

    public ItemPanel(IItemProvider[] items, Section parent) {
        super("", parent);
        this.items = items;
    }

    protected static IItemProvider[] getSiblings(IItemProvider item) {
        if (item.equals(Items.field_190931_a)) {
            return new IItemProvider[0];
        }
        if (item instanceof IRegistryObject) {
            IRegistryObject object = (IRegistryObject)item;
            ArrayList list = Lists.newArrayList(object.getSiblings());
            return list.toArray(new IItemProvider[0]);
        }
        return new IItemProvider[]{item};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void init(int x, int y, WikiScreen screen) {
        super.init(x, y, screen);
        this.nextItem = screen.addButton2(new IconButton(x + 139 - 28, y + 26, Texture.WIKI_ITM_NEXT, button -> {
            if (this.currItem < this.items.length - 1) {
                ++this.currItem;
                screen.setPanel(this);
                MC.open(screen);
            }
        }, screen));
        this.prevItem = screen.addButton2(new IconButton(x + 69 - 28, y + 26, Texture.WIKI_ITM_PREV, button -> {
            if (this.currItem > 0) {
                --this.currItem;
                screen.setPanel(this);
                MC.open(screen);
            }
        }, screen));
        this.refresh();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void refresh() {
        super.refresh();
        this.nextItem.field_230694_p_ = this.currItem < this.items.length - 1;
        this.prevItem.field_230694_p_ = this.currItem > 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack matrix, int x, int y, int mx, int my, float pt, FontRenderer font, WikiScreen screen) {
        ItemStack stack = new ItemStack(this.getItem());
        if (Texture.WIKI_BIG_FRM.isMouseOver(x + 80 - 21, y + 10, mx, my)) {
            screen.hoveredStack = stack;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)(x + 4) + 80.5f - 21.0f), (float)(y + 4 + 10), (float)0.0f);
        Texture.WIKI_BIG_FRM.draw(matrix, -4, -4);
        RenderSystem.scaled((double)2.1, (double)2.1, (double)1.0);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, 0, 0);
        RenderSystem.popMatrix();
        String s = stack.func_200301_q().getString();
        font.func_238421_b_(matrix, s, (float)x + 80.5f - (float)font.func_78256_a(s) / 2.0f, (float)(y + 61), 2965320);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseScrolled(double mouseX, double mouseY, double i) {
        if (i == -1.0 && this.nextItem.field_230694_p_) {
            this.nextItem.func_230930_b_();
            return true;
        }
        if (i == 1.0 && this.prevItem.field_230694_p_) {
            this.prevItem.func_230930_b_();
            return true;
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClose() {
        this.currItem = 0;
    }

    public IItemProvider getItem() {
        return this.items[this.currItem].func_199767_j();
    }
}

