/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.logistics;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;

public final class SidedStorage<T> {
    private final T nullValue;
    private final EnumMap<Direction, T> sidedValues;

    private SidedStorage(T nullValue, EnumMap<Direction, T> sidedValues) {
        this.nullValue = nullValue;
        this.sidedValues = sidedValues;
    }

    public static <T> SidedStorage<T> create(SideSupplier<T> supplier) {
        return new SidedStorage<T>(supplier.get(null), Arrays.stream(Direction.values()).collect(Collectors.toMap(side -> side, supplier::get, (a, b) -> b, () -> new EnumMap(Direction.class))));
    }

    public T get(@Nullable Direction side) {
        if (side == null) {
            return this.nullValue;
        }
        return this.sidedValues.get(side);
    }

    public Stream<T> stream() {
        return Stream.concat(Stream.of(this.nullValue), this.sidedValues.values().stream());
    }

    @FunctionalInterface
    public static interface SideSupplier<T> {
        public T get(@Nullable Direction var1);
    }
}

