/*
 * Decompiled with CFR 0.152.
 */
package net.codersdownunder.lootbagmod.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber
public class LootBagConfig {
    public static final String MOB_DROPS = "Mob Drops";
    public static final String BLACK_WHITE_LISTS = "Black And White Lists";
    public static final String MISC = "Misc";
    public static final String DEBUG = "Debug/Modpack tools";
    public static final String TAG_LIST = "Tag List";
    public static final String MOD_LIST = "Mod List";
    public static final String CONTAINS_LIST = "Contains List";
    private static List<String> BlackListList = Lists.newArrayList((Object[])new String[]{"lootbagmod:lootbag", "minecraft:air", "minecraft:command_block", "minecraft:structure_block", "minecraft:knowledge_book", "minecraft:chain_command_block", "minecraft:repeating_command_block", "minecraft:barrier", "minecraft:enchanted_book", "minecraft:written_book", "minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:spawn_egg", "minecraft:structure_void", "minecraft:mob_spawner", "minecraft:bedrock"});
    private static List<String> WhiteListList = Lists.newArrayList((Object[])new String[]{"minecraft:stone", "minecraft:nether_star"});
    private static List<String> TagList = Lists.newArrayList((Object[])new String[]{"minecraft:planks"});
    private static List<String> MobListList = Lists.newArrayList((Object[])new String[]{"minecraft:blaze", "minecraft:cave_spider", "minecraft:creeper", "minecraft:drowned", "minecraft:elder_guardian", "minecraft:enderman", "minecraft:endermite", "minecraft:evoker"});
    private static List<String> ModNames = Lists.newArrayList((Object[])new String[]{"tconstruct"});
    private static List<String> ContainsListValues = Lists.newArrayList((Object[])new String[]{"apples", "creative"});
    public static ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> BlackList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> WhiteList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> TagsList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> MobList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> ModName;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> ContainsList;
    public static ForgeConfigSpec.BooleanValue EnableWhitelist;
    public static ForgeConfigSpec.BooleanValue EntityName;
    public static ForgeConfigSpec.BooleanValue ItemsDropped;
    public static ForgeConfigSpec.BooleanValue ItemsDroppedChat;
    public static ForgeConfigSpec.BooleanValue ItemsInInventory;
    public static ForgeConfigSpec.BooleanValue EnableContainsList;
    public static ForgeConfigSpec.IntValue StackSize;
    public static ForgeConfigSpec.IntValue Drops;
    public static ForgeConfigSpec.IntValue DropChance;

    public static void init(ForgeConfigSpec.Builder server, ForgeConfigSpec.Builder client) {
        client.push(MISC);
        StackSize = client.comment("Maximum possible stack size for dropped items").defineInRange("stacksize", 15, 1, 64);
        Drops = client.comment("How many items drop when a loot bag is used").defineInRange("dropamount", 10, 1, 1000);
        ItemsInInventory = client.comment("Try to place items into inventory before dropping them onto the ground").define("itemsininventory", true);
        client.pop();
        client.push(DEBUG);
        EntityName = client.comment("Print mobs registry name to chat and log file when killed").define("entityname", false);
        ItemsDropped = client.comment("Print list of items dropped to debug.log").define("itemsdropped", false);
        ItemsDroppedChat = client.comment("Print list of items dropped to the chat").define("itemsdroppedchat", false);
        client.pop();
        client.push(BLACK_WHITE_LISTS);
        EnableWhitelist = client.comment("Use the whitelist").define("enablewhitelist", false);
        BlackList = client.comment("BlackList (Syntax \"minecraft or modid : item or block name\"; example \"minecraft:air\" or \"lootbagmod:lootbag\")").define("blacklist", BlackListList);
        WhiteList = client.comment("WhiteList Syntax \"minecraft or modid : item or block name\"; example minecraft:air or lootbagmod:lootbag)").define("whitelist", WhiteListList);
        client.pop();
        client.push(TAG_LIST);
        TagsList = client.comment("TagList (Syntax \"minecraft, forge or modid : tag name\"; example \"minecraft:planks\" or \"forge:planks\")").define("taglist", TagList);
        client.pop();
        client.push(MOD_LIST);
        ModName = client.comment("Mod black/whitelist (Syntax \" modid \")").define("modlist", ModNames);
        client.pop();
        client.push(CONTAINS_LIST);
        ContainsList = client.comment("Contains List (Synyax \"word\")").define("contains", ContainsListValues);
        EnableContainsList = client.comment("Enable Contains List").define("enablecontains", false);
        client.pop();
        client.push(MOB_DROPS);
        MobList = client.comment("Mob drops list (Syntax \" minecraft or modname : mobregistryname \")").define("mobdropslist", MobListList);
        DropChance = client.comment("Loot Bag drop chance from mobs (the higher the number the more common they are)").defineInRange("dropchance", 10, 1, 100);
        client.pop();
        CLIENT_CONFIG = client.build();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
    }
}

