/*
 * Decompiled with CFR 0.152.
 */
package net.codersdownunder.lootbagmod.events;

import java.util.List;
import java.util.Random;
import net.codersdownunder.lootbagmod.LootBagMod;
import net.codersdownunder.lootbagmod.config.LootBagConfig;
import net.codersdownunder.lootbagmod.init.ItemInit;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lootbagmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LootHandler {
    private static final Random rand = new Random();

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent evt) {
        String prefix = "minecraft:chests/";
        String name = evt.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "stronghold_crossing": 
                case "stronghold_library": 
                case "stronghold_corridor": {
                    evt.getTable().addPool(LootHandler.getInjectPool(file));
                    break;
                }
            }
        }
    }

    public static LootPool getInjectPool(String entryName) {
        return LootPool.m_79043_().m_79076_(LootHandler.getInjectEntry(entryName)).name("lootbagmod_inject").m_79082_();
    }

    private static LootPoolEntryContainer.Builder getInjectEntry(String name) {
        ResourceLocation table = new ResourceLocation("lootbagmod", "inject/" + name);
        return LootTableReference.m_79776_((ResourceLocation)table);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMobDrops(LivingDropsEvent event) {
        if (event.getEntity().f_19853_.f_46443_) return;
        String entityName = event.getEntity().m_6095_().getRegistryName().toString();
        int dropchance = rand.nextInt(100);
        int testchance = (Integer)LootBagConfig.DropChance.get();
        if (((List)LootBagConfig.MobList.get()).contains(entityName)) {
            if (event.getLootingLevel() != 0) {
                if (dropchance / event.getLootingLevel() / 1 <= testchance) {
                    event.getDrops().add(new ItemEntity(event.getEntityLiving().f_19853_, event.getEntityLiving().f_19790_, event.getEntityLiving().f_19791_, event.getEntityLiving().f_19792_, new ItemStack((ItemLike)ItemInit.LOOTBAG.get(), 1)));
                }
            } else if (dropchance <= testchance) {
                event.getDrops().add(new ItemEntity(event.getEntityLiving().f_19853_, event.getEntityLiving().f_19790_, event.getEntityLiving().f_19791_, event.getEntityLiving().f_19792_, new ItemStack((ItemLike)ItemInit.LOOTBAG.get(), 1)));
            }
            if (!((Boolean)LootBagConfig.EntityName.get()).booleanValue()) return;
            LootBagMod.LOGGER.info(entityName);
            LootBagMod.LOGGER.info("Drop Chance: " + dropchance + "   " + testchance);
            LootBagMod.LOGGER.info("Mob was selected from list");
            try {
                if (event.getSource().m_7639_() == null || !(event.getSource().m_7639_() instanceof Player)) return;
                Player player = (Player)event.getSource().m_7639_();
                event.getSource().m_7639_().m_6352_(Component.m_130674_((String)("entityname: " + entityName)), player.m_142081_());
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        if (!((Boolean)LootBagConfig.EntityName.get()).booleanValue()) return;
        LootBagMod.LOGGER.info(entityName);
        LootBagMod.LOGGER.info("Drop Chance: " + dropchance + "   " + testchance);
        LootBagMod.LOGGER.info("Mob wasn't selected from list");
        try {
            if (event.getSource().m_7639_() == null || !(event.getSource().m_7639_() instanceof Player)) return;
            Player player = (Player)event.getSource().m_7639_();
            event.getSource().m_7639_().m_6352_(Component.m_130674_((String)("entityname: " + entityName)), player.m_142081_());
            return;
        }
        catch (Exception e) {
            return;
        }
    }
}

