/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.data.NewChestData;
import noobanidus.mods.lootr.tiles.ILootTile;

public class BooleanData
extends WorldSavedData {
    private Int2ObjectOpenHashMap<Long2BooleanOpenHashMap> lootMap = new Int2ObjectOpenHashMap();
    private static final String ID = "Lootr-BooleanSaveData";

    public BooleanData() {
        super(ID);
    }

    public BooleanData(String name) {
        super(name);
    }

    public boolean isLootChest(DimensionType dim, BlockPos pos) {
        return this.isLootChest(dim.func_186068_a(), pos.func_218275_a());
    }

    private boolean isLootChest(int dim, long pos) {
        Long2BooleanOpenHashMap dimMap = this.getDimension(dim);
        return dimMap.get(pos);
    }

    public void markLootChest(DimensionType dim, BlockPos pos) {
        this.markLootChest(dim.func_186068_a(), pos.func_218275_a());
    }

    private void markLootChest(int dim, long pos) {
        Long2BooleanOpenHashMap dimMap = this.getDimension(dim);
        dimMap.put(pos, true);
        this.func_76185_a();
    }

    public void deleteLootChest(DimensionType dim, BlockPos pos) {
        this.deleteLootChest(dim.func_186068_a(), pos.func_218275_a());
    }

    private void deleteLootChest(int dim, long pos) {
        Long2BooleanOpenHashMap dimMap = this.getDimension(dim);
        dimMap.remove(pos);
        this.func_76185_a();
    }

    private Long2BooleanOpenHashMap getDimension(int dim) {
        return (Long2BooleanOpenHashMap)this.lootMap.computeIfAbsent(dim, o -> {
            Long2BooleanOpenHashMap map = new Long2BooleanOpenHashMap();
            map.defaultReturnValue(false);
            return map;
        });
    }

    public void func_76184_a(CompoundNBT compound) {
        this.lootMap.clear();
        for (String key : compound.func_150296_c()) {
            byte[] values;
            long[] positions = compound.func_74775_l(key).func_197645_o("positions");
            if (positions.length != (values = compound.func_74775_l(key).func_74770_j("values")).length) {
                throw new IllegalStateException("Illegal state: positions(" + positions.length + ") does not match values (" + values.length + ")");
            }
            Long2BooleanOpenHashMap dimMap = this.getDimension(Integer.parseInt(key));
            for (int i = 0; i < positions.length; ++i) {
                dimMap.put(positions[i], values[i] == 1);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        for (Int2ObjectMap.Entry entry : this.lootMap.int2ObjectEntrySet()) {
            LongArrayList longs = new LongArrayList();
            ByteArrayList bools = new ByteArrayList();
            for (Long2BooleanMap.Entry sub : ((Long2BooleanOpenHashMap)entry.getValue()).long2BooleanEntrySet()) {
                longs.add(sub.getLongKey());
                bools.add(sub.getBooleanValue() ? (byte)1 : 0);
            }
            CompoundNBT thisEntry = new CompoundNBT();
            thisEntry.func_202168_c("positions", (List)longs);
            thisEntry.func_74773_a("values", bools.toArray(new byte[0]));
            compound.func_218657_a(String.valueOf(entry.getIntKey()), (INBT)thisEntry);
        }
        return compound;
    }

    private static ServerWorld getServerWorld() {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_);
    }

    private static BooleanData getInstance() {
        return (BooleanData)BooleanData.getServerWorld().func_217481_x().func_215752_a(BooleanData::new, ID);
    }

    public static boolean isLootChest(IWorld world, BlockPos pos) {
        if (world.func_201670_d()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof ILootTile) {
                return ((ILootTile)te).isSpecialLootChest();
            }
            return false;
        }
        return BooleanData.getInstance().isLootChest(world.func_201675_m().func_186058_p(), pos);
    }

    public static void markLootChest(IWorld world, BlockPos pos) {
        if (world.func_201670_d()) {
            return;
        }
        BooleanData data = BooleanData.getInstance();
        if (data.isLootChest(world.func_201675_m().func_186058_p(), pos)) {
            return;
        }
        data.markLootChest(world.func_201675_m().func_186058_p(), pos);
        BooleanData.getServerWorld().func_217481_x().func_212775_b();
    }

    public static void deleteLootChest(IWorld world, BlockPos pos) {
        if (world.func_201670_d()) {
            return;
        }
        BooleanData data = BooleanData.getInstance();
        if (!data.isLootChest(world.func_201675_m().func_186058_p(), pos)) {
            return;
        }
        data.deleteLootChest(world.func_201675_m().func_186058_p(), pos);
        NewChestData.wipeInventory(world, pos);
        BooleanData.getServerWorld().func_217481_x().func_212775_b();
    }
}

