/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.tiles.ILootTile;

public class NewChestData
extends WorldSavedData {
    private BlockPos pos;
    private int dimension;
    private Map<UUID, SpecialChestInventory> inventories = new HashMap<UUID, SpecialChestInventory>();

    public static String ID(int dimension, BlockPos pos) {
        return "Lootr-chests-" + dimension + "-" + pos.func_218275_a();
    }

    public NewChestData(int dimension, BlockPos pos) {
        super(NewChestData.ID(dimension, pos));
        this.pos = pos;
        this.dimension = dimension;
    }

    private void setInventory(ServerPlayerEntity player, SpecialChestInventory inventory) {
        inventory.filled();
        this.inventories.put(player.func_110124_au(), inventory);
        this.func_76185_a();
    }

    @Nullable
    private SpecialChestInventory getInventory(ServerPlayerEntity player) {
        World world;
        SpecialChestInventory thisChest = this.inventories.get(player.func_110124_au());
        if (thisChest != null) {
            return thisChest;
        }
        if (player.field_70170_p.func_201675_m().func_186058_p().func_186068_a() != this.dimension) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return null;
            }
            DimensionType type = DimensionType.func_186069_a((int)this.dimension);
            if (type == null) {
                return null;
            }
            world = server.func_71218_a(type);
        } else {
            world = player.field_70170_p;
        }
        TileEntity te = world.func_175625_s(this.pos);
        if (!(te instanceof ILootTile)) {
            return null;
        }
        LockableLootTileEntity tile = (LockableLootTileEntity)te;
        NonNullList items = NonNullList.func_191197_a((int)tile.func_70302_i_(), (Object)ItemStack.field_190927_a);
        return new SpecialChestInventory((NonNullList<ItemStack>)items, tile.func_145748_c_(), true, this.pos);
    }

    public void func_76184_a(CompoundNBT compound) {
        this.inventories.clear();
        this.pos = BlockPos.func_218283_e((long)compound.func_74763_f("position"));
        this.dimension = compound.func_74762_e("dimension");
        ListNBT compounds = compound.func_150295_c("inventories", 10);
        for (int i = 0; i < compounds.size(); ++i) {
            CompoundNBT thisTag = compounds.func_150305_b(i);
            CompoundNBT items = thisTag.func_74775_l("chest");
            String name = thisTag.func_74779_i("name");
            UUID uuid = thisTag.func_186857_a("uuid");
            this.inventories.put(uuid, new SpecialChestInventory(items, name, this.pos));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74772_a("position", this.pos.func_218275_a());
        compound.func_74768_a("dimension", this.dimension);
        ListNBT compounds = new ListNBT();
        for (Map.Entry<UUID, SpecialChestInventory> entry : this.inventories.entrySet()) {
            CompoundNBT thisTag = new CompoundNBT();
            thisTag.func_186854_a("uuid", entry.getKey());
            thisTag.func_218657_a("chest", (INBT)entry.getValue().writeItems());
            thisTag.func_74778_a("name", entry.getValue().writeName());
            compounds.add((Object)thisTag);
        }
        compound.func_218657_a("inventories", (INBT)compounds);
        return compound;
    }

    public void clear() {
        this.inventories.clear();
    }

    private static ServerWorld getServerWorld() {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_);
    }

    private static NewChestData getInstance(IWorld world, BlockPos pos) {
        int dimension = world.func_201675_m().func_186058_p().func_186068_a();
        return (NewChestData)NewChestData.getServerWorld().func_217481_x().func_215752_a(() -> new NewChestData(dimension, pos), NewChestData.ID(dimension, pos));
    }

    @Nullable
    public static SpecialChestInventory getInventory(IWorld world, BlockPos pos, ServerPlayerEntity player) {
        NewChestData data = NewChestData.getInstance(world, pos);
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            return null;
        }
        if (!inventory.wasNew()) {
            return inventory;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ILootTile) {
            ILootTile tile = (ILootTile)te;
            tile.fillWithLoot((PlayerEntity)player, inventory);
            data.setInventory(player, inventory);
            tile.markForSync();
        }
        return inventory;
    }

    public static void wipeInventory(IWorld world, BlockPos pos) {
        ServerWorld serverWorld = NewChestData.getServerWorld();
        int dimension = world.func_201675_m().func_186058_p().func_186068_a();
        DimensionSavedDataManager manager = serverWorld.func_217481_x();
        String id = NewChestData.ID(dimension, pos);
        if (!manager.field_212778_c.containsKey(id)) {
            return;
        }
        NewChestData data = (NewChestData)manager.func_215753_b(() -> null, id);
        if (data != null) {
            data.clear();
            data.func_76185_a();
        }
    }

    public class SpecialChestInventory
    implements IInventory,
    INamedContainerProvider {
        private final NonNullList<ItemStack> contents;
        private final ITextComponent name;
        private boolean wasNew;
        private BlockPos pos;

        public SpecialChestInventory(NonNullList<ItemStack> contents, ITextComponent name, boolean wasNew, BlockPos pos) {
            this.contents = contents;
            this.name = name;
            this.wasNew = wasNew;
            this.pos = pos;
        }

        public SpecialChestInventory(CompoundNBT items, String componentAsJSON, BlockPos pos) {
            this.name = ITextComponent.Serializer.func_150699_a((String)componentAsJSON);
            this.contents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)items, this.contents);
            this.wasNew = false;
            this.pos = pos;
        }

        public boolean wasNew() {
            return this.wasNew;
        }

        @Nullable
        public LockableLootTileEntity getTile(World world) {
            if (world == null || world.func_201670_d()) {
                return null;
            }
            TileEntity te = world.func_175625_s(this.pos);
            if (te instanceof ILootTile) {
                return (LockableLootTileEntity)te;
            }
            return null;
        }

        public void filled() {
            this.wasNew = false;
            this.func_70296_d();
        }

        public int func_70302_i_() {
            return 27;
        }

        public boolean func_191420_l() {
            for (ItemStack itemstack : this.contents) {
                if (itemstack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return (ItemStack)this.contents.get(index);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack itemstack = ItemStackHelper.func_188382_a(this.contents, (int)index, (int)count);
            if (!itemstack.func_190926_b()) {
                this.func_70296_d();
            }
            return itemstack;
        }

        public ItemStack func_70304_b(int index) {
            ItemStack result = ItemStackHelper.func_188383_a(this.contents, (int)index);
            if (!result.func_190926_b()) {
                this.func_70296_d();
            }
            return result;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.contents.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.func_70296_d();
        }

        public void func_70296_d() {
            NewChestData.this.func_76185_a();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }

        public void func_174888_l() {
            this.contents.clear();
            this.func_70296_d();
        }

        public ITextComponent func_145748_c_() {
            return this.name;
        }

        @Nullable
        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return ChestContainer.func_216992_a((int)id, (PlayerInventory)inventory, (IInventory)this);
        }

        public void func_174889_b(PlayerEntity player) {
            World world = player.field_70170_p;
            LockableLootTileEntity tile = this.getTile(world);
            if (tile != null) {
                tile.func_174889_b(player);
            }
        }

        public void func_174886_c(PlayerEntity player) {
            this.func_70296_d();
            World world = player.field_70170_p;
            LockableLootTileEntity tile = this.getTile(world);
            if (tile != null) {
                tile.func_174886_c(player);
            }
            ((ServerWorld)world).func_217481_x().func_212775_b();
        }

        public CompoundNBT writeItems() {
            CompoundNBT result = new CompoundNBT();
            return ItemStackHelper.func_191282_a((CompoundNBT)result, this.contents);
        }

        public String writeName() {
            return ITextComponent.Serializer.func_150696_a((ITextComponent)this.name);
        }

        public BlockPos getPos() {
            return this.pos;
        }
    }
}

