/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.tiles;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.BooleanData;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModTiles;
import noobanidus.mods.lootr.tiles.ILootTile;
import noobanidus.mods.lootr.tiles.SpecialLootChestTile;

public class SpecialLootBarrelTile
extends BarrelTileEntity
implements ITickableTileEntity,
ILootTile {
    private int specialNumPlayersUsingBarrel;
    private Random random = new Random();
    private ResourceLocation savedLootTable = null;
    private long seed = -1L;
    private boolean synchronised = false;

    public SpecialLootBarrelTile() {
        super(ModTiles.SPECIAL_LOOT_BARREL);
    }

    public void func_189404_a(ResourceLocation lootTableIn, long seedIn) {
        super.func_189404_a(lootTableIn, seedIn);
        this.setLootTable(lootTableIn, seedIn, true);
    }

    public void setLootTable(ResourceLocation lootTableIn, long seedIn, boolean doSync) {
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
        if (doSync) {
            this.markForSync();
        }
    }

    @Override
    public void markForSync() {
        this.synchronised = false;
    }

    @Override
    public boolean isSpecialLootChest() {
        return this.savedLootTable != null;
    }

    protected boolean func_184283_b(CompoundNBT compound) {
        if (this.isSpecialLootChest()) {
            return true;
        }
        return super.func_184283_b(compound);
    }

    protected boolean func_184282_c(CompoundNBT compound) {
        if (this.isSpecialLootChest()) {
            return true;
        }
        return super.func_184282_c(compound);
    }

    public void func_184281_d(@Nullable PlayerEntity player) {
    }

    @Override
    public void fillWithLoot(PlayerEntity player, IInventory inventory) {
        if (this.field_145850_b != null && this.savedLootTable != null && this.field_145850_b.func_73046_m() != null) {
            LootTable loottable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(this.savedLootTable);
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vec3i)this.field_174879_c)).func_216016_a((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? this.random.nextLong() : this.seed);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            }
            loottable.func_216118_a(inventory, builder.func_216022_a(LootParameterSets.field_216261_b));
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("specialLootChest_table"));
        }
        if (compound.func_150297_b("specialLootChest_seed", 4)) {
            this.seed = compound.func_74763_f("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.func_150297_b("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            if (compound.func_150297_b("LootTableSeed", 4)) {
                this.seed = compound.func_74763_f("LootTableSeed");
            }
            this.func_189404_a(this.savedLootTable, this.seed);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        if (this.savedLootTable != null) {
            compound.func_74778_a("specialLootBarrel_table", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.func_74772_a("specialLootBarrel_seed", this.seed);
        }
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        if (this.isSpecialLootChest()) {
            return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.isSpecialLootChest()) {
            return super.getCapability(cap, side);
        }
        return LazyOptional.empty();
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.synchronised && !this.field_145850_b.func_201670_d() && this.isSpecialLootChest()) {
            this.synchronised = true;
            BooleanData.markLootChest((IWorld)this.field_145850_b, this.func_174877_v());
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (state.func_177230_c() == Blocks.field_222422_lK) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)ModBlocks.BARREL.func_176223_P().func_206870_a((IProperty)BarrelBlock.field_220092_a, state.func_177229_b((IProperty)BarrelBlock.field_220092_a))).func_206870_a((IProperty)BarrelBlock.field_220093_b, state.func_177229_b((IProperty)BarrelBlock.field_220093_b)));
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c);
                if (te instanceof SpecialLootBarrelTile && te != this) {
                    ((SpecialLootBarrelTile)te).setLootTable(this.savedLootTable, this.seed, false);
                    BooleanData.markLootChest((IWorld)this.field_145850_b, this.func_174877_v());
                } else if (te == this) {
                    Lootr.LOG.error("Replaced barrel tile but was myself.");
                }
            } else {
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 8);
            }
        }
    }

    public void func_213962_h() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        this.specialNumPlayersUsingBarrel = SpecialLootChestTile.calculatePlayersUsing(this.field_145850_b, (LockableTileEntity)this, x, y, z);
        if (this.specialNumPlayersUsingBarrel > 0) {
            this.scheduleTick();
        } else {
            BlockState state = this.func_195044_w();
            if (state.func_177230_c() != ModBlocks.BARREL && state.func_177230_c() != Blocks.field_222422_lK) {
                this.func_145843_s();
                return;
            }
            boolean open = (Boolean)state.func_177229_b((IProperty)BarrelBlock.field_220093_b);
            if (open) {
                this.playSound(state, SoundEvents.field_219601_N);
                this.setOpenProperty(state, false);
            }
        }
    }

    private void setOpenProperty(BlockState state, boolean open) {
        this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)BarrelBlock.field_220093_b, (Comparable)Boolean.valueOf(open)), 3);
    }

    private void playSound(BlockState state, SoundEvent sound) {
        Vec3i dir = ((Direction)state.func_177229_b((IProperty)BarrelBlock.field_220092_a)).func_176730_m();
        double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.func_177958_n() / 2.0;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)dir.func_177956_o() / 2.0;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.func_177952_p() / 2.0;
        this.field_145850_b.func_184148_a(null, x, y, z, sound, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    private void scheduleTick() {
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.specialNumPlayersUsingBarrel < 0) {
                this.specialNumPlayersUsingBarrel = 0;
            }
            ++this.specialNumPlayersUsingBarrel;
            BlockState state = this.func_195044_w();
            boolean open = (Boolean)state.func_177229_b((IProperty)BarrelBlock.field_220093_b);
            if (!open) {
                this.playSound(state, SoundEvents.field_219602_O);
                this.setOpenProperty(state, true);
            }
            this.scheduleTick();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.specialNumPlayersUsingBarrel;
        }
    }
}

