/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.tiles;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.BooleanData;
import noobanidus.mods.lootr.data.NewChestData;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModTiles;
import noobanidus.mods.lootr.tiles.ILootTile;

public class SpecialLootChestTile
extends ChestTileEntity
implements ILootTile {
    private int ticksSinceSync;
    private int specialNumPlayersUsingChest;
    private Random random = new Random();
    private ResourceLocation savedLootTable = null;
    private long seed = -1L;
    private boolean synchronised = false;

    public SpecialLootChestTile() {
        super(ModTiles.SPECIAL_LOOT_CHEST);
    }

    public SpecialLootChestTile(TileEntityType<?> tile) {
        super(tile);
    }

    public void func_189404_a(ResourceLocation lootTableIn, long seedIn) {
        super.func_189404_a(lootTableIn, seedIn);
        this.setLootTable(lootTableIn, seedIn, true);
    }

    public void setLootTable(ResourceLocation lootTableIn, long seedIn, boolean doSync) {
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
        if (doSync) {
            this.markForSync();
        }
    }

    @Override
    public void markForSync() {
        this.synchronised = false;
    }

    @Override
    public boolean isSpecialLootChest() {
        return this.savedLootTable != null;
    }

    protected boolean func_184283_b(CompoundNBT compound) {
        if (this.isSpecialLootChest()) {
            return true;
        }
        return super.func_184283_b(compound);
    }

    protected boolean func_184282_c(CompoundNBT compound) {
        if (this.isSpecialLootChest()) {
            return true;
        }
        return super.func_184282_c(compound);
    }

    public void func_184281_d(@Nullable PlayerEntity player) {
    }

    @Override
    public void fillWithLoot(PlayerEntity player, IInventory inventory) {
        if (this.field_145850_b != null && this.savedLootTable != null && this.field_145850_b.func_73046_m() != null) {
            LootTable loottable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(this.savedLootTable);
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vec3i)this.field_174879_c)).func_216016_a((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? this.random.nextLong() : this.seed);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            }
            loottable.func_216118_a(inventory, builder.func_216022_a(LootParameterSets.field_216261_b));
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("specialLootChest_table"));
        }
        if (compound.func_150297_b("specialLootChest_seed", 4)) {
            this.seed = compound.func_74763_f("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.func_150297_b("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            if (this.seed == 0L && compound.func_150297_b("LootTableSeed", 4)) {
                this.seed = compound.func_74763_f("LootTableSeed");
            }
            this.func_189404_a(this.savedLootTable, this.seed);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        if (this.savedLootTable != null) {
            compound.func_74778_a("specialLootChest_table", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.func_74772_a("specialLootChest_seed", this.seed);
        }
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        if (this.isSpecialLootChest()) {
            return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.isSpecialLootChest()) {
            return super.getCapability(cap, side);
        }
        return LazyOptional.empty();
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.synchronised && !this.field_145850_b.func_201670_d() && this.isSpecialLootChest()) {
            boolean trapped;
            this.synchronised = true;
            BooleanData.markLootChest((IWorld)this.field_145850_b, this.func_174877_v());
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            boolean bl = trapped = state.func_177230_c() == Blocks.field_150447_bR;
            if (state.func_177230_c() == Blocks.field_150486_ae || state.func_177230_c() == Blocks.field_150447_bR) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)(trapped ? ModBlocks.TRAPPED_CHEST : ModBlocks.CHEST).func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, state.func_177229_b((IProperty)ChestBlock.field_176459_a))).func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE));
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c);
                if (te instanceof SpecialLootChestTile && te != this) {
                    ((SpecialLootChestTile)te).setLootTable(this.savedLootTable, this.seed, false);
                    BooleanData.markLootChest((IWorld)this.field_145850_b, this.func_174877_v());
                } else if (te == this) {
                    Lootr.LOG.error("Replaced chest tile but it was myself");
                }
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 8);
        }
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        this.specialNumPlayersUsingChest = SpecialLootChestTile.calculatePlayersUsingSync(this.field_145850_b, (LockableTileEntity)this, this.ticksSinceSync, i, j, k, this.specialNumPlayersUsingChest);
        this.field_145986_n = this.field_145989_m;
        if (this.specialNumPlayersUsingChest > 0 && this.field_145989_m == 0.0f) {
            this.playSound(SoundEvents.field_187657_V);
        }
        if (this.specialNumPlayersUsingChest == 0 && this.field_145989_m > 0.0f || this.specialNumPlayersUsingChest > 0 && this.field_145989_m < 1.0f) {
            float f1 = this.field_145989_m;
            this.field_145989_m = this.specialNumPlayersUsingChest > 0 ? (this.field_145989_m += 0.1f) : (this.field_145989_m -= 0.1f);
            if (this.field_145989_m > 1.0f) {
                this.field_145989_m = 1.0f;
            }
            if (this.field_145989_m < 0.5f && f1 >= 0.5f) {
                this.playSound(SoundEvents.field_187651_T);
            }
            if (this.field_145989_m < 0.0f) {
                this.field_145989_m = 0.0f;
            }
        }
    }

    private void playSound(SoundEvent soundIn) {
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static int calculatePlayersUsingSync(World world, LockableTileEntity tile, int ticksSinceSync, int x, int y, int z, int numPlayersUsing) {
        if (!world.field_72995_K && numPlayersUsing != 0 && (ticksSinceSync + x + y + z) % 200 == 0) {
            numPlayersUsing = SpecialLootChestTile.calculatePlayersUsing(world, tile, x, y, z);
        }
        return numPlayersUsing;
    }

    public static int calculatePlayersUsing(World world, LockableTileEntity tile, int x, int y, int z) {
        int i = 0;
        for (PlayerEntity playerentity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            IInventory inv;
            if (!(playerentity.field_71070_bA instanceof ChestContainer) || (!((inv = ((ChestContainer)playerentity.field_71070_bA).func_85151_d()) instanceof NewChestData.SpecialChestInventory) || !((NewChestData.SpecialChestInventory)inv).getPos().equals((Object)tile.func_174877_v())) && inv != tile && (!(inv instanceof DoubleSidedInventory) || !((DoubleSidedInventory)inv).func_90010_a((IInventory)tile))) continue;
            ++i;
        }
        return i;
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.specialNumPlayersUsingChest < 0) {
                this.specialNumPlayersUsingChest = 0;
            }
            ++this.specialNumPlayersUsingChest;
            this.func_195482_p();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.specialNumPlayersUsingChest;
            this.func_195482_p();
        }
    }

    protected void func_195482_p() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof ChestBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.specialNumPlayersUsingChest);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.specialNumPlayersUsingChest = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }
}

