/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.TrappedChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import noobanidus.mods.lootr.data.BooleanData;
import noobanidus.mods.lootr.data.NewChestData;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.tiles.ILootTile;

public class ChestUtil {
    public static void handleLootChestReplaced(World world, BlockPos pos, BlockState oldState, BlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        if (oldState.func_177230_c() == Blocks.field_222422_lK && newState.func_177230_c() == ModBlocks.BARREL) {
            return;
        }
        BooleanData.deleteLootChest((IWorld)world, pos);
    }

    public static boolean handleLootChest(World world, BlockPos pos, PlayerEntity player) {
        BlockState state;
        if (world.func_201670_d()) {
            return false;
        }
        Object provider = ChestUtil.isLootChest((IWorld)world, pos) ? ChestUtil.getLootContainer((IWorld)world, pos, (ServerPlayerEntity)player) : ((state = world.func_180495_p(pos)).func_177230_c() == Blocks.field_150486_ae || state.func_177230_c() == ModBlocks.CHEST ? ((ChestBlock)Blocks.field_150486_ae).func_220052_b(state, world, pos) : (state.func_177230_c() == Blocks.field_150447_bR ? ((TrappedChestBlock)Blocks.field_150447_bR).func_220052_b(state, world, pos) : (state.func_177230_c() == Blocks.field_222422_lK || state.func_177230_c() == ModBlocks.BARREL ? ((ContainerBlock)Blocks.field_222422_lK).func_220052_b(state, world, pos) : (state.func_177230_c() instanceof ChestBlock ? ((ChestBlock)state.func_177230_c()).func_220052_b(state, world, pos) : null))));
        if (provider != null) {
            player.func_213829_a(provider);
        }
        return true;
    }

    public static boolean isLootChest(IWorld world, BlockPos pos, Direction offset) {
        if (ChestUtil.isLootChest(world, pos)) {
            return true;
        }
        return ChestUtil.isLootChest(world, pos.func_177972_a(offset.func_176734_d()));
    }

    public static boolean isLootChest(BlockItemUseContext context, Direction direction) {
        if (ChestUtil.isLootChest((IWorld)context.func_195991_k(), context.func_195995_a())) {
            return true;
        }
        return ChestUtil.isLootChest((IWorld)context.func_195991_k(), context.func_195995_a().func_177972_a(direction));
    }

    public static boolean isLootChest(IWorld world, BlockPos pos) {
        if (!world.func_201670_d()) {
            return BooleanData.isLootChest(world, pos);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ILootTile) {
            return ((ILootTile)te).isSpecialLootChest();
        }
        return false;
    }

    @Nullable
    public static INamedContainerProvider getLootContainer(IWorld world, BlockPos pos, ServerPlayerEntity player) {
        return NewChestData.getInventory(world, pos, player);
    }

    public static enum ReturnType {
        TRUE,
        FALSE,
        SKIP;

    }
}

