/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.world;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.MineshaftPieces;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.BooleanData;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.tiles.ILootTile;

public class CorridorReplacement {
    public static boolean generateChest(MineshaftPieces.Corridor corridor, IWorld worldIn, MutableBoundingBox structurebb, Random randomIn, int x, int y, int z, ResourceLocation loot) {
        BlockPos blockpos = new BlockPos(corridor.func_74865_a(x, z), corridor.func_74862_a(y), corridor.func_74873_b(x, z));
        if (structurebb.func_175898_b((Vec3i)blockpos) && worldIn.func_180495_p(blockpos).isAir((IBlockReader)worldIn, blockpos) && !worldIn.func_180495_p(blockpos.func_177977_b()).isAir((IBlockReader)worldIn, blockpos.func_177977_b())) {
            if (((Boolean)ConfigManager.CONVERT_MINESHAFTS.get()).booleanValue()) {
                BlockState blockstate = ModBlocks.CHEST.func_176223_P();
                corridor.func_175811_a(worldIn, blockstate, x, y, z, structurebb);
                CorridorReplacement.setLootTable((IBlockReader)worldIn, randomIn, blockpos, loot);
            } else {
                BlockState blockstate = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)(randomIn.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
                corridor.func_175811_a(worldIn, blockstate, x, y, z, structurebb);
                ChestMinecartEntity chestminecartentity = new ChestMinecartEntity(worldIn.func_201672_e(), (double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f));
                chestminecartentity.func_184289_a(loot, randomIn.nextLong());
                worldIn.func_217376_c((Entity)chestminecartentity);
            }
            return true;
        }
        return false;
    }

    public static void setLootTable(IBlockReader reader, Random rand, BlockPos pos, ResourceLocation lootTableIn) {
        TileEntity tileentity = reader.func_175625_s(pos);
        if (tileentity instanceof LockableLootTileEntity) {
            ((LockableLootTileEntity)tileentity).func_189404_a(lootTableIn, rand.nextLong());
            if (reader instanceof IWorld && tileentity instanceof ILootTile) {
                IWorld world = (IWorld)reader;
                BooleanData.markLootChest(world, pos);
            }
        }
    }
}

