/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TrappedChestTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import noobanidus.mods.lootr.data.NewChestData;
import noobanidus.mods.lootr.events.HandleBreak;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.tiles.ILootTile;
import noobanidus.mods.lootr.util.TickManager;

public class ChestUtil {
    public static Random random = new Random();
    public static Set<Class<?>> tileClasses = new HashSet();
    private static Set<Block> replacements = Sets.newHashSet((Object[])new Block[]{Blocks.field_150486_ae, Blocks.field_150447_bR, Blocks.field_222422_lK});

    public static boolean handleLootChest(World world, BlockPos pos, PlayerEntity player) {
        if (world.func_201670_d()) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ILootTile) {
            NewChestData.SpecialChestInventory provider = NewChestData.getInventory(world, pos, (ServerPlayerEntity)player, ((ILootTile)te)::fillWithLoot);
            player.func_213829_a((INamedContainerProvider)provider);
            return true;
        }
        return false;
    }

    public static void setLootTable(LockableLootTileEntity tile, ResourceLocation table) {
        long seed = random.nextLong();
        if (table == null) {
            tile.field_184284_m = null;
            tile.field_184285_n = -1L;
            return;
        }
        tile.field_184284_m = table;
        tile.field_184285_n = seed;
        if (ChestUtil.isTileClass((TileEntity)tile)) {
            ChestUtil.addNewTile(tile, table, seed);
        } else if (tile instanceof ILootTile) {
            ILootTile te = (ILootTile)tile;
            te.setTable(table);
            te.setSeed(seed);
            TickManager.trackTile((TileEntity)tile, table);
        }
    }

    public static void setLootTableStatic(IBlockReader reader, Random random, BlockPos pos, ResourceLocation location) {
        TileEntity te = reader.func_175625_s(pos);
        if (ChestUtil.isTileClass(te)) {
            if (reader instanceof IWorld) {
                IWorld writer = (IWorld)reader;
                BlockState stateAt = reader.func_180495_p(pos);
                if (ChestUtil.hasReplacement(stateAt) && ChestUtil.isTileClass(te)) {
                    BlockState state = ChestUtil.getReplacement(stateAt.func_177230_c(), stateAt);
                    IChunk chunk = writer.func_217349_x(pos);
                    chunk.func_177425_e(pos);
                    writer.func_180501_a(pos, state, 2);
                    te = reader.func_175625_s(pos);
                    if (te instanceof ILootTile) {
                        ((ILootTile)te).setTable(location);
                        ((ILootTile)te).setSeed(random.nextLong());
                        TickManager.trackTile(te, location, writer.func_201675_m().func_186058_p());
                    }
                }
            }
        } else if (te instanceof LockableLootTileEntity) {
            ((LockableLootTileEntity)te).field_184284_m = location;
            ((LockableLootTileEntity)te).field_184285_n = random.nextLong();
        }
    }

    public static boolean checkLootAndRead(LockableLootTileEntity tile, CompoundNBT tag) {
        ListNBT items;
        if (tile instanceof ILootTile) {
            return false;
        }
        if (tag.func_150297_b("Items", 9) && (items = tag.func_150295_c("Items", 10)).size() > 0) {
            return false;
        }
        if (tag.func_150297_b("LootTable", 8)) {
            long seed;
            ResourceLocation table = new ResourceLocation(tag.func_74779_i("LootTable"));
            tile.field_184285_n = seed = tag.func_74763_f("LootTableSeed");
            tile.field_184284_m = table;
            if (ChestUtil.isTileClass((TileEntity)tile)) {
                ChestUtil.addNewTile(tile, table, seed);
            }
            return true;
        }
        return false;
    }

    private static void addNewTile(LockableLootTileEntity tile, ResourceLocation table, long seed) {
        DimensionType dim = null;
        if (tile.func_145831_w() != null) {
            dim = tile.func_145831_w().func_201675_m().func_186058_p();
        }
        TickManager.addTicker((TileEntity)tile, tile.func_174877_v(), dim, table, seed);
    }

    public static boolean hasReplacement(BlockState state) {
        return ChestUtil.hasReplacement(state.func_177230_c());
    }

    public static boolean hasReplacement(Block block) {
        return replacements.contains(block);
    }

    public static BlockState getReplacement(Block block, BlockState state) {
        if (!HandleBreak.specialLootChests.contains(block)) {
            if (block == Blocks.field_150486_ae) {
                return (BlockState)((BlockState)ModBlocks.CHEST.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, state.func_177229_b((IProperty)ChestBlock.field_176459_a))).func_206870_a((IProperty)ChestBlock.field_204511_c, state.func_177229_b((IProperty)ChestBlock.field_204511_c));
            }
            if (block == Blocks.field_150447_bR) {
                return (BlockState)((BlockState)ModBlocks.TRAPPED_CHEST.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, state.func_177229_b((IProperty)ChestBlock.field_176459_a))).func_206870_a((IProperty)ChestBlock.field_204511_c, state.func_177229_b((IProperty)ChestBlock.field_204511_c));
            }
            if (block == Blocks.field_222422_lK) {
                return (BlockState)((BlockState)ModBlocks.BARREL.func_176223_P().func_206870_a((IProperty)BarrelBlock.field_220092_a, state.func_177229_b((IProperty)BarrelBlock.field_220092_a))).func_206870_a((IProperty)BarrelBlock.field_220093_b, state.func_177229_b((IProperty)BarrelBlock.field_220093_b));
            }
        }
        return state;
    }

    public static boolean isTileClass(TileEntity te) {
        return tileClasses.contains(te.getClass());
    }

    static {
        tileClasses.add(ChestTileEntity.class);
        tileClasses.add(BarrelTileEntity.class);
        tileClasses.add(TrappedChestTileEntity.class);
    }
}

