/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.tiles.ILootTile;
import noobanidus.mods.lootr.util.ChestUtil;

@Mod.EventBusSubscriber(modid="lootr")
public class TickManager {
    public static final Map<GlobalPos, ResourceLocation> lootMap = Collections.synchronizedMap(new HashMap());
    private static int MAX_COUNTER = 500;
    private static final Object writeLock = new Object();
    private static final Object listLock = new Object();
    private static boolean listTicking = false;
    private static final LinkedHashSet<ITicker> waitList = new LinkedHashSet();
    private static final LinkedHashSet<ITicker> tickList = new LinkedHashSet();
    private static int integrated = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void tick(TickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.END && event.type == TickEvent.Type.CLIENT) {
            if (integrated == 0) {
                Object object = listLock;
                synchronized (object) {
                    listTicking = true;
                    tickList.clear();
                    listTicking = false;
                }
            }
        } else if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END && event.type == TickEvent.Type.SERVER) {
            if (integrated == -1) {
                integrated = FMLEnvironment.dist == Dist.CLIENT ? 1 : 0;
            }
            HashSet<ITicker> listCopy = new HashSet<ITicker>();
            HashSet<ITicker> removed = new HashSet<ITicker>();
            Object object = listLock;
            synchronized (object) {
                listTicking = true;
                listCopy.clear();
                listCopy.addAll(tickList);
                listTicking = false;
            }
            object = writeLock;
            synchronized (object) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (!listCopy.isEmpty()) {
                    for (ITicker ticker : listCopy) {
                        if (ticker.getCounter() > MAX_COUNTER) {
                            removed.add(ticker);
                            Lootr.LOG.debug("Ticker expired: " + ticker);
                            continue;
                        }
                        if (ticker.run()) {
                            Lootr.LOG.debug("Successfully executed ticker: " + ticker);
                            removed.add(ticker);
                            continue;
                        }
                        if (!ticker.invalid()) continue;
                        removed.add(ticker);
                        Lootr.LOG.debug("Invalid ticker removed: " + ticker);
                    }
                }
            }
            object = listLock;
            synchronized (object) {
                listTicking = true;
                if (removed.size() > 0) {
                    Lootr.LOG.debug("Removed " + removed.size() + " tickers: " + removed);
                }
                tickList.removeAll(removed);
                tickList.addAll(waitList);
                listTicking = false;
                waitList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTicker(ITicker ticker) {
        Object object = listLock;
        synchronized (object) {
            if (listTicking) {
                waitList.add(ticker);
            } else {
                tickList.add(ticker);
            }
        }
    }

    public static void addTicker(TileEntity tile, BlockPos pos, DimensionType type, ResourceLocation table, long seed) {
        TickManager.addTicker(new TileTicker(tile, pos, type, table, seed));
    }

    public static void addTicker(ContainerMinecartEntity entity, long seed, ResourceLocation table, BlockPos pos, DimensionType dim) {
        TickManager.addTicker(new EntityTicker(entity, seed, table, pos, dim));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trackTile(TileEntity te, ResourceLocation table, @Nullable DimensionType type) {
        Map<GlobalPos, ResourceLocation> map = lootMap;
        synchronized (map) {
            lootMap.put(GlobalPos.func_218179_a((DimensionType)type, (BlockPos)te.func_174877_v()), table);
        }
    }

    public static void trackTile(TileEntity te, ResourceLocation table) {
        TickManager.trackTile(te, table, null);
    }

    public static class TileTicker
    implements ITicker {
        private final TileEntity ref;
        private int ticker = 50;
        private int counter = 0;
        private long seed;
        private ResourceLocation table;
        private BlockPos pos;
        private DimensionType dim;

        public TileTicker(TileEntity tile, BlockPos pos, @Nullable DimensionType dim, ResourceLocation table, long seed) {
            this.ref = tile;
            this.table = table;
            if (table == null) {
                this.table = null;
            }
            this.seed = seed;
            this.pos = pos;
            this.dim = dim;
        }

        @Override
        public int getCounter() {
            return this.counter;
        }

        @Override
        public boolean invalid() {
            TileEntity te = this.ref;
            if (!ChestUtil.isTileClass(te)) {
                return true;
            }
            if (te.func_145831_w() == null) {
                return false;
            }
            if (te.func_145831_w().func_201670_d()) {
                return true;
            }
            return !te.func_145831_w().isAreaLoaded(this.pos, 1);
        }

        @Override
        public boolean run() {
            if (this.ticker-- > 0) {
                return false;
            }
            TileEntity te = this.ref;
            if (!ChestUtil.isTileClass(te)) {
                return false;
            }
            if (te.func_145831_w() == null) {
                ++this.counter;
                return false;
            }
            World world = te.func_145831_w();
            if (world.func_201670_d()) {
                return false;
            }
            if (!world.isAreaLoaded(this.pos, 1)) {
                return false;
            }
            if (!world.func_217354_b(this.pos.func_177958_n() >> 4, this.pos.func_177952_p() >> 4)) {
                return false;
            }
            BlockPos pos = te.func_174877_v();
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (ChestUtil.hasReplacement(block)) {
                BlockState replacementState = ChestUtil.getReplacement(block, state);
                if (replacementState != null) {
                    world.func_175713_t(pos);
                    world.func_175656_a(pos, replacementState);
                }
            } else {
                Lootr.LOG.debug("No replacement state found for: " + state);
            }
            te = world.func_175625_s(pos);
            if (te instanceof ILootTile) {
                ((ILootTile)te).setSeed(this.seed);
                ((ILootTile)te).setTable(this.table);
                TickManager.trackTile(te, this.table, world.func_201675_m().func_186058_p());
            } else if (te instanceof LockableLootTileEntity) {
                ((LockableLootTileEntity)te).field_184284_m = this.table;
                ((LockableLootTileEntity)te).field_184285_n = this.seed;
            }
            return true;
        }

        public String toString() {
            return "Ticker{ref=" + this.ref + ", counter=" + this.counter + ", seed=" + this.seed + ", table=" + this.table + ", pos=" + this.pos + ", dim=" + this.dim + '}';
        }
    }

    public static class EntityTicker
    implements ITicker {
        private final ContainerMinecartEntity entity;
        private int counter = 0;
        private long seed;
        private ResourceLocation table;
        private BlockPos pos;
        private DimensionType dim;

        public EntityTicker(ContainerMinecartEntity entity, long seed, ResourceLocation table, BlockPos pos, DimensionType dim) {
            this.entity = entity;
            this.seed = seed;
            this.table = table;
            this.pos = pos;
            this.dim = dim;
        }

        @Override
        public int getCounter() {
            return this.counter;
        }

        @Override
        public boolean invalid() {
            if (!this.entity.isAddedToWorld()) {
                return false;
            }
            return !this.entity.func_70089_S();
        }

        @Override
        public boolean run() {
            if (this.entity.field_70173_aa <= 50) {
                return false;
            }
            if (!this.entity.isAddedToWorld()) {
                return false;
            }
            if (!this.entity.field_70170_p.isAreaLoaded(this.pos, 1)) {
                ++this.counter;
                return false;
            }
            this.entity.dropContentsWhenDead(false);
            this.entity.func_70106_y();
            World world = this.entity.field_70170_p;
            world.func_175713_t(this.pos);
            world.func_175656_a(this.pos, ModBlocks.CHEST.func_176223_P());
            TileEntity te = world.func_175625_s(this.pos);
            if (te instanceof ILootTile) {
                ((ILootTile)te).setTable(this.table);
                ((ILootTile)te).setSeed(this.seed);
                TickManager.trackTile(te, this.table, world.func_201675_m().func_186058_p());
            }
            return true;
        }

        public String toString() {
            return "EntityTicker{entity=" + this.entity + ", counter=" + this.counter + ", seed=" + this.seed + ", table=" + this.table + ", pos=" + this.pos + ", dim=" + this.dim + '}';
        }
    }

    public static interface ITicker {
        public int getCounter();

        public boolean invalid();

        public boolean run();
    }
}

