/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.api.trinket;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Rarity;

public class Trinket<T extends Trinket>
extends Item
implements ITrinket {
    private final Map<Attribute, AttributeModifier> attributes = Maps.newHashMap();
    private final Rarity rarity;
    protected boolean unlockable = true;

    public Trinket(Rarity rarity, Item.Properties properties) {
        super(properties.func_200917_a(1));
        this.rarity = rarity;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (LostTrinketsAPI.unlock(player, this)) {
            ItemStack stack = player.func_184586_b(hand);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return ActionResult.func_226249_b_((Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        this.addTrinketDescription(stack, tooltip);
        tooltip.add((ITextComponent)new TranslationTextComponent("gui.losttrinkets.rarity." + this.getRarity().name().toLowerCase(Locale.ENGLISH)).func_240699_a_(TextFormatting.DARK_GRAY));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_230532_e_().func_240703_c_(this.getRarity().getStyle());
    }

    @Override
    public void onActivated(World world, BlockPos pos, PlayerEntity player) {
    }

    @Override
    public void onDeactivated(World world, BlockPos pos, PlayerEntity player) {
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public boolean isUnlockable() {
        return this.unlockable;
    }

    public Trinket noUnlock() {
        this.unlockable = false;
        return this;
    }

    @Override
    public void setUnlockable(boolean unlockable) {
        this.unlockable = unlockable;
    }

    public T add(Attribute attribute, String uuid, double amount) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uuid), "Attribute", amount, AttributeModifier.Operation.ADDITION);
        this.getAttributes().put(attribute, attributemodifier);
        return (T)this;
    }

    public void applyAttributes(PlayerEntity player) {
        for (Map.Entry<Attribute, AttributeModifier> entry : this.getAttributes().entrySet()) {
            AttributeModifier attributeModifier;
            ModifiableAttributeInstance attribute = player.func_110148_a(entry.getKey());
            if (attribute == null || attribute.func_180374_a(attributeModifier = entry.getValue())) continue;
            attribute.func_233769_c_(attributeModifier);
        }
    }

    public void removeAttributes(PlayerEntity player) {
        for (Map.Entry<Attribute, AttributeModifier> entry : this.getAttributes().entrySet()) {
            ModifiableAttributeInstance attribute = player.func_110148_a(entry.getKey());
            if (attribute == null) continue;
            attribute.func_111124_b(entry.getValue());
        }
    }

    public Map<Attribute, AttributeModifier> getAttributes() {
        return this.attributes;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

