/*
 * Decompiled with CFR 0.152.
 */
package lotr.client;

import java.util.List;
import lotr.client.LOTRKeyHandler;
import lotr.client.event.LOTRGuiHandler;
import lotr.client.event.LOTRTickHandlerClient;
import lotr.client.gui.AdoptCustomWaypointScreen;
import lotr.client.gui.CreateCustomWaypointScreen;
import lotr.client.gui.MiddleEarthMapScreen;
import lotr.client.gui.PlayerMessageScreen;
import lotr.client.gui.UpdateCustomWaypointScreen;
import lotr.client.gui.ViewAdoptedCustomWaypointScreen;
import lotr.client.gui.inv.AlloyForgeScreen;
import lotr.client.gui.inv.FactionCraftingScreen;
import lotr.client.gui.inv.KegScreen;
import lotr.client.render.BlockRenderHelper;
import lotr.client.render.ClientParticlesHelper;
import lotr.client.render.GeographicalWaterColors;
import lotr.client.render.entity.FallingTreasureBlockRenderer;
import lotr.client.render.entity.LOTRBoatRenderer;
import lotr.client.render.entity.RingPortalRenderer;
import lotr.client.render.entity.ThrownPlateRenderer;
import lotr.client.render.model.PlateFoodModels;
import lotr.client.render.model.SpecialItemModels;
import lotr.client.render.model.connectedtex.ConnectedTextureUnbakedModel;
import lotr.client.render.model.scatter.ScatterUnbakedModel;
import lotr.client.render.model.vessel.VesselDrinkUnbakedModel;
import lotr.client.render.tileentity.CustomWaypointMarkerTileEntityRenderer;
import lotr.client.render.tileentity.PlateTileEntityRenderer;
import lotr.common.LOTRServerProxy;
import lotr.common.data.PlayerMessageType;
import lotr.common.init.LOTRContainers;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRTileEntities;
import lotr.common.inv.KegResultSlot;
import lotr.common.inv.KegSlot;
import lotr.common.network.SPacketOpenScreen;
import lotr.common.world.map.AdoptedCustomWaypoint;
import lotr.common.world.map.CustomWaypoint;
import lotr.common.world.map.MapPlayerLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class LOTRClientProxy
extends LOTRServerProxy {
    public static final int MAX_LIGHTMAP = LightTexture.func_228451_a_((int)15, (int)15);
    private LOTRTickHandlerClient clientTickHandler;
    private LOTRGuiHandler guiHandler;
    private LOTRKeyHandler keyHandler;

    private Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    @SubscribeEvent
    public void onLoad(FMLClientSetupEvent event) {
        this.clientTickHandler = new LOTRTickHandlerClient();
        this.guiHandler = new LOTRGuiHandler();
        this.keyHandler = new LOTRKeyHandler();
        BlockRenderHelper.setupBlocks();
        GeographicalWaterColors.setupAndReplace();
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("lotr", "connected_textures"), (IModelLoader)ConnectedTextureUnbakedModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("lotr", "vessel_drink"), (IModelLoader)VesselDrinkUnbakedModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("lotr", "scatter"), (IModelLoader)ScatterUnbakedModel.Loader.INSTANCE);
        SpecialItemModels.detectSpecials();
        PlateFoodModels.INSTANCE.setupAndLoadModels(this.mc());
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.GONDOR_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.MORDOR_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.ROHAN_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.DWARVEN_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.LINDON_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.RIVENDELL_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.GALADHRIM_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.WOOD_ELVEN_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.HARAD_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.UMBAR_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.URUK_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.HOBBIT_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.BLUE_MOUNTAINS_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.RANGER_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.DOL_AMROTH_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.ANGMAR_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.DORWINION_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.DALE_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.LOSSOTH_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.DUNLENDING_CRAFTING.get()), FactionCraftingScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.ALLOY_FORGE.get()), AlloyForgeScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LOTRContainers.KEG.get()), KegScreen::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)LOTREntities.RING_PORTAL.get()), RingPortalRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)LOTREntities.THROWN_PLATE.get()), ThrownPlateRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)LOTREntities.BOAT.get()), LOTRBoatRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)LOTREntities.FALLING_TREASURE_BLOCK.get()), FallingTreasureBlockRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)LOTRTileEntities.PLATE.get()), PlateTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)LOTRTileEntities.CUSTOM_WAYPOINT_MARKER.get()), CustomWaypointMarkerTileEntityRenderer::new);
    }

    @SubscribeEvent
    public void onTextureStitchedPre(TextureStitchEvent.Pre event) {
        AtlasTexture atlas = event.getMap();
        if (atlas.func_229223_g_() == PlayerContainer.field_226615_c_) {
            event.addSprite(KegSlot.EMPTY_BUCKET_TEXTURE);
            event.addSprite(KegResultSlot.EMPTY_MUG_TEXTURE);
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        SpecialItemModels.onModelBake(event);
    }

    @SubscribeEvent
    public void onBlockColors(ColorHandlerEvent.Block event) {
        BlockRenderHelper.setupBlockColors(event);
    }

    @SubscribeEvent
    public void onItemColors(ColorHandlerEvent.Item event) {
        BlockRenderHelper.setupItemColors(event);
    }

    @SubscribeEvent
    public void onParticleRegistry(ParticleFactoryRegisterEvent event) {
        ClientParticlesHelper.register(event);
    }

    @Override
    public boolean isClient() {
        return EffectiveSide.get() == LogicalSide.CLIENT;
    }

    @Override
    public boolean isSingleplayer() {
        return this.mc().func_71356_B();
    }

    @Override
    public World getClientWorld() {
        return this.mc().field_71441_e;
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return this.mc().field_71439_g;
    }

    @Override
    public int getGeographicalWaterColorAtViewerPosition() {
        return GeographicalWaterColors.getGeographicalWaterColorAtViewerPosition(this.mc());
    }

    @Override
    public float getCurrentSandstormFogStrength() {
        return this.clientTickHandler.getCurrentSandstormFogStrength();
    }

    @Override
    public void setInRingPortal(Entity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            super.setInRingPortal(entity);
        } else {
            this.clientTickHandler.setInRingPortal(entity);
        }
    }

    @Override
    public void mapHandleIsOp(boolean isOp) {
        Screen screen = this.mc().field_71462_r;
        if (screen instanceof MiddleEarthMapScreen) {
            ((MiddleEarthMapScreen)screen).receiveIsOp(isOp);
        }
    }

    @Override
    public void mapHandlePlayerLocations(List<MapPlayerLocation> playerLocations) {
        MiddleEarthMapScreen.refreshPlayerLocations(playerLocations);
    }

    @Override
    public void displayNewDate() {
        this.clientTickHandler.displayNewDate();
    }

    @Override
    public void displayAlignmentDrain(int numFactions) {
        this.clientTickHandler.displayAlignmentDrain(numFactions);
    }

    @Override
    public void displayMessageType(PlayerMessageType messageType, boolean isCommandSent, String customText) {
        this.mc().func_147108_a((Screen)new PlayerMessageScreen(messageType, isCommandSent, customText));
    }

    @Override
    public void displayPacketOpenScreen(SPacketOpenScreen.Type type) {
        if (type == SPacketOpenScreen.Type.CREATE_CUSTOM_WAYPOINT) {
            this.mc().func_147108_a((Screen)new CreateCustomWaypointScreen());
        }
    }

    @Override
    public void displayUpdateCustomWaypointScreen(CustomWaypoint waypoint) {
        this.mc().func_147108_a((Screen)new UpdateCustomWaypointScreen(waypoint));
    }

    @Override
    public void displayAdoptCustomWaypointScreen(CustomWaypoint waypoint, String createdPlayerName) {
        this.mc().func_147108_a((Screen)new AdoptCustomWaypointScreen(waypoint, createdPlayerName));
    }

    @Override
    public void displayViewAdoptedCustomWaypointScreen(AdoptedCustomWaypoint waypoint, String createdPlayerName) {
        this.mc().func_147108_a((Screen)new ViewAdoptedCustomWaypointScreen(waypoint, createdPlayerName));
    }
}

