/*
 * Decompiled with CFR 0.152.
 */
package lotr.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import lotr.common.LOTRLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class LOTRClientUtil {
    private static final Map<ResourceLocation, Integer> averagedPageColors = new HashMap<ResourceLocation, Integer>();

    public static void blitFloat(AbstractGui gui, double x0, double y0, float u0, float v0, double w, double h) {
        LOTRClientUtil.blitFloat(x0, y0, (double)gui.getBlitOffset(), u0, v0, w, h);
    }

    public static void blitFloat(double x0, double y0, double z, float u0, float v0, double w, double h) {
        LOTRClientUtil.blitFloat(x0, y0, z, u0, v0, w, h, 256, 256);
    }

    public static void blitFloat(double x0, double y0, double z, float u0, float v0, double w, double h, int texW, int texH) {
        LOTRClientUtil.innerBlitFloat(x0, x0 + w, y0, y0 + h, z, w, h, u0, v0, texW, texH);
    }

    private static void innerBlitFloat(double x0, double x1, double y0, double y1, double z, double w, double h, float u0, float v0, int texW, int texH) {
        LOTRClientUtil.doBlitFloat(x0, x1, y0, y1, z, u0 / (float)texW, (float)((double)u0 + w) / (float)texW, v0 / (float)texH, (float)((double)v0 + h) / (float)texH);
    }

    private static void doBlitFloat(double x0, double x1, double y0, double y1, double z, float u0, float u1, float v0, float v1) {
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_225582_a_(x0, y1, z).func_225583_a_(u0, v1).func_181675_d();
        buf.func_225582_a_(x1, y1, z).func_225583_a_(u1, v1).func_181675_d();
        buf.func_225582_a_(x1, y0, z).func_225583_a_(u1, v0).func_181675_d();
        buf.func_225582_a_(x0, y0, z).func_225583_a_(u0, v0).func_181675_d();
        buf.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
    }

    public static int getAlphaInt(float alphaF) {
        int alphaI = (int)(alphaF * 255.0f);
        return MathHelper.func_76125_a((int)alphaI, (int)0, (int)255);
    }

    public static int getAlphaIntForFontRendering(float alphaF) {
        int alphaI = LOTRClientUtil.getAlphaInt(alphaF);
        return Math.max(alphaI, 4);
    }

    public static int getRGBA(int rgb, float alphaF) {
        return rgb | LOTRClientUtil.getAlphaInt(alphaF) << 24;
    }

    public static int getRGBAForFontRendering(int rgb, float alphaF) {
        return rgb | LOTRClientUtil.getAlphaIntForFontRendering(alphaF) << 24;
    }

    public static int computeAverageFactionPageColor(Minecraft mc, ResourceLocation texture, int u0, int v0, int u1, int v1) {
        if (!averagedPageColors.containsKey(texture)) {
            int avgColor = 0;
            try {
                BufferedImage pageImage = ImageIO.read(mc.func_195551_G().func_199002_a(texture).func_199027_b());
                long totalR = 0L;
                long totalG = 0L;
                long totalB = 0L;
                long totalA = 0L;
                int count = 0;
                for (int u = u0; u < u1; ++u) {
                    for (int v = v0; v < v1; ++v) {
                        int rgb = pageImage.getRGB(u, v);
                        Color color = new Color(rgb);
                        totalR += (long)color.getRed();
                        totalG += (long)color.getGreen();
                        totalB += (long)color.getBlue();
                        totalA += (long)color.getAlpha();
                        ++count;
                    }
                }
                int avgR = (int)(totalR / (long)count);
                int avgG = (int)(totalG / (long)count);
                int avgB = (int)(totalB / (long)count);
                int avgA = (int)(totalA / (long)count);
                avgColor = new Color(avgR, avgG, avgB, avgA).getRGB();
            }
            catch (IOException e) {
                LOTRLog.error("LOTR: Failed to generate average page colour for %s", texture);
                e.printStackTrace();
                avgColor = 0;
            }
            averagedPageColors.put(texture, avgColor);
            return avgColor;
        }
        return averagedPageColors.get(texture);
    }

    public static int findContrastingColor(int text, int bg) {
        Color cText = new Color(text);
        Color cBg = new Color(bg);
        float[] hsbText = Color.RGBtoHSB(cText.getRed(), cText.getGreen(), cText.getBlue(), null);
        float[] hsbBg = Color.RGBtoHSB(cBg.getRed(), cBg.getGreen(), cBg.getBlue(), null);
        float bText = hsbText[2];
        float bBg = hsbBg[2];
        float limit = 0.4f;
        if (Math.abs(bText - bBg) < limit) {
            bText = bBg > 0.66f ? bBg - limit : bBg + limit;
        }
        return Color.HSBtoRGB(hsbText[0], hsbText[1], bText);
    }

    public static int getPackedNoOverlay() {
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)0.0f), (int)OverlayTexture.func_229202_a_((boolean)false));
    }

    public static boolean doesClientChunkExist(World world, BlockPos pos) {
        return LOTRClientUtil.doesClientChunkExist(world, pos.func_177958_n(), pos.func_177952_p());
    }

    private static boolean doesClientChunkExist(World world, int x, int z) {
        return world.func_217354_b(x >> 4, z >> 4);
    }
}

