/*
 * Decompiled with CFR 0.152.
 */
package lotr.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import lotr.common.LOTRLog;
import lotr.common.config.LOTRConfig;
import lotr.common.world.map.MapSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class MapImageTextures
implements ISelectiveResourceReloadListener {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation MAP_TEXTURE = new ResourceLocation("lotr", "textures/map/loaded_map.png");
    private static final ResourceLocation SEPIA_MAP_TEXTURE = new ResourceLocation("lotr", "textures/map/loaded_map_sepia.png");
    private ResourceLocation currentMapImagePath;
    private int backgroundColor;
    private int sepiaBackgroundColor;
    public static final ResourceLocation overlayTexture = new ResourceLocation("lotr", "textures/map/overlay.png");
    public static final ResourceLocation mapIcons = new ResourceLocation("lotr", "textures/map/screen.png");
    public static final ResourceLocation mapTerrain = new ResourceLocation("lotr", "textures/map/terrain.png");
    public static final MapImageTextures INSTANCE = new MapImageTextures();
    public static final ResourceLocation OSRS_ICONS = new ResourceLocation("lotr", "map/osrs.png");
    public static final int OSRS_WATER = 6453158;
    public static final int OSRS_GRASS = 5468426;
    public static final int OSRS_BEACH = 9279778;
    public static final int OSRS_HILL = 6575407;
    public static final int OSRS_MOUNTAIN = 0xE0DDDD;
    public static final int OSRS_MOUNTAIN_EDGE = 9005125;
    public static final int OSRS_SNOW = 14215139;
    public static final int OSRS_TUNDRA = 9470587;
    public static final int OSRS_SAND = 13548147;
    public static final int OSRS_TREE = 2775058;
    public static final int OSRS_WILD = 3290677;
    public static final int OSRS_PATH = 6575407;
    public static final int OSRS_KINGDOM_COLOR = 0xFFAA00;

    private MapImageTextures() {
        IReloadableResourceManager resMgr = (IReloadableResourceManager)mc.func_195551_G();
        resMgr.func_219534_a((IFutureReloadListener)this);
    }

    public void onResourceManagerReload(IResourceManager resMgr, Predicate<IResourceType> resPredicate) {
        if (resPredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            this.currentMapImagePath = null;
            this.backgroundColor = 0;
            this.sepiaBackgroundColor = 0;
        }
    }

    public void loadMapTexturesIfNew(MapSettings mapSettings) {
        if (this.currentMapImagePath != null && mapSettings.getMapImagePath().equals((Object)this.currentMapImagePath)) {
            return;
        }
        try {
            this.currentMapImagePath = mapSettings.getMapImagePath();
            NativeImage mapImage = this.readMapImageOrOverride(mapSettings);
            NativeImage sepiaImage = MapImageTextures.convertToSepia(mapImage);
            this.backgroundColor = this.determineBackgroundColor(mapImage);
            this.sepiaBackgroundColor = this.determineBackgroundColor(sepiaImage);
            mc.func_110434_K().func_229263_a_(MAP_TEXTURE, (Texture)new DynamicTexture(mapImage));
            mc.func_110434_K().func_229263_a_(SEPIA_MAP_TEXTURE, (Texture)new DynamicTexture(MapImageTextures.convertToSepia(sepiaImage)));
        }
        catch (IOException e) {
            LOTRLog.error("Failed to load map image textures for %s", mapSettings.getMapImagePath());
            e.printStackTrace();
        }
    }

    private NativeImage readMapImageOrOverride(MapSettings mapSettings) throws IOException {
        InputStream overrideStream = this.overrideExists(mapSettings.getMapImagePath());
        if (overrideStream != null) {
            return NativeImage.func_195713_a((InputStream)overrideStream);
        }
        return NativeImage.func_195713_a((InputStream)mapSettings.createCachedImageInputStream());
    }

    private InputStream overrideExists(ResourceLocation mapImage) throws IOException {
        ResourceLocation potentialOverride = new ResourceLocation(mapImage.func_110624_b(), "textures/mapoverride/" + mapImage.func_110623_a());
        IResourceManager resMgr = mc.func_195551_G();
        if (resMgr.func_219533_b(potentialOverride)) {
            return resMgr.func_199002_a(potentialOverride).func_199027_b();
        }
        return null;
    }

    public static void drawMap(PlayerEntity player, double x0, double x1, double y0, double y1, int z, float minU, float maxU, float minV, float maxV) {
        boolean sepia = (Boolean)LOTRConfig.CLIENT.sepiaMap.get();
        MapImageTextures.drawMap(player, sepia, x0, x1, y0, y1, z, minU, maxU, minV, maxV, 1.0f);
    }

    public static void drawMap(PlayerEntity player, boolean sepia, double x0, double x1, double y0, double y1, int z, float minU, float maxU, float minV, float maxV, float alpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        mc.func_110434_K().func_110577_a(MapImageTextures.getMapTexture(player, sepia));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_225582_a_(x0, y1, (double)z).func_225583_a_(minU, maxV).func_181675_d();
        buf.func_225582_a_(x1, y1, (double)z).func_225583_a_(maxU, maxV).func_181675_d();
        buf.func_225582_a_(x1, y0, (double)z).func_225583_a_(maxU, minV).func_181675_d();
        buf.func_225582_a_(x0, y0, (double)z).func_225583_a_(minU, minV).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawMapOverlay(PlayerEntity entityplayer, double x0, double x1, double y0, double y1, double z, double minU, double maxU, double minV, double maxV) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        mc.func_110434_K().func_110577_a(overlayTexture);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_225582_a_(x0, y1, z).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buf.func_225582_a_(x1, y1, z).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buf.func_225582_a_(x1, y0, z).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buf.func_225582_a_(x0, y0, z).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawMapCompassBottomLeft(float x, float y, float z, float scale) {
        mc.func_110434_K().func_110577_a(mapIcons);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f mat = TransformationMatrix.func_227983_a_().func_227988_c_();
        int width = 32;
        int height = 32;
        float x0 = x;
        float x1 = x + (float)width * scale;
        float y0 = y - (float)height * scale;
        float y1 = y;
        int texU = 224;
        int texV = 200;
        float u0 = (float)texU / 256.0f;
        float u1 = (float)(texU + width) / 256.0f;
        float v0 = (float)texV / 256.0f;
        float v1 = (float)(texV + height) / 256.0f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_227888_a_(mat, x0, y1, z).func_225583_a_(u0, v1).func_181675_d();
        buf.func_227888_a_(mat, x1, y1, z).func_225583_a_(u1, v1).func_181675_d();
        buf.func_227888_a_(mat, x1, y0, z).func_225583_a_(u1, v0).func_181675_d();
        buf.func_227888_a_(mat, x0, y0, z).func_225583_a_(u0, v0).func_181675_d();
        tess.func_78381_a();
    }

    private static ResourceLocation getMapTexture(PlayerEntity player, boolean sepia) {
        return sepia ? SEPIA_MAP_TEXTURE : MAP_TEXTURE;
    }

    public int getMapBackgroundColor(boolean sepia) {
        return sepia ? this.sepiaBackgroundColor : this.backgroundColor;
    }

    private static NativeImage convertToSepia(NativeImage srcImage) {
        int mapWidth = srcImage.func_195702_a();
        int mapHeight = srcImage.func_195714_b();
        int[] colors = new int[mapWidth * mapHeight];
        NativeImage newMapImage = new NativeImage(NativeImage.PixelFormat.RGBA, mapWidth, mapHeight, true);
        for (int y = 0; y < mapHeight; ++y) {
            for (int x = 0; x < mapWidth; ++x) {
                int colorNative = srcImage.func_195709_a(x, y);
                int colorRGB = MapImageTextures.nativeImageColorToNormal(colorNative);
                colorRGB = MapImageTextures.getSepia(colorRGB);
                colorNative = MapImageTextures.normalColorToNative(colorRGB);
                newMapImage.func_195700_a(x, y, colorNative);
            }
        }
        return newMapImage;
    }

    private static int nativeImageColorToNormal(int abgr) {
        int a = abgr >> 24 & 0xFF;
        int b = abgr >> 16 & 0xFF;
        int g = abgr >> 8 & 0xFF;
        int r = abgr & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int normalColorToNative(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }

    private static int getSepia(int rgb) {
        Color color = new Color(rgb);
        int alpha = rgb >> 24 & 0xFF;
        float[] colors = color.getColorComponents(null);
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float newR = r * 0.79f + g * 0.39f + b * 0.26f;
        float newG = r * 0.52f + g * 0.35f + b * 0.19f;
        float newB = r * 0.35f + g * 0.26f + b * 0.15f;
        newR = MathHelper.func_76131_a((float)newR, (float)0.0f, (float)1.0f);
        newG = MathHelper.func_76131_a((float)newG, (float)0.0f, (float)1.0f);
        newB = MathHelper.func_76131_a((float)newB, (float)0.0f, (float)1.0f);
        int sepia = new Color(newR, newG, newB).getRGB();
        return sepia |= alpha << 24;
    }

    private int determineBackgroundColor(NativeImage mapImage) {
        int colorNative = mapImage.func_195709_a(0, 0);
        int colorRGB = MapImageTextures.nativeImageColorToNormal(colorNative);
        return colorRGB;
    }
}

