/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.event;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.EntityViewRenderEvent;

public class AdvancedDrunkEffect {
    private final int secondsMaxDrunk = 120;
    private int yawDirection = 1;
    private int rollDirection = 1;
    private float yawAdd;
    private float prevYawAdd;
    private float pitchAdd;
    private float prevPitchAdd;
    private float rollAdd;
    private float prevRollAdd;
    private float drunkFactor;
    private float prevDrunkFactor;

    public void update(LivingEntity viewer) {
        this.prevYawAdd = this.yawAdd;
        this.prevPitchAdd = this.pitchAdd;
        this.prevRollAdd = this.rollAdd;
        this.prevDrunkFactor = this.drunkFactor;
        if (viewer.func_70644_a(Effects.field_76431_k)) {
            float drunk = viewer.func_70660_b(Effects.field_76431_k).func_76459_b();
            drunk /= 20.0f;
            this.drunkFactor = Math.min(drunk /= 120.0f, 1.0f);
            this.yawAdd += (float)this.rollDirection * 1.2f;
            this.yawAdd = MathHelper.func_76131_a((float)this.yawAdd, (float)-30.0f, (float)30.0f);
            this.rollAdd += (float)this.rollDirection * 0.6f;
            this.rollAdd = MathHelper.func_76131_a((float)this.rollAdd, (float)-30.0f, (float)30.0f);
            if (viewer.func_70681_au().nextInt(200) == 0) {
                this.yawDirection *= -1;
            }
            if (viewer.func_70681_au().nextInt(100) == 0) {
                this.rollDirection *= -1;
            }
        } else {
            this.yawAdd = 0.0f;
            this.pitchAdd = 0.0f;
            this.rollAdd = 0.0f;
            this.drunkFactor = 0.0f;
        }
    }

    public void handle(EntityViewRenderEvent.CameraSetup event) {
        float yaw = event.getYaw();
        float pitch = event.getPitch();
        float roll = event.getRoll();
        float tick = (float)event.getRenderPartialTicks();
        float factor = this.prevDrunkFactor + (this.drunkFactor - this.prevDrunkFactor) * tick;
        event.setYaw(yaw += (this.prevYawAdd + (this.yawAdd - this.prevYawAdd) * tick) * factor);
        event.setPitch(pitch += (this.prevPitchAdd + (this.pitchAdd - this.prevPitchAdd) * tick) * factor);
        event.setRoll(roll += (this.prevRollAdd + (this.rollAdd - this.prevRollAdd) * tick) * factor);
    }

    public void reset() {
        this.rollDirection = 1;
        this.yawDirection = 1;
        this.yawAdd = 0.0f;
        this.prevYawAdd = 0.0f;
        this.pitchAdd = 0.0f;
        this.prevPitchAdd = 0.0f;
        this.rollAdd = 0.0f;
        this.prevRollAdd = 0.0f;
        this.drunkFactor = 0.0f;
        this.prevDrunkFactor = 0.0f;
    }
}

